/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.server;

import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.ExpressionResolverImpl;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.VaultReader;
import org.jboss.as.controller.logging.ControllerLogger;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;

public class RuntimeExpressionResolver
extends ExpressionResolverImpl {
    private static final Logger log = Logger.getLogger(RuntimeExpressionResolver.class);
    private static final String EXPRESSION_RESOLVER_CAPABILITY = "org.wildfly.controller.expression-resolver";
    private final VaultReader vaultReader;

    public RuntimeExpressionResolver(VaultReader vaultReader) {
        this.vaultReader = vaultReader;
    }

    protected void resolvePluggableExpression(ModelNode node, OperationContext context) throws OperationFailedException {
        String expression = node.asString();
        if (expression.length() > 3) {
            String expressionValue = expression.substring(2, expression.length() - 1);
            if (this.vaultReader == null) {
                if (VaultReader.STANDARD_VAULT_PATTERN.matcher(expressionValue).matches()) {
                    log.tracef("Cannot resolve %s -- it is in the default vault format but no vault reader is available", (Object)expressionValue);
                    throw ControllerLogger.ROOT_LOGGER.cannotResolveExpression(expression);
                }
                log.tracef("Not resolving %s -- no vault reader available and not in default vault format", (Object)expressionValue);
            } else {
                if (this.vaultReader.isVaultFormat(expressionValue)) {
                    try {
                        String retrieved = this.vaultReader.retrieveFromVault(expressionValue);
                        log.tracef("Retrieved %s from vault for %s", (Object)retrieved, (Object)expressionValue);
                        node.set(retrieved);
                        return;
                    }
                    catch (VaultReader.NoSuchItemException nsie) {
                        throw ControllerLogger.ROOT_LOGGER.cannotResolveExpression(expression);
                    }
                }
                log.tracef("Not resolving %s -- not in vault format", (Object)expressionValue);
            }
            if (context != null) {
                try {
                    ExpressionResolver expressionResolver = (ExpressionResolver)context.getCapabilityRuntimeAPI(EXPRESSION_RESOLVER_CAPABILITY, ExpressionResolver.class);
                    ModelNode result = expressionResolver.resolveExpressions(node, context);
                    if (result != null) {
                        node.set(result.asString());
                    }
                }
                catch (IllegalStateException e) {
                    log.tracef("Not resolving %s -- runtime capability not available.", (Object)expressionValue);
                }
            }
        }
    }
}

