/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.webservices.config.ServerConfigFactoryImpl;
import org.jboss.as.webservices.service.PropertyService;
import org.jboss.msc.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StopContext;
import org.jboss.wsf.spi.metadata.config.AbstractCommonConfig;
import org.jboss.wsf.spi.metadata.config.ClientConfig;
import org.jboss.wsf.spi.metadata.config.EndpointConfig;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainMetaData;

public final class ConfigService
implements Service {
    private final String configName;
    private final boolean client;
    private volatile AbstractCommonConfig config;
    private final Consumer<AbstractCommonConfig> configConsumer;
    private final List<Supplier<UnifiedHandlerChainMetaData>> preHandlerChainSuppliers;
    private final List<Supplier<UnifiedHandlerChainMetaData>> postHandlerChainSuppliers;
    private final List<Supplier<PropertyService>> propertySuppliers;

    public ConfigService(String configName, boolean client, Consumer<AbstractCommonConfig> configConsumer, List<Supplier<PropertyService>> propertySuppliers, List<Supplier<UnifiedHandlerChainMetaData>> preHandlerChainSuppliers, List<Supplier<UnifiedHandlerChainMetaData>> postHandlerChainSuppliers) {
        this.configName = configName;
        this.client = client;
        this.configConsumer = configConsumer;
        this.propertySuppliers = propertySuppliers;
        this.preHandlerChainSuppliers = preHandlerChainSuppliers;
        this.postHandlerChainSuppliers = postHandlerChainSuppliers;
    }

    public void start(StartContext context) {
        HashMap<String, String> props = null;
        if (!this.propertySuppliers.isEmpty()) {
            props = new HashMap<String, String>(this.propertySuppliers.size(), 1.0f);
            for (Supplier<PropertyService> supplier : this.propertySuppliers) {
                props.put(supplier.get().getPropName(), supplier.get().getPropValue());
            }
        }
        ArrayList<UnifiedHandlerChainMetaData> preHandlerChains = new ArrayList<UnifiedHandlerChainMetaData>();
        for (Supplier<UnifiedHandlerChainMetaData> supplier : this.preHandlerChainSuppliers) {
            preHandlerChains.add(supplier.get());
        }
        ArrayList<UnifiedHandlerChainMetaData> arrayList = new ArrayList<UnifiedHandlerChainMetaData>();
        for (Supplier<UnifiedHandlerChainMetaData> supplier : this.postHandlerChainSuppliers) {
            arrayList.add(supplier.get());
        }
        if (this.client) {
            ClientConfig clientConfig = new ClientConfig(this.configName, preHandlerChains, arrayList, props, null);
            ServerConfigFactoryImpl.getConfig().registerClientConfig(clientConfig);
            this.config = clientConfig;
            this.configConsumer.accept(this.config);
        } else {
            EndpointConfig endpointConfig = new EndpointConfig(this.configName, preHandlerChains, arrayList, props, null);
            ServerConfigFactoryImpl.getConfig().registerEndpointConfig(endpointConfig);
            this.config = endpointConfig;
            this.configConsumer.accept(this.config);
        }
    }

    public void stop(StopContext context) {
        this.configConsumer.accept(null);
        if (this.client) {
            ServerConfigFactoryImpl.getConfig().unregisterClientConfig((ClientConfig)this.config);
        } else {
            ServerConfigFactoryImpl.getConfig().unregisterEndpointConfig((EndpointConfig)this.config);
        }
        this.config = null;
    }
}

