/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.invocation;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.security.PrivilegedExceptionAction;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import javax.interceptor.InvocationContext;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import org.jboss.invocation.Interceptor;
import org.jboss.invocation.InvocationMessages;
import org.wildfly.common.function.ExceptionSupplier;

public final class InterceptorContext
implements Cloneable,
PrivilegedExceptionAction<Object> {
    static final Map<Class<?>, Class<?>> PRIMITIVES;
    private Object target;
    private Method method;
    private Constructor<?> constructor;
    private Object[] parameters;
    private Map<String, Object> contextData;
    private Object timer;
    private Interceptor[] interceptors = Interceptor.EMPTY_ARRAY;
    private int interceptorPosition = 0;
    private final Map<Object, Object> privateData;
    private InvocationContext invocationContext;
    private boolean blockingCaller = false;
    private ExceptionSupplier<Transaction, SystemException> transactionSupplier;

    public InterceptorContext() {
        this.privateData = new IdentityHashMap<Object, Object>(4);
    }

    InterceptorContext(InterceptorContext interceptorContext, boolean clone) {
        if (clone) {
            this.privateData = new IdentityHashMap<Object, Object>(interceptorContext.privateData);
            this.contextData = new HashMap<String, Object>(interceptorContext.contextData);
        } else {
            this.privateData = interceptorContext.privateData;
            this.contextData = interceptorContext.contextData;
        }
        this.target = interceptorContext.target;
        this.method = interceptorContext.method;
        this.constructor = interceptorContext.constructor;
        this.parameters = interceptorContext.parameters;
        this.timer = interceptorContext.timer;
        this.interceptors = interceptorContext.interceptors;
        this.interceptorPosition = interceptorContext.interceptorPosition;
    }

    public Object getTarget() {
        return this.target;
    }

    public void setTarget(Object target) {
        this.target = target;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public Constructor<?> getConstructor() {
        return this.constructor;
    }

    public void setConstructor(Constructor<?> constructor) {
        this.constructor = constructor;
    }

    public Object[] getParameters() {
        return this.parameters;
    }

    public void setParameters(Object[] parameters) {
        this.parameters = parameters;
    }

    public Map<String, Object> getContextData() throws IllegalStateException {
        Map<String, Object> contextData = this.contextData;
        if (contextData == null) {
            throw new IllegalStateException("The context data was not set");
        }
        return contextData;
    }

    public void setContextData(Map<String, Object> contextData) {
        this.contextData = contextData;
    }

    public Object getTimer() {
        return this.timer;
    }

    public void setTimer(Object timer) {
        this.timer = timer;
    }

    public InvocationContext getInvocationContext() {
        if (this.invocationContext == null) {
            this.invocationContext = new Invocation();
        }
        return this.invocationContext;
    }

    public boolean hasTransaction() {
        return this.transactionSupplier != null;
    }

    public Transaction getTransaction() throws SystemException {
        ExceptionSupplier<Transaction, SystemException> transactionSupplier = this.transactionSupplier;
        return transactionSupplier == null ? null : (Transaction)transactionSupplier.get();
    }

    public void setTransaction(Transaction transaction) {
        this.setTransactionSupplier((ExceptionSupplier<Transaction, SystemException>)(transaction == null ? null : () -> transaction));
    }

    public void setTransactionSupplier(ExceptionSupplier<Transaction, SystemException> transactionSupplier) {
        this.transactionSupplier = transactionSupplier;
    }

    public <T> T getPrivateData(Class<T> type) {
        return type.cast(this.privateData.get(type));
    }

    public Object getPrivateData(Object key) {
        return this.privateData.get(key);
    }

    public <T> T putPrivateData(Class<T> type, T value) {
        if (value == null) {
            return type.cast(this.privateData.remove(type));
        }
        return type.cast(this.privateData.put(type, type.cast(value)));
    }

    public Object putPrivateData(Object key, Object value) {
        if (key instanceof Class) {
            Class type = (Class)key;
            if (value == null) {
                return type.cast(this.privateData.remove(type));
            }
            return type.cast(this.privateData.put(type, type.cast(value)));
        }
        if (value == null) {
            return this.privateData.remove(key);
        }
        return this.privateData.put(key, value);
    }

    public boolean isBlockingCaller() {
        return this.blockingCaller;
    }

    public void setBlockingCaller(boolean blockingCaller) {
        this.blockingCaller = blockingCaller;
    }

    public Interceptor[] getInterceptors() {
        return this.interceptors;
    }

    public int getNextInterceptorIndex() {
        return this.interceptorPosition;
    }

    public void setInterceptors(Interceptor[] interceptors) {
        this.setInterceptors(interceptors, 0);
    }

    public void setInterceptors(List<Interceptor> interceptorList) {
        this.setInterceptors(interceptorList.toArray(Interceptor.EMPTY_ARRAY), 0);
    }

    public void setInterceptors(Interceptor[] interceptors, int nextIndex) {
        if (interceptors == null) {
            throw new IllegalArgumentException("interceptors is null");
        }
        this.interceptors = interceptors;
        this.interceptorPosition = nextIndex;
    }

    public void setInterceptors(List<Interceptor> interceptorList, int nextIndex) {
        this.setInterceptors(interceptorList.toArray(Interceptor.EMPTY_ARRAY), nextIndex);
    }

    public Object proceed() throws Exception {
        if (this.interceptorPosition < this.interceptors.length) {
            Interceptor next = this.interceptors[this.interceptorPosition++];
            try {
                Object object = next.processInvocation(this);
                return object;
            }
            finally {
                --this.interceptorPosition;
            }
        }
        throw InvocationMessages.msg.cannotProceed();
    }

    @Override
    public Object run() throws Exception {
        return this.proceed();
    }

    public InterceptorContext clone() {
        return new InterceptorContext(this, true);
    }

    static {
        HashMap map = new HashMap();
        map.put(Boolean.TYPE, Boolean.class);
        map.put(Character.TYPE, Character.class);
        map.put(Byte.TYPE, Byte.class);
        map.put(Short.TYPE, Short.class);
        map.put(Integer.TYPE, Integer.class);
        map.put(Long.TYPE, Long.class);
        map.put(Float.TYPE, Float.class);
        map.put(Double.TYPE, Double.class);
        PRIMITIVES = map;
    }

    final class Invocation
    implements InvocationContext,
    PrivilegedExceptionAction<Object> {
        Invocation() {
        }

        public Object getTarget() {
            return InterceptorContext.this.getTarget();
        }

        public Method getMethod() {
            return InterceptorContext.this.getMethod();
        }

        public Object[] getParameters() {
            Object[] parameters = InterceptorContext.this.getParameters();
            if (parameters == null) {
                throw new IllegalStateException("Cannot call InvocationContext.getParameters() in a lifecycle interceptor method");
            }
            return parameters;
        }

        public void setParameters(Object[] params) {
            Object[] parameters = InterceptorContext.this.getParameters();
            if (parameters == null) {
                throw new IllegalStateException("Cannot call InvocationContext.setParameters() in a lifecycle interceptor method");
            }
            if (params == null) {
                throw new IllegalArgumentException("Parameters must not be null");
            }
            Method method = InterceptorContext.this.getMethod();
            if (method != null) {
                Class<?>[] parameterTypes = method.getParameterTypes();
                if (params.length != parameterTypes.length) {
                    throw new IllegalArgumentException("Number of parameters must match number of method arguments");
                }
                for (int i = 0; i < params.length; ++i) {
                    Class<?> wrappedType;
                    Object param = params[i];
                    Class<?> type = parameterTypes[i];
                    if (param == null) {
                        if (!type.isPrimitive()) continue;
                        throw new IllegalArgumentException("Null cannot be assigned to primitive parameter " + i + " (" + parameterTypes[i] + ")");
                    }
                    Class<?> clazz = wrappedType = type.isPrimitive() ? PRIMITIVES.get(type) : type;
                    if (wrappedType.isAssignableFrom(param.getClass())) continue;
                    throw new IllegalArgumentException("Parameter " + i + " (" + param + ") is not assignable to method parameter type " + parameterTypes[i]);
                }
            }
            InterceptorContext.this.setParameters(params);
        }

        public Map<String, Object> getContextData() {
            return InterceptorContext.this.getContextData();
        }

        public Object getTimer() {
            return InterceptorContext.this.getTimer();
        }

        public Object proceed() throws Exception {
            return InterceptorContext.this.proceed();
        }

        @Override
        public Object run() throws Exception {
            return InterceptorContext.this.proceed();
        }

        public Constructor<?> getConstructor() {
            return InterceptorContext.this.getConstructor();
        }
    }
}

