/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.impl.aesh.cmd.security.ssl;

import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.option.Option;
import org.jboss.as.cli.CommandContext;
import org.jboss.as.cli.CommandFormatException;
import org.jboss.as.cli.impl.aesh.cmd.security.HttpServerCommandActivator;
import org.jboss.as.cli.impl.aesh.cmd.security.SecurityCommand;
import org.jboss.as.cli.impl.aesh.cmd.security.model.HTTPServer;
import org.jboss.dmr.ModelNode;
import org.wildfly.core.cli.command.DMRCommand;
import org.wildfly.core.cli.command.aesh.CLICommandInvocation;

@CommandDefinition(name="disable-ssl-http-server", description="", activator=HttpServerCommandActivator.class)
public class HTTPServerDisableSSLCommand
implements Command<CLICommandInvocation>,
DMRCommand {
    @Option(name="no-reload", hasValue=false)
    boolean noReload;
    @Option(name="server-name", completer=SecurityCommand.OptionCompleters.ServerNameCompleter.class)
    String serverName;

    public CommandResult execute(CLICommandInvocation commandInvocation) throws CommandException, InterruptedException {
        ModelNode request;
        CommandContext ctx = commandInvocation.getCommandContext();
        try {
            request = this.buildRequest(ctx);
        }
        catch (CommandFormatException ex) {
            throw new CommandException(ex.getLocalizedMessage(), (Throwable)ex);
        }
        SecurityCommand.execute(ctx, request, SecurityCommand.DEFAULT_FAILURE_CONSUMER, this.noReload);
        ctx.printLine("SSL disabled for " + this.serverName);
        return CommandResult.SUCCESS;
    }

    @Override
    public ModelNode buildRequest(CommandContext context) throws CommandFormatException {
        ModelNode composite = new ModelNode();
        composite.get("operation").set("composite");
        composite.get("address").setEmptyList();
        try {
            this.serverName = HTTPServer.disableSSL(context, this.serverName, composite.get("steps"));
        }
        catch (Exception ex) {
            throw new CommandFormatException(ex.getLocalizedMessage() == null ? ex.toString() : ex.getLocalizedMessage(), ex);
        }
        return composite;
    }
}

