/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.spi.metadata.j2ee.serviceref;

import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedExceptionAction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.QName;
import org.jboss.wsf.spi.Loggers;
import org.jboss.wsf.spi.Messages;
import org.jboss.wsf.spi.deployment.UnifiedVirtualFile;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.AddressingMetadata;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.MTOMMetadata;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.RespectBindingMetadata;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerChainsMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedHandlerMetaData;
import org.jboss.wsf.spi.metadata.j2ee.serviceref.UnifiedPortComponentRefMetaData;

public final class UnifiedServiceRefMetaData
implements Serializable {
    private static final long serialVersionUID = -3140013087984532678L;
    private volatile transient UnifiedVirtualFile vfsRoot;
    private final String serviceRefName;
    private volatile String serviceInterface;
    private volatile String serviceRefType;
    private volatile String wsdlFile;
    private final String mappingFile;
    private final QName serviceQName;
    private final List<UnifiedPortComponentRefMetaData> portComponentRefs;
    private final List<UnifiedHandlerMetaData> handlers;
    private final UnifiedHandlerChainsMetaData handlerChains;
    private final String serviceImplClass;
    private final String configName;
    private final String configFile;
    private final String wsdlOverride;
    private volatile String handlerChain;
    private volatile AddressingMetadata addressingMetadata = new AddressingMetadata(false, false, false, "ALL");
    private volatile MTOMMetadata mtomMetadata = new MTOMMetadata(false, false, 0);
    private volatile RespectBindingMetadata respectBindingMetadata = new RespectBindingMetadata(false, false);
    private final Map<QName, String> deployedServiceAddresses = Collections.synchronizedMap(new HashMap());

    public UnifiedServiceRefMetaData(UnifiedVirtualFile vfsRoot, String serviceRefName) {
        this(vfsRoot, serviceRefName, null, null, null, null, null, null, null, null, null);
    }

    public UnifiedServiceRefMetaData(UnifiedVirtualFile vfsRoot, String serviceRefName, String mappingFile, QName serviceQName, List<UnifiedPortComponentRefMetaData> portComponentRefs, List<UnifiedHandlerMetaData> handlers, UnifiedHandlerChainsMetaData handlerChains, String serviceImplClass, String configName, String configFile, String wsdlOverride) {
        this.vfsRoot = vfsRoot;
        this.serviceRefName = serviceRefName;
        this.mappingFile = mappingFile;
        this.serviceQName = serviceQName;
        this.portComponentRefs = portComponentRefs != null && !portComponentRefs.isEmpty() ? Collections.unmodifiableList(portComponentRefs) : Collections.emptyList();
        this.handlers = handlers != null && !handlers.isEmpty() ? Collections.unmodifiableList(handlers) : Collections.emptyList();
        this.handlerChains = handlerChains;
        this.serviceImplClass = serviceImplClass;
        this.configName = configName;
        this.configFile = configFile;
        this.wsdlOverride = wsdlOverride;
    }

    public UnifiedServiceRefMetaData(UnifiedVirtualFile vfsRoot, String serviceRefName, String serviceInterface, String serviceRefType, String wsdlFile, String mappingFile, QName serviceQName, List<UnifiedPortComponentRefMetaData> portComponentRefs, List<UnifiedHandlerMetaData> handlers, UnifiedHandlerChainsMetaData handlerChains, String serviceImplClass, String configName, String configFile, String wsdlOverride, String handlerChain, AddressingMetadata addressingMetadata, MTOMMetadata mtomMetadata, RespectBindingMetadata respectBindingMetadata) {
        this.vfsRoot = vfsRoot;
        this.serviceRefName = serviceRefName;
        this.serviceInterface = serviceInterface;
        this.serviceRefType = serviceRefType;
        this.wsdlFile = wsdlFile;
        this.mappingFile = mappingFile;
        this.serviceQName = serviceQName;
        this.portComponentRefs = portComponentRefs != null && !portComponentRefs.isEmpty() ? Collections.unmodifiableList(portComponentRefs) : Collections.emptyList();
        this.handlers = handlers != null && !handlers.isEmpty() ? Collections.unmodifiableList(handlers) : Collections.emptyList();
        this.handlerChains = handlerChains;
        this.serviceImplClass = serviceImplClass;
        this.configName = configName;
        this.configFile = configFile;
        this.wsdlOverride = wsdlOverride;
        this.handlerChain = handlerChain;
        this.addressingMetadata = addressingMetadata;
        this.mtomMetadata = mtomMetadata;
        this.respectBindingMetadata = respectBindingMetadata;
    }

    public boolean isAddressingAnnotationSpecified() {
        return this.addressingMetadata.isAnnotationSpecified();
    }

    public boolean isAddressingEnabled() {
        return this.addressingMetadata.isEnabled();
    }

    public boolean isAddressingRequired() {
        return this.addressingMetadata.isRequired();
    }

    public void setAddressingMedadata(AddressingMetadata addressingMetadata) {
        this.addressingMetadata = addressingMetadata;
    }

    public String getAddressingResponses() {
        return this.addressingMetadata.getResponses();
    }

    public boolean isMtomAnnotationSpecified() {
        return this.mtomMetadata.isAnnotationSpecified();
    }

    public boolean isMtomEnabled() {
        return this.mtomMetadata.isEnabled();
    }

    public int getMtomThreshold() {
        return this.mtomMetadata.getThreshold();
    }

    public void setMTOMMetadata(MTOMMetadata mtomMetadata) {
        this.mtomMetadata = mtomMetadata;
    }

    public boolean isRespectBindingAnnotationSpecified() {
        return this.respectBindingMetadata.isAnnotationSpecified();
    }

    public boolean isRespectBindingEnabled() {
        return this.respectBindingMetadata.isEnabled();
    }

    public void setRespectBindingMetadata(RespectBindingMetadata respectBindingMetadata) {
        this.respectBindingMetadata = respectBindingMetadata;
    }

    public UnifiedVirtualFile getVfsRoot() {
        return this.vfsRoot;
    }

    public void setVfsRoot(UnifiedVirtualFile vfsRoot) {
        this.vfsRoot = vfsRoot;
    }

    public String getServiceRefName() {
        return this.serviceRefName;
    }

    public String getMappingFile() {
        return this.mappingFile;
    }

    public URL getMappingLocation() {
        URL mappingURL = null;
        if (this.mappingFile != null) {
            if (this.vfsRoot != null) {
                try {
                    mappingURL = this.vfsRoot.findChild(this.mappingFile).toURL();
                }
                catch (Exception e) {
                    throw Messages.MESSAGES.cannotFindFile(e, this.mappingFile);
                }
            } else {
                mappingURL = UnifiedServiceRefMetaData.getContextClassLoader().getResource(this.mappingFile);
            }
        }
        return mappingURL;
    }

    public Collection<UnifiedPortComponentRefMetaData> getPortComponentRefs() {
        return this.portComponentRefs;
    }

    public UnifiedPortComponentRefMetaData getPortComponentRef(String seiName, QName portName) {
        UnifiedPortComponentRefMetaData matchingRef = null;
        for (UnifiedPortComponentRefMetaData ref : this.portComponentRefs) {
            if (!ref.matches(seiName, portName)) continue;
            if (matchingRef != null) {
                Loggers.METADATA_LOGGER.multipleMatchingPortComponentRef(seiName, portName);
            }
            matchingRef = ref;
        }
        return matchingRef;
    }

    public List<UnifiedHandlerMetaData> getHandlers() {
        return this.handlers;
    }

    public String getServiceInterface() {
        return this.serviceInterface;
    }

    public void setServiceInterface(String serviceInterface) {
        this.serviceInterface = serviceInterface;
    }

    public String getServiceImplClass() {
        return this.serviceImplClass;
    }

    public QName getServiceQName() {
        return this.serviceQName;
    }

    public String getServiceRefType() {
        return this.serviceRefType;
    }

    public void setServiceRefType(String serviceResType) {
        this.serviceRefType = serviceResType;
    }

    public String getWsdlFile() {
        return this.wsdlFile;
    }

    public void setWsdlFile(String wsdlFile) {
        this.wsdlFile = wsdlFile;
    }

    public URL getWsdlLocation() {
        return this.getWsdlLocation(this.wsdlOverride);
    }

    public URL getWsdlLocation(final String wsdlOverride) {
        URL wsdlLocation = null;
        if (wsdlOverride != null) {
            try {
                wsdlLocation = new URL(wsdlOverride);
            }
            catch (MalformedURLException e1) {
                if (this.vfsRoot != null) {
                    try {
                        wsdlLocation = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                            @Override
                            public URL run() throws Exception {
                                return UnifiedServiceRefMetaData.this.vfsRoot.findChild(wsdlOverride).toURL();
                            }
                        });
                    }
                    catch (Exception e) {
                        throw Messages.MESSAGES.cannotFindFile(e, wsdlOverride);
                    }
                }
                wsdlLocation = UnifiedServiceRefMetaData.getContextClassLoader().getResource(wsdlOverride);
            }
        }
        if (wsdlLocation == null && this.wsdlFile != null) {
            try {
                wsdlLocation = new URL(this.wsdlFile);
            }
            catch (MalformedURLException e1) {
                if (this.vfsRoot != null) {
                    try {
                        wsdlLocation = AccessController.doPrivileged(new PrivilegedExceptionAction<URL>(){

                            @Override
                            public URL run() throws Exception {
                                return UnifiedServiceRefMetaData.this.vfsRoot.findChild(UnifiedServiceRefMetaData.this.wsdlFile).toURL();
                            }
                        });
                    }
                    catch (Exception e) {
                        throw Messages.MESSAGES.cannotFindFile(e, this.wsdlFile);
                    }
                }
                wsdlLocation = UnifiedServiceRefMetaData.getContextClassLoader().getResource(this.wsdlFile);
            }
        }
        return wsdlLocation;
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public String getConfigName() {
        return this.configName;
    }

    public String getWsdlOverride() {
        return this.wsdlOverride;
    }

    public UnifiedHandlerChainsMetaData getHandlerChains() {
        return this.handlerChains;
    }

    public String getHandlerChain() {
        return this.handlerChain;
    }

    public void setHandlerChain(String handlerChain) {
        this.handlerChain = handlerChain;
    }

    public String getDeployedServiceAddress(QName serviceQName) {
        return this.deployedServiceAddresses.get(serviceQName);
    }

    public void addDeployedServiceAddresses(Map<QName, String> addressMap) {
        this.deployedServiceAddresses.putAll(addressMap);
    }

    private static ClassLoader getContextClassLoader() {
        if (System.getSecurityManager() == null) {
            return Thread.currentThread().getContextClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public String toString() {
        StringBuilder str = new StringBuilder();
        str.append("\nUnifiedServiceRef");
        str.append("\n serviceRefName=" + this.serviceRefName);
        str.append("\n serviceInterface=" + this.serviceInterface);
        str.append("\n serviceImplClass=" + this.serviceImplClass);
        str.append("\n serviceRefType=" + this.serviceRefType);
        str.append("\n serviceQName=" + this.serviceQName);
        str.append("\n wsdlFile=" + this.wsdlFile);
        str.append("\n wsdlOverride=" + this.wsdlOverride);
        str.append("\n mappingFile=" + this.mappingFile);
        str.append("\n configName=" + this.configName);
        str.append("\n configFile=" + this.configFile);
        str.append("\n addressingAnnotationSpecified=" + this.addressingMetadata.isAnnotationSpecified());
        str.append("\n addressingEnabled=" + this.addressingMetadata.isEnabled());
        str.append("\n addressingRequired=" + this.addressingMetadata.isRequired());
        str.append("\n addressingResponses=" + this.addressingMetadata.getResponses());
        str.append("\n mtomAnnotationSpecified=" + this.mtomMetadata.isAnnotationSpecified());
        str.append("\n mtomEnabled=" + this.mtomMetadata.isEnabled());
        str.append("\n mtomThreshold=" + this.mtomMetadata.getThreshold());
        str.append("\n respectBindingAnnotationSpecified=" + this.respectBindingMetadata.isAnnotationSpecified());
        str.append("\n respectBindingEnabled=" + this.respectBindingMetadata.isEnabled());
        str.append("\n handlerChains=" + this.handlerChains);
        str.append("\n handlerChain=" + this.handlerChain);
        for (UnifiedHandlerMetaData uhmd : this.handlers) {
            str.append(uhmd.toString());
        }
        for (UnifiedPortComponentRefMetaData pcref : this.portComponentRefs) {
            str.append(pcref.toString());
        }
        return str.toString();
    }
}

