/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.messaging.activemq.jms;

import java.util.List;
import org.jboss.as.controller.AbstractRemoveStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.messaging.activemq.MessagingServices;
import org.wildfly.extension.messaging.activemq.jms.ConnectionFactoryAttributes;
import org.wildfly.extension.messaging.activemq.jms.JMSServices;

public class PooledConnectionFactoryRemove
extends AbstractRemoveStepHandler {
    public static final PooledConnectionFactoryRemove INSTANCE = new PooledConnectionFactoryRemove();

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model) {
        ServiceName serviceName = MessagingServices.getActiveMQServiceName(context.getCurrentAddress());
        context.removeService(JMSServices.getPooledConnectionFactoryBaseServiceName(serviceName).append(new String[]{context.getCurrentAddressValue()}));
        this.removeJNDIAliases(context, model.require(ConnectionFactoryAttributes.Common.ENTRIES.getName()).asList());
    }

    protected void recoverServices(OperationContext context, ModelNode operation, ModelNode model) {
    }

    protected void removeJNDIAliases(OperationContext context, List<ModelNode> entries) {
        if (entries.size() > 1) {
            for (int i = 1; i < entries.size(); ++i) {
                ContextNames.BindInfo aliasBindInfo = ContextNames.bindInfoFor((String)entries.get(i).asString());
                context.removeService(aliasBindInfo.getBinderServiceName());
            }
        }
    }
}

