/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.time;

import java.io.IOException;
import java.time.Period;
import org.infinispan.protostream.impl.WireFormat;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class PeriodMarshaller
implements ProtoStreamMarshaller<Period> {
    private static final int YEARS_INDEX = 1;
    private static final int MONTHS_INDEX = 2;
    private static final int DAYS_INDEX = 3;

    @Override
    public Period readFrom(ProtoStreamReader reader) throws IOException {
        Period period = Period.ZERO;
        boolean reading = true;
        block5: while (reading) {
            int tag = reader.readTag();
            switch (WireFormat.getTagFieldNumber((int)tag)) {
                case 1: {
                    period = period.withYears(reader.readSInt32());
                    continue block5;
                }
                case 2: {
                    period = period.withMonths(reader.readSInt32());
                    continue block5;
                }
                case 3: {
                    period = period.withDays(reader.readSInt32());
                    continue block5;
                }
            }
            reading = tag != 0 && reader.skipField(tag);
        }
        return period;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, Period period) throws IOException {
        int days;
        int months;
        int years = period.getYears();
        if (years != 0) {
            writer.writeSInt32(1, years);
        }
        if ((months = period.getMonths()) != 0) {
            writer.writeSInt32(2, months);
        }
        if ((days = period.getDays()) != 0) {
            writer.writeSInt32(3, days);
        }
    }

    @Override
    public Class<? extends Period> getJavaClass() {
        return Period.class;
    }
}

