/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.elytron;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.ResourceDefinition;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.IntRangeValidator;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.operations.validation.StringAllowedValuesValidator;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.service.ServiceBuilder;
import org.wildfly.extension.elytron.AggregateComponentDefinition;
import org.wildfly.extension.elytron.Capabilities;
import org.wildfly.extension.elytron.TrivialAddHandler;
import org.wildfly.extension.elytron.TrivialResourceDefinition;
import org.wildfly.extension.elytron.TrivialService;
import org.wildfly.security.auth.server.EvidenceDecoder;
import org.wildfly.security.x500.principal.X500SubjectEvidenceDecoder;
import org.wildfly.security.x500.principal.X509SubjectAltNameEvidenceDecoder;

class EvidenceDecoderDefinitions {
    private static final String RFC_822_NAME = "rfc822Name";
    private static final String DNS_NAME = "dNSName";
    private static final String DIRECTORY_NAME = "directoryName";
    private static final String URI_NAME = "uniformResourceIdentifier";
    private static final String IP_ADDRESS = "iPAddress";
    private static final String REGISTERED_ID = "registeredID";
    static final SimpleAttributeDefinition ALT_NAME_TYPE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("alt-name-type", ModelType.STRING, false).setValidator((ParameterValidator)new StringAllowedValuesValidator(new String[]{"rfc822Name", "dNSName", "directoryName", "uniformResourceIdentifier", "iPAddress", "registeredID"}))).setAllowExpression(true)).setRestartAllServices()).build();
    static final SimpleAttributeDefinition SEGMENT = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("segment", ModelType.INT, true).setAllowExpression(true)).setDefaultValue(ModelNode.ZERO)).setValidator((ParameterValidator)new IntRangeValidator(0, true, true))).setRestartAllServices()).build();
    private static final AggregateComponentDefinition<EvidenceDecoder> AGGREGATE_EVIDENCE_DECODER = AggregateComponentDefinition.create(EvidenceDecoder.class, "aggregate-evidence-decoder", "evidence-decoders", Capabilities.EVIDENCE_DECODER_RUNTIME_CAPABILITY, EvidenceDecoder::aggregate);

    EvidenceDecoderDefinitions() {
    }

    static ResourceDefinition getX500SubjectEvidenceDecoderDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{};
        TrivialAddHandler<EvidenceDecoder> add = new TrivialAddHandler<EvidenceDecoder>(EvidenceDecoder.class, attributes, Capabilities.EVIDENCE_DECODER_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<EvidenceDecoder> getValueSupplier(ServiceBuilder<EvidenceDecoder> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                return () -> new X500SubjectEvidenceDecoder();
            }
        };
        return new TrivialResourceDefinition("x500-subject-evidence-decoder", add, attributes, Capabilities.EVIDENCE_DECODER_RUNTIME_CAPABILITY);
    }

    static ResourceDefinition getX509SubjectAltNameEvidenceDecoderDefinition() {
        AttributeDefinition[] attributes = new AttributeDefinition[]{ALT_NAME_TYPE, SEGMENT};
        TrivialAddHandler<EvidenceDecoder> add = new TrivialAddHandler<EvidenceDecoder>(EvidenceDecoder.class, attributes, Capabilities.EVIDENCE_DECODER_RUNTIME_CAPABILITY){

            @Override
            protected TrivialService.ValueSupplier<EvidenceDecoder> getValueSupplier(ServiceBuilder<EvidenceDecoder> serviceBuilder, OperationContext context, ModelNode model) throws OperationFailedException {
                String altNameType = ALT_NAME_TYPE.resolveModelAttribute(context, model).asString();
                int segment = SEGMENT.resolveModelAttribute(context, model).asInt();
                return () -> new X509SubjectAltNameEvidenceDecoder(SubjectAltNameType.fromName(altNameType).getType(), segment);
            }
        };
        return new TrivialResourceDefinition("x509-subject-alt-name-evidence-decoder", add, attributes, Capabilities.EVIDENCE_DECODER_RUNTIME_CAPABILITY);
    }

    static AggregateComponentDefinition<EvidenceDecoder> getAggregateEvidenceDecoderDefinition() {
        return AGGREGATE_EVIDENCE_DECODER;
    }

    private static enum SubjectAltNameType {
        RFC_822_NAME_TYPE("rfc822Name", 1),
        DNS_NAME_TYPE("dNSName", 2),
        DIRECTORY_NAME_TYPE("directoryName", 4),
        URI_NAME_TYPE("uniformResourceIdentifier", 6),
        IP_ADDRESS_TYPE("iPAddress", 7),
        REGISTERED_ID_TYPE("registeredID", 8);

        private final String name;
        private final int type;

        private SubjectAltNameType(String name, int type) {
            this.name = name;
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public int getType() {
            return this.type;
        }

        public static SubjectAltNameType fromName(String name) {
            switch (name) {
                case "rfc822Name": {
                    return RFC_822_NAME_TYPE;
                }
                case "dNSName": {
                    return DNS_NAME_TYPE;
                }
                case "directoryName": {
                    return DIRECTORY_NAME_TYPE;
                }
                case "uniformResourceIdentifier": {
                    return URI_NAME_TYPE;
                }
                case "iPAddress": {
                    return IP_ADDRESS_TYPE;
                }
                case "registeredID": {
                    return REGISTERED_ID_TYPE;
                }
            }
            throw new IllegalArgumentException(name);
        }
    }
}

