/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.controller;

import java.util.function.Predicate;
import org.jboss.as.clustering.controller.BinaryCapabilityNameResolver;
import org.jboss.as.clustering.controller.Capability;
import org.jboss.as.clustering.controller.ResourceCapabilityReference;
import org.jboss.as.clustering.controller.UnaryCapabilityNameResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.registry.Resource;
import org.jboss.dmr.ModelNode;
import org.wildfly.clustering.service.BinaryRequirement;
import org.wildfly.clustering.service.Requirement;
import org.wildfly.clustering.service.UnaryRequirement;

public class PredicateCapabilityReference
extends ResourceCapabilityReference {
    private static final Predicate<ModelNode> BOOLEAN = ModelNode::asBoolean;
    private final Predicate<ModelNode> predicate;

    public PredicateCapabilityReference(Capability capability, Requirement requirement) {
        this(capability, requirement, BOOLEAN);
    }

    public PredicateCapabilityReference(Capability capability, Requirement requirement, Predicate<ModelNode> predicate) {
        super(capability, requirement);
        this.predicate = predicate;
    }

    public PredicateCapabilityReference(Capability capability, UnaryRequirement requirement, UnaryCapabilityNameResolver requirementNameResolver) {
        this(capability, requirement, requirementNameResolver, BOOLEAN);
    }

    public PredicateCapabilityReference(Capability capability, UnaryRequirement requirement, UnaryCapabilityNameResolver requirementNameResolver, Predicate<ModelNode> predicate) {
        super(capability, requirement, requirementNameResolver);
        this.predicate = predicate;
    }

    public PredicateCapabilityReference(Capability capability, BinaryRequirement requirement, BinaryCapabilityNameResolver requirementNameResolver) {
        this(capability, requirement, requirementNameResolver, BOOLEAN);
    }

    public PredicateCapabilityReference(Capability capability, BinaryRequirement requirement, BinaryCapabilityNameResolver requirementNameResolver, Predicate<ModelNode> predicate) {
        super(capability, requirement, requirementNameResolver);
        this.predicate = predicate;
    }

    @Override
    public void addCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... values) {
        for (String value : values) {
            if (!this.predicate.test(new ModelNode(value))) continue;
            super.addCapabilityRequirements(context, resource, attributeName, value);
        }
    }

    @Override
    public void removeCapabilityRequirements(OperationContext context, Resource resource, String attributeName, String ... values) {
        for (String value : values) {
            if (!this.predicate.test(new ModelNode(value))) continue;
            super.removeCapabilityRequirements(context, resource, attributeName, value);
        }
    }
}

