/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.KeyPair;
import java.security.KeyStore;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import javax.net.ssl.SSLContext;
import org.jboss.as.clustering.controller.Attribute;
import org.jboss.as.clustering.controller.CommonUnaryRequirement;
import org.jboss.as.clustering.controller.CredentialSourceDependency;
import org.jboss.as.clustering.controller.ResourceServiceConfigurator;
import org.jboss.as.clustering.dmr.ModelNodes;
import org.jboss.as.controller.ExpressionResolver;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.wildfly.clustering.service.CompositeDependency;
import org.wildfly.clustering.service.Dependency;
import org.wildfly.clustering.service.FunctionalService;
import org.wildfly.clustering.service.ServiceConfigurator;
import org.wildfly.clustering.service.ServiceNameProvider;
import org.wildfly.clustering.service.ServiceSupplierDependency;
import org.wildfly.clustering.service.SupplierDependency;
import org.wildfly.extension.undertow.ApplicationSecurityDomainSingleSignOnDefinition;
import org.wildfly.extension.undertow.SingleSignOnManagerServiceNameProvider;
import org.wildfly.extension.undertow.SingleSignOnSessionFactoryServiceNameProvider;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.wildfly.security.credential.PasswordCredential;
import org.wildfly.security.credential.source.CredentialSource;
import org.wildfly.security.http.util.sso.DefaultSingleSignOnSessionFactory;
import org.wildfly.security.http.util.sso.SingleSignOnManager;
import org.wildfly.security.http.util.sso.SingleSignOnSessionFactory;
import org.wildfly.security.password.interfaces.ClearPassword;

public class SingleSignOnSessionFactoryServiceConfigurator
extends SingleSignOnSessionFactoryServiceNameProvider
implements ResourceServiceConfigurator,
Supplier<SingleSignOnSessionFactory> {
    private final SupplierDependency<SingleSignOnManager> manager;
    private volatile SupplierDependency<KeyStore> keyStore;
    private volatile SupplierDependency<SSLContext> sslContext;
    private volatile SupplierDependency<CredentialSource> credentialSource;
    private volatile String keyAlias;

    public SingleSignOnSessionFactoryServiceConfigurator(String securityDomainName) {
        super(securityDomainName);
        this.manager = new ServiceSupplierDependency((ServiceNameProvider)new SingleSignOnManagerServiceNameProvider(securityDomainName));
    }

    public ServiceConfigurator configure(OperationContext context, ModelNode model) throws OperationFailedException {
        String keyStore = ApplicationSecurityDomainSingleSignOnDefinition.Attribute.KEY_STORE.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.keyStore = new ServiceSupplierDependency(CommonUnaryRequirement.KEY_STORE.getServiceName(context, keyStore));
        this.keyAlias = ApplicationSecurityDomainSingleSignOnDefinition.Attribute.KEY_ALIAS.resolveModelAttribute((ExpressionResolver)context, model).asString();
        this.credentialSource = new CredentialSourceDependency(context, (Attribute)ApplicationSecurityDomainSingleSignOnDefinition.Attribute.CREDENTIAL, model);
        Optional sslContext = ModelNodes.optionalString((ModelNode)ApplicationSecurityDomainSingleSignOnDefinition.Attribute.SSL_CONTEXT.resolveModelAttribute((ExpressionResolver)context, model));
        this.sslContext = sslContext.map(value -> new ServiceSupplierDependency(CommonUnaryRequirement.SSL_CONTEXT.getServiceName(context, value))).orElse(null);
        return this;
    }

    public ServiceBuilder<?> build(ServiceTarget target) {
        ServiceBuilder builder = target.addService(this.getServiceName());
        Consumer factory = new CompositeDependency(new Dependency[]{this.manager, this.keyStore, this.credentialSource, this.sslContext}).register(builder).provides(new ServiceName[]{this.getServiceName()});
        FunctionalService service = new FunctionalService(factory, Function.identity(), (Supplier)this);
        return builder.setInstance((Service)service);
    }

    @Override
    public SingleSignOnSessionFactory get() {
        KeyStore store = (KeyStore)this.keyStore.get();
        String alias = this.keyAlias;
        CredentialSource source = (CredentialSource)this.credentialSource.get();
        try {
            if (!store.containsAlias(alias)) {
                throw UndertowLogger.ROOT_LOGGER.missingKeyStoreEntry(alias);
            }
            if (!store.entryInstanceOf(alias, KeyStore.PrivateKeyEntry.class)) {
                throw UndertowLogger.ROOT_LOGGER.keyStoreEntryNotPrivate(alias);
            }
            PasswordCredential credential = (PasswordCredential)source.getCredential(PasswordCredential.class);
            if (credential == null) {
                throw UndertowLogger.ROOT_LOGGER.missingCredential(source.toString());
            }
            ClearPassword password = (ClearPassword)credential.getPassword(ClearPassword.class);
            if (password == null) {
                throw UndertowLogger.ROOT_LOGGER.credentialNotClearPassword(credential.toString());
            }
            KeyStore.PrivateKeyEntry entry = (KeyStore.PrivateKeyEntry)store.getEntry(alias, new KeyStore.PasswordProtection(password.getPassword()));
            KeyPair keyPair = new KeyPair(entry.getCertificate().getPublicKey(), entry.getPrivateKey());
            Optional<SSLContext> context = Optional.ofNullable(this.sslContext).map(dependency -> (SSLContext)dependency.get());
            return new DefaultSingleSignOnSessionFactory((SingleSignOnManager)this.manager.get(), keyPair, connection -> context.ifPresent(ctx -> connection.setSSLSocketFactory(ctx.getSocketFactory())));
        }
        catch (IOException | GeneralSecurityException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

