/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.envers.query.criteria.internal;

import org.hibernate.engine.spi.SessionImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.envers.boot.internal.EnversService;
import org.hibernate.envers.exception.AuditException;
import org.hibernate.envers.internal.entities.RelationDescription;
import org.hibernate.envers.internal.reader.AuditReaderImplementor;
import org.hibernate.envers.internal.tools.query.Parameters;
import org.hibernate.envers.internal.tools.query.QueryBuilder;
import org.hibernate.envers.query.criteria.internal.AbstractAtomicExpression;
import org.hibernate.envers.query.criteria.internal.CriteriaTools;
import org.hibernate.envers.query.internal.property.PropertyNameGetter;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.type.ComponentType;
import org.hibernate.type.Type;

public class SimpleAuditExpression
extends AbstractAtomicExpression {
    private PropertyNameGetter propertyNameGetter;
    private Object value;
    private String op;

    public SimpleAuditExpression(String alias, PropertyNameGetter propertyNameGetter, Object value, String op) {
        super(alias);
        this.propertyNameGetter = propertyNameGetter;
        this.value = value;
        this.op = op;
    }

    @Override
    protected void addToQuery(EnversService enversService, AuditReaderImplementor versionsReader, String entityName, String alias, QueryBuilder qb, Parameters parameters) {
        String propertyName = CriteriaTools.determinePropertyName(enversService, versionsReader, entityName, this.propertyNameGetter);
        RelationDescription relatedEntity = CriteriaTools.getRelatedEntity(enversService, entityName, propertyName);
        if (relatedEntity == null) {
            SessionImplementor session = versionsReader.getSessionImplementor();
            Type type = this.getPropertyType(session, entityName, propertyName);
            if (type != null && type.isComponentType()) {
                if (!"=".equals(this.op) && !"<>".equals(this.op)) {
                    throw new AuditException("Component-based criterion is not supported for op: " + this.op);
                }
                ComponentType componentType = (ComponentType)type;
                for (int i = 0; i < componentType.getPropertyNames().length; ++i) {
                    Object componentValue = componentType.getPropertyValue(this.value, i, (SharedSessionContractImplementor)session);
                    parameters.addWhereWithParam(alias, propertyName + "_" + componentType.getPropertyNames()[i], this.op, componentValue);
                }
            } else {
                parameters.addWhereWithParam(alias, propertyName, this.op, this.value);
            }
        } else {
            if (!"=".equals(this.op) && !"<>".equals(this.op)) {
                throw new AuditException("This type of operation: " + this.op + " (" + entityName + "." + propertyName + ") isn't supported and can't be used in queries.");
            }
            Object id = relatedEntity.getIdMapper().mapToIdFromEntity(this.value);
            relatedEntity.getIdMapper().addIdEqualsToQuery(parameters, id, alias, null, "=".equals(this.op));
        }
    }

    private Type getPropertyType(SessionImplementor session, String entityName, String propertyName) {
        EntityPersister persister = session.getSessionFactory().getMetamodel().entityPersister(entityName);
        for (String name : persister.getPropertyNames()) {
            if (!name.equals(propertyName)) continue;
            return persister.getPropertyType(propertyName);
        }
        return null;
    }
}

