/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.threads;

import java.security.AccessControlContext;
import java.security.AccessController;
import org.jboss.threads.DirectExecutor;

class PrivilegedExecutor
implements DirectExecutor {
    private final DirectExecutor delegate;
    private final AccessControlContext context;

    PrivilegedExecutor(DirectExecutor delegate) {
        this.delegate = delegate;
        this.context = AccessController.getContext();
    }

    @Override
    public void execute(Runnable command) {
        AccessController.doPrivileged(() -> {
            this.delegate.execute(command);
            return null;
        }, this.context);
    }

    public String toString() {
        return String.format("%s (for %s) -> %s", super.toString(), this.context, this.delegate);
    }
}

