/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.ejb3.component.stateful;

import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Supplier;
import org.jboss.as.ee.component.BasicComponentCreateService;
import org.jboss.as.ee.component.ComponentConfiguration;
import org.jboss.as.ee.component.ComponentStartService;
import org.jboss.as.ee.component.DependencyConfigurator;
import org.jboss.as.ejb3.cache.CacheFactory;
import org.jboss.as.ejb3.component.DefaultAccessTimeoutService;
import org.jboss.as.ejb3.component.EJBComponentCreateServiceFactory;
import org.jboss.as.ejb3.component.stateful.StatefulComponentDescription;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentCreateService;
import org.jboss.as.ejb3.component.stateful.StatefulSessionComponentInstance;
import org.jboss.as.ejb3.logging.EjbLogger;
import org.jboss.as.ejb3.subsystem.DefaultStatefulBeanSessionTimeoutWriteHandler;
import org.jboss.ejb.client.SessionID;
import org.jboss.msc.service.ServiceBuilder;
import org.wildfly.clustering.service.InjectedValueDependency;
import org.wildfly.clustering.service.SupplierDependency;

public class StatefulComponentCreateServiceFactory
extends EJBComponentCreateServiceFactory {
    public BasicComponentCreateService constructService(ComponentConfiguration configuration) {
        if (this.ejbJarConfiguration == null) {
            throw EjbLogger.ROOT_LOGGER.ejbJarConfigNotBeenSet(this, configuration.getComponentName());
        }
        configuration.getCreateDependencies().add(new DependencyConfigurator<StatefulSessionComponentCreateService>(){

            public void configureDependency(ServiceBuilder<?> serviceBuilder, StatefulSessionComponentCreateService componentCreateService) {
                serviceBuilder.addDependency(DefaultAccessTimeoutService.STATEFUL_SERVICE_NAME, DefaultAccessTimeoutService.class, componentCreateService.getDefaultAccessTimeoutInjector());
                serviceBuilder.addDependency(DefaultStatefulBeanSessionTimeoutWriteHandler.SERVICE_NAME, AtomicLong.class, componentCreateService.getDefaultStatefulSessionTimeoutInjector());
            }
        });
        StatefulComponentDescription description = (StatefulComponentDescription)configuration.getComponentDescription();
        InjectedValueDependency cacheFactory = new InjectedValueDependency(description.getCacheFactoryServiceName(), CacheFactory.class);
        configuration.getStartDependencies().add(new DependencyConfigurator<ComponentStartService>((SupplierDependency)cacheFactory){
            final /* synthetic */ SupplierDependency val$cacheFactory;
            {
                this.val$cacheFactory = supplierDependency;
            }

            public void configureDependency(ServiceBuilder<?> builder, ComponentStartService service) {
                this.val$cacheFactory.register(builder);
            }
        });
        return new StatefulSessionComponentCreateService(configuration, this.ejbJarConfiguration, (Supplier<CacheFactory<SessionID, StatefulSessionComponentInstance>>)cacheFactory);
    }
}

