/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.management.client.content;

import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.management.client.content.ManagedDMRContentTypeResource;
import org.jboss.as.management.client.content.ManagedDMRContentTypeResourceDefinition;
import org.jboss.as.repository.ContentReference;
import org.jboss.as.repository.ContentRepository;
import org.jboss.as.repository.HostFileRepository;
import org.jboss.dmr.ModelNode;

public class ManagedDMRContentTypeAddHandler
implements OperationStepHandler {
    private final ContentRepository contentRepository;
    private final HostFileRepository fileRepository;
    private final String childType;

    ManagedDMRContentTypeAddHandler(ContentRepository contentRepository, HostFileRepository fileRepository, String childType) {
        this.contentRepository = contentRepository;
        this.fileRepository = fileRepository;
        this.childType = childType;
    }

    public void execute(OperationContext context, ModelNode operation) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        byte[] hash = ManagedDMRContentTypeResourceDefinition.HASH.validateOperation(operation).asBytesOrNull();
        if (hash != null && this.fileRepository != null) {
            this.fileRepository.getDeploymentFiles(new ContentReference(address.toCLIStyleString(), hash));
        }
        ManagedDMRContentTypeResource resource = new ManagedDMRContentTypeResource(address, this.childType, hash, this.contentRepository);
        context.addResource(PathAddress.EMPTY_ADDRESS, (Resource)resource);
    }
}

