/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.security.manager.deployment;

import java.security.Permission;
import java.util.List;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.modules.security.FactoryPermissionCollection;
import org.jboss.modules.security.ImmediatePermissionFactory;
import org.jboss.modules.security.PermissionFactory;
import org.wildfly.extension.security.manager.logging.SecurityManagerLogger;

public class PermissionsValidationProcessor
implements DeploymentUnitProcessor {
    private FactoryPermissionCollection maxPermissions;

    public PermissionsValidationProcessor(List<PermissionFactory> maxPermissions) {
        this.maxPermissions = new FactoryPermissionCollection(maxPermissions.toArray(new PermissionFactory[maxPermissions.size()]));
    }

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        List permissionFactories = ((ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION)).getPermissionFactories();
        StringBuilder failedPermissions = new StringBuilder();
        for (PermissionFactory factory : permissionFactories) {
            Permission permission;
            if (factory instanceof ImmediatePermissionFactory || (permission = factory.construct()) == null || this.maxPermissions.implies(permission)) continue;
            failedPermissions.append("\n\t\t").append(permission);
        }
        if (failedPermissions.length() > 0) {
            throw SecurityManagerLogger.ROOT_LOGGER.invalidDeploymentConfiguration(failedPermissions);
        }
    }

    public void undeploy(DeploymentUnit context) {
    }
}

