/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream;

import java.io.IOException;
import java.util.OptionalInt;
import java.util.function.Function;
import org.infinispan.protostream.ImmutableSerializationContext;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public class FunctionalFieldSetMarshaller<T, B>
implements ProtoStreamMarshaller<T> {
    private static final int START_INDEX = 1;
    private final Class<? extends T> targetClass;
    private final FieldSetMarshaller<T, B> marshaller;
    private final Function<B, T> build;

    public FunctionalFieldSetMarshaller(Class<? extends T> targetClass, FieldSetMarshaller<T, B> marshaller, Function<B, T> factory) {
        this.targetClass = targetClass;
        this.marshaller = marshaller;
        this.build = factory;
    }

    @Override
    public T readFrom(ProtoStreamReader reader) throws IOException {
        B builder = this.marshaller.getBuilder();
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (index >= 1 && index < 1 + this.marshaller.getFields()) {
                builder = this.marshaller.readField(reader, index - 1, builder);
                continue;
            }
            reader.skipField(tag);
        }
        return this.build.apply(builder);
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, T value) throws IOException {
        this.marshaller.writeFields(writer, 1, value);
    }

    @Override
    public OptionalInt size(ImmutableSerializationContext context, T value) {
        return this.marshaller.size(context, 1, value);
    }

    @Override
    public Class<? extends T> getJavaClass() {
        return this.targetClass;
    }
}

