/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import java.util.ServiceLoader;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.CapabilityServiceBuilder;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.web.host.CommonWebServer;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.wildfly.extension.undertow.ListenerResourceDefinition;
import org.wildfly.extension.undertow.Server;
import org.wildfly.extension.undertow.ServerDefinition;
import org.wildfly.extension.undertow.ServletContainerService;
import org.wildfly.extension.undertow.UndertowExtension;
import org.wildfly.extension.undertow.UndertowRootDefinition;
import org.wildfly.extension.undertow.UndertowService;
import org.wildfly.extension.undertow.WebServerService;
import org.wildfly.extension.undertow.session.DistributableServerRuntimeHandler;

final class ServerAdd
extends AbstractAddStepHandler {
    ServerAdd() {
        super(new AbstractAddStepHandler.Parameters().addAttribute(ServerDefinition.ATTRIBUTES).addRuntimeCapability(new RuntimeCapability[]{ServerDefinition.SERVER_CAPABILITY}));
    }

    protected void performRuntime(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        PathAddress address = context.getCurrentAddress();
        ModelNode parentModel = context.readResourceFromRoot(address.getParent(), false).getModel();
        String name = context.getCurrentAddressValue();
        String defaultHost = ServerDefinition.DEFAULT_HOST.resolveModelAttribute(context, resource.getModel()).asString();
        String servletContainer = ServerDefinition.SERVLET_CONTAINER.resolveModelAttribute(context, resource.getModel()).asString();
        String defaultServerName = UndertowRootDefinition.DEFAULT_SERVER.resolveModelAttribute(context, parentModel).asString();
        boolean isDefaultServer = name.equals(defaultServerName);
        CapabilityServiceBuilder sb = context.getCapabilityServiceTarget().addCapability(ServerDefinition.SERVER_CAPABILITY);
        Consumer sConsumer = isDefaultServer ? sb.provides(ServerDefinition.SERVER_CAPABILITY, UndertowService.DEFAULT_SERVER, new ServiceName[0]) : sb.provides(new RuntimeCapability[]{ServerDefinition.SERVER_CAPABILITY});
        Supplier scsSupplier = sb.requiresCapability("org.wildfly.undertow.servlet-container", ServletContainerService.class, new String[]{servletContainer});
        Supplier usSupplier = sb.requiresCapability("org.wildfly.undertow", UndertowService.class, new String[0]);
        sb.setInstance((Service)new Server(sConsumer, scsSupplier, usSupplier, name, defaultHost));
        sb.install();
        if (isDefaultServer) {
            CapabilityServiceBuilder csb = context.getCapabilityServiceTarget().addCapability(CommonWebServer.CAPABILITY);
            Consumer wssConsumer = csb.provides(CommonWebServer.CAPABILITY, CommonWebServer.SERVICE_NAME, new ServiceName[0]);
            Supplier sSupplier = csb.requiresCapability("org.wildfly.undertow.server", Server.class, new String[]{name});
            csb.setInstance((Service)new WebServerService(wssConsumer, sSupplier));
            csb.setInitialMode(ServiceController.Mode.PASSIVE);
            this.addCommonHostListenerDeps(context, (ServiceBuilder<?>)csb, UndertowExtension.HTTP_LISTENER_PATH);
            this.addCommonHostListenerDeps(context, (ServiceBuilder<?>)csb, UndertowExtension.AJP_LISTENER_PATH);
            this.addCommonHostListenerDeps(context, (ServiceBuilder<?>)csb, UndertowExtension.HTTPS_LISTENER_PATH);
            csb.install();
        }
        for (DistributableServerRuntimeHandler handler : ServiceLoader.load(DistributableServerRuntimeHandler.class, DistributableServerRuntimeHandler.class.getClassLoader())) {
            handler.execute(context, name);
        }
    }

    protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        super.recordCapabilitiesAndRequirements(context, operation, resource);
        ModelNode parentModel = context.readResourceFromRoot(context.getCurrentAddress().getParent(), false).getModel();
        String defaultServerName = UndertowRootDefinition.DEFAULT_SERVER.resolveModelAttribute(context, parentModel).asString();
        boolean isDefaultServer = context.getCurrentAddressValue().equals(defaultServerName);
        if (isDefaultServer) {
            context.registerCapability(CommonWebServer.CAPABILITY);
        }
    }

    private void addCommonHostListenerDeps(OperationContext context, ServiceBuilder<?> builder, PathElement listenerPath) {
        ModelNode listeners = Resource.Tools.readModel((Resource)context.readResource(PathAddress.pathAddress((PathElement[])new PathElement[]{listenerPath})), (int)1);
        if (listeners.isDefined()) {
            for (Property p : listeners.asPropertyList()) {
                for (Property listener : p.getValue().asPropertyList()) {
                    builder.requires(ListenerResourceDefinition.LISTENER_CAPABILITY.getCapabilityServiceName(new String[]{listener.getName()}));
                }
            }
        }
    }
}

