/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelOnlyAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.operations.common.Util;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.remoting.RemotingEndpointResource;
import org.jboss.dmr.ModelNode;

class RemotingEndpointAdd
extends ModelOnlyAddStepHandler {
    RemotingEndpointAdd() {
        super(new AttributeDefinition[0]);
    }

    protected Resource createResource(OperationContext context) {
        try {
            return context.readResourceForUpdate(PathAddress.EMPTY_ADDRESS);
        }
        catch (Resource.NoSuchResourceException noSuchResourceException) {
            return super.createResource(context);
        }
    }

    protected void populateModel(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
        PathAddress parentAddress = context.getCurrentAddress().getParent();
        ModelNode parentModel = context.readResourceFromRoot(parentAddress, false).getModel();
        OperationStepHandler writeHandler = null;
        ModelNode baseWriteOp = null;
        for (AttributeDefinition ad : RemotingEndpointResource.ATTRIBUTES.values()) {
            ModelNode opVal;
            String attr = ad.getName();
            ModelNode parentVal = parentModel.get(attr);
            if (parentVal.equals(opVal = operation.has(attr) ? operation.get(attr) : new ModelNode())) continue;
            if (writeHandler == null) {
                writeHandler = context.getRootResourceRegistration().getOperationHandler(parentAddress, "write-attribute");
                baseWriteOp = Util.createEmptyOperation((String)"write-attribute", (PathAddress)parentAddress);
            }
            ModelNode writeOp = baseWriteOp.clone();
            writeOp.get("name").set(attr);
            writeOp.get("value").set(opVal);
            context.addStep(writeOp, writeHandler, OperationContext.Stage.MODEL, true);
        }
    }
}

