/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.arjuna.coordinator;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AsyncAfterSynchronization;
import com.arjuna.ats.arjuna.coordinator.AsyncBeforeSynchronization;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.coordinator.HeuristicNotification;
import com.arjuna.ats.arjuna.coordinator.Reapable;
import com.arjuna.ats.arjuna.coordinator.SynchronizationRecord;
import com.arjuna.ats.arjuna.coordinator.TwoPhaseCommitThreadPool;
import com.arjuna.ats.arjuna.coordinator.TxControl;
import com.arjuna.ats.arjuna.logging.tsLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.Stack;
import java.util.TreeSet;
import java.util.concurrent.CompletionService;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

public class TwoPhaseCoordinator
extends BasicAction
implements Reapable {
    private SortedSet<SynchronizationRecord> _synchs;
    private List<Future<Boolean>> runningSynchronizations = null;
    private CompletionService<Boolean> synchronizationCompletionService = null;
    private boolean executingInterposedSynchs = false;
    private SynchronizationRecord _currentRecord;
    private Throwable _deferredThrowable;
    private Object _syncLock = new Object();
    private boolean _beforeCalled = false;
    private boolean _afterCalled = false;

    public TwoPhaseCoordinator() {
    }

    public TwoPhaseCoordinator(Uid id) {
        super(id);
    }

    public int start() {
        return this.start(BasicAction.Current());
    }

    public int start(BasicAction parentAction) {
        if (parentAction != null && this.typeOfAction() == 1) {
            parentAction.addChildAction(this);
        }
        return super.Begin(parentAction);
    }

    public int end(boolean report_heuristics) {
        if (this.parent() != null) {
            this.parent().removeChildAction(this);
        }
        boolean canEnd = true;
        if (this.status() != 3 || TxControl.isBeforeCompletionWhenRollbackOnly()) {
            canEnd = this.beforeCompletion();
        }
        int outcome = canEnd ? super.End(report_heuristics) : super.Abort();
        this.afterCompletion(outcome, report_heuristics);
        return outcome;
    }

    @Override
    public int cancel() {
        int outcome;
        if (this.parent() != null) {
            this.parent().removeChildAction(this);
        }
        if ((outcome = super.Abort(true)) == 4) {
            this.afterCompletion(outcome);
        }
        return outcome;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addSynchronization(SynchronizationRecord sr) {
        if (sr == null) {
            return 3;
        }
        int result = 3;
        if (this.parent() != null) {
            return 3;
        }
        switch (this.status()) {
            case 0: 
            case 1: {
                if (this.runningSynchronizations != null) {
                    if (this.executingInterposedSynchs && !sr.isInterposed()) {
                        return 3;
                    }
                    this.runningSynchronizations.add(this.synchronizationCompletionService.submit(new AsyncBeforeSynchronization(this, sr)));
                    return 2;
                }
                if (this._currentRecord != null && sr.compareTo(this._currentRecord) != 1) {
                    return 3;
                }
                Object object = this._syncLock;
                synchronized (object) {
                    if (this._synchs == null) {
                        this._synchs = new TreeSet<SynchronizationRecord>();
                    }
                    if (this._synchs.add(sr)) {
                        result = 2;
                    }
                    break;
                }
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean asyncBeforeCompletion() {
        boolean problem = false;
        ArrayList<SynchronizationRecord> interposedSynchs = new ArrayList<SynchronizationRecord>();
        Object object = this._syncLock;
        synchronized (object) {
            this.synchronizationCompletionService = TwoPhaseCommitThreadPool.getNewCompletionService();
            this.runningSynchronizations = new ArrayList<Future<Boolean>>(this._synchs.size());
            for (SynchronizationRecord synchRecord : this._synchs) {
                if (synchRecord.isInterposed()) {
                    interposedSynchs.add(synchRecord);
                    continue;
                }
                this.runningSynchronizations.add(this.synchronizationCompletionService.submit(new AsyncBeforeSynchronization(this, synchRecord)));
            }
        }
        try {
            int processed = 0;
            do {
                Object object2 = this._syncLock;
                synchronized (object2) {
                    if (processed == this.runningSynchronizations.size()) {
                        if (this.executingInterposedSynchs || interposedSynchs.size() == 0) {
                            break;
                        }
                        this.executingInterposedSynchs = true;
                        processed = 0;
                        this.runningSynchronizations.clear();
                        for (SynchronizationRecord synchRecord : interposedSynchs) {
                            this.runningSynchronizations.add(this.synchronizationCompletionService.submit(new AsyncBeforeSynchronization(this, synchRecord)));
                        }
                    }
                }
                ++processed;
                try {
                    if (this.synchronizationCompletionService.take().get().booleanValue()) continue;
                    problem = true;
                }
                catch (ExecutionException e) {
                    if (this._deferredThrowable == null) {
                        this._deferredThrowable = e.getCause();
                    }
                    problem = true;
                }
                catch (InterruptedException e) {
                    tsLogger.i18NLogger.warn_coordinator_TwoPhaseCoordinator_2(this._currentRecord.toString(), e);
                    problem = true;
                }
            } while (!problem);
        }
        finally {
            try {
                for (Future<Boolean> f : this.runningSynchronizations) {
                    f.cancel(false);
                }
            }
            finally {
                this.runningSynchronizations.clear();
            }
        }
        return !problem;
    }

    @Override
    public boolean running() {
        return this.status() == 0 || this.status() == 3;
    }

    @Override
    public String type() {
        return "/StateManager/BasicAction/AtomicAction/TwoPhaseCoordinator";
    }

    public Throwable getDeferredThrowable() {
        return this._deferredThrowable;
    }

    protected TwoPhaseCoordinator(int at) {
        super(at);
    }

    protected TwoPhaseCoordinator(Uid u, int at) {
        super(u, at);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean beforeCompletion() {
        boolean problem = false;
        Object object = this._syncLock;
        synchronized (object) {
            if (!this._beforeCalled) {
                this._beforeCalled = true;
                if (this._synchs != null) {
                    if (TxControl.asyncBeforeSynch && this._synchs.size() > 1) {
                        problem = !this.asyncBeforeCompletion();
                    } else {
                        int lastIndexProcessed = -1;
                        SynchronizationRecord[] copiedSynchs = this._synchs.toArray(new SynchronizationRecord[0]);
                        while (lastIndexProcessed < this._synchs.size() - 1 && !problem) {
                            if (copiedSynchs.length != this._synchs.size()) {
                                copiedSynchs = this._synchs.toArray(new SynchronizationRecord[0]);
                            }
                            this._currentRecord = copiedSynchs[++lastIndexProcessed];
                            try {
                                problem = !this._currentRecord.beforeCompletion();
                            }
                            catch (Exception ex) {
                                tsLogger.i18NLogger.warn_coordinator_TwoPhaseCoordinator_2(this._currentRecord.toString(), ex);
                                if (this._deferredThrowable == null) {
                                    this._deferredThrowable = ex;
                                }
                                problem = true;
                            }
                            catch (Error er) {
                                tsLogger.i18NLogger.warn_coordinator_TwoPhaseCoordinator_2(this._currentRecord.toString(), er);
                                if (this._deferredThrowable == null) {
                                    this._deferredThrowable = er;
                                }
                                problem = true;
                            }
                        }
                    }
                }
            }
            if (problem && !this.preventCommit()) {
                tsLogger.i18NLogger.warn_coordinator_TwoPhaseCoordinator_1();
            }
        }
        return !problem;
    }

    protected boolean asyncAfterCompletion(int myStatus, boolean report_heuristics) {
        boolean problem = false;
        if (this.synchronizationCompletionService == null) {
            this.synchronizationCompletionService = TwoPhaseCommitThreadPool.getNewCompletionService();
        }
        if (this.runningSynchronizations == null) {
            this.runningSynchronizations = new ArrayList<Future<Boolean>>(this._synchs.size());
        }
        Iterator i = this._synchs.iterator();
        while (i.hasNext()) {
            SynchronizationRecord synchRecord = (SynchronizationRecord)i.next();
            if (!report_heuristics && synchRecord instanceof HeuristicNotification) {
                ((HeuristicNotification)synchRecord).heuristicOutcome(this.getHeuristicDecision());
            }
            if (!synchRecord.isInterposed()) continue;
            i.remove();
            this.runningSynchronizations.add(this.synchronizationCompletionService.submit(new AsyncAfterSynchronization(this, synchRecord, myStatus)));
        }
        int processed = 0;
        this.executingInterposedSynchs = true;
        while (true) {
            if (processed == this.runningSynchronizations.size()) {
                if (!this.executingInterposedSynchs || this._synchs.size() == 0) break;
                this.executingInterposedSynchs = false;
                processed = 0;
                this.runningSynchronizations.clear();
                for (SynchronizationRecord synchRecord : this._synchs) {
                    this.runningSynchronizations.add(this.synchronizationCompletionService.submit(new AsyncAfterSynchronization(this, synchRecord, myStatus)));
                }
                this._synchs.clear();
            }
            ++processed;
            try {
                if (this.synchronizationCompletionService.take().get().booleanValue()) continue;
                problem = true;
            }
            catch (InterruptedException e) {
                problem = true;
            }
            catch (ExecutionException e) {
                problem = true;
            }
        }
        return !problem;
    }

    protected boolean afterCompletion(int myStatus) {
        return this.afterCompletion(myStatus, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean afterCompletion(int myStatus, boolean report_heuristics) {
        if (myStatus == 0) {
            tsLogger.i18NLogger.warn_coordinator_TwoPhaseCoordinator_3();
            return false;
        }
        boolean problem = false;
        Object object = this._syncLock;
        synchronized (object) {
            if (!this._afterCalled) {
                this._afterCalled = true;
                if (this._synchs == null) {
                    return !problem;
                }
                if (TxControl.asyncAfterSynch && this._synchs.size() > 1) {
                    problem = this.asyncAfterCompletion(myStatus, report_heuristics);
                } else {
                    Stack stack = new Stack();
                    Iterator iterator = this._synchs.iterator();
                    try {
                        while (iterator.hasNext()) {
                            stack.push(iterator.next());
                        }
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                    while (!stack.isEmpty()) {
                        SynchronizationRecord record = (SynchronizationRecord)stack.pop();
                        if (!report_heuristics && record instanceof HeuristicNotification) {
                            ((HeuristicNotification)record).heuristicOutcome(this.getHeuristicDecision());
                        }
                        try {
                            if (record.afterCompletion(myStatus)) continue;
                            tsLogger.i18NLogger.warn_coordinator_TwoPhaseCoordinator_4(record.toString());
                            problem = true;
                        }
                        catch (Exception ex) {
                            tsLogger.i18NLogger.warn_coordinator_TwoPhaseCoordinator_4a(record.toString(), ex);
                            problem = true;
                        }
                        catch (Error er) {
                            tsLogger.i18NLogger.warn_coordinator_TwoPhaseCoordinator_4b(record.toString(), er);
                            problem = true;
                        }
                    }
                    this._synchs.clear();
                }
            }
        }
        return !problem;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<Uid, String> getSynchronizations() {
        HashMap<Uid, String> synchs = new HashMap<Uid, String>();
        Object object = this._syncLock;
        synchronized (object) {
            if (this._synchs != null) {
                for (Object e : this._synchs) {
                    SynchronizationRecord synch = (SynchronizationRecord)e;
                    synchs.put(synch.get_uid(), synch.toString());
                }
            }
        }
        return synchs;
    }

    @Override
    public synchronized void recordStackTraces() {
        super.recordStackTraces();
    }

    @Override
    public synchronized void outputCapturedStackTraces() {
        super.outputCapturedStackTraces();
    }
}

