/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.MemoryConfiguration;
import org.infinispan.configuration.cache.PersistenceConfiguration;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.interceptors.locking.ClusteringDependentLogic;
import org.infinispan.interceptors.locking.OrderedClusteringDependentLogic;
import org.infinispan.util.logging.Log;

@DefaultFactoryFor(classes={ClusteringDependentLogic.class})
public class ClusteringDependentLogicFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    @Override
    public Object construct(String componentName) {
        ClusteringDependentLogic.AbstractClusteringDependentLogic cdl;
        CacheMode cacheMode = this.configuration.clustering().cacheMode();
        if (!cacheMode.isClustered()) {
            cdl = new ClusteringDependentLogic.LocalLogic();
        } else if (cacheMode.isInvalidation()) {
            cdl = new ClusteringDependentLogic.InvalidationLogic();
        } else if (cacheMode.isReplicated()) {
            cdl = new ClusteringDependentLogic.ReplicationLogic();
        } else if (cacheMode.isDistributed()) {
            cdl = new ClusteringDependentLogic.DistributionLogic();
        } else if (cacheMode.isScattered()) {
            cdl = new ClusteringDependentLogic.ScatteredLogic();
        } else {
            throw Log.CONTAINER.factoryCannotConstructComponent(componentName);
        }
        MemoryConfiguration memoryConfiguration = this.configuration.memory();
        PersistenceConfiguration persistenceConfiguration = this.configuration.persistence();
        boolean usingStores = persistenceConfiguration.usingStores();
        if (memoryConfiguration.isEvictionEnabled() || usingStores) {
            boolean passivation = usingStores && persistenceConfiguration.passivation();
            return new OrderedClusteringDependentLogic(cdl, passivation);
        }
        return cdl;
    }
}

