/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.core.launcher;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.wildfly.core.launcher.Arguments;
import org.wildfly.core.launcher.CommandBuilder;
import org.wildfly.core.launcher.Environment;
import org.wildfly.core.launcher.Jvm;
import org.wildfly.core.launcher.logger.LauncherMessages;

abstract class AbstractCommandBuilder<T extends AbstractCommandBuilder<T>>
implements CommandBuilder {
    static final String HOME_DIR = "jboss.home.dir";
    static final String SECURITY_MANAGER_ARG = "-secmgr";
    static final String SECURITY_MANAGER_PROP = "java.security.manager";
    static final String[] DEFAULT_VM_ARGUMENTS;
    static final Collection<String> DEFAULT_MODULAR_VM_ARGUMENTS;
    protected final Environment environment;
    private boolean useSecMgr;
    private Path logDir;
    private Path configDir;
    private final Arguments serverArgs;

    protected AbstractCommandBuilder(Path wildflyHome) {
        this(wildflyHome, null);
    }

    protected AbstractCommandBuilder(Path wildflyHome, Jvm jvm) {
        this.environment = new Environment(wildflyHome).setJvm(jvm);
        this.useSecMgr = false;
        this.serverArgs = new Arguments();
    }

    public T setUseSecurityManager(boolean useSecMgr) {
        this.useSecMgr = useSecMgr;
        return this.getThis();
    }

    public boolean useSecurityManager() {
        return this.useSecMgr;
    }

    public T addModuleDir(String moduleDir) {
        this.environment.addModuleDir(moduleDir);
        return this.getThis();
    }

    public T addModuleDirs(String ... moduleDirs) {
        this.environment.addModuleDirs(moduleDirs);
        return this.getThis();
    }

    public T addModuleDirs(Iterable<String> moduleDirs) {
        this.environment.addModuleDirs(moduleDirs);
        return this.getThis();
    }

    public T setModuleDirs(Iterable<String> moduleDirs) {
        this.environment.setModuleDirs(moduleDirs);
        return this.getThis();
    }

    public T setModuleDirs(String ... moduleDirs) {
        this.environment.setModuleDirs(moduleDirs);
        return this.getThis();
    }

    public String getModulePaths() {
        return this.environment.getModulePaths();
    }

    public Path getLogDirectory() {
        if (this.logDir == null) {
            return this.normalizePath(this.getBaseDirectory(), "log");
        }
        return this.logDir;
    }

    public T setLogDirectory(String path) {
        if (path == null) {
            this.logDir = null;
            return this.getThis();
        }
        return this.setLogDirectory(Paths.get(path, new String[0]));
    }

    public T setLogDirectory(Path path) {
        if (path == null) {
            this.logDir = null;
        } else {
            if (Files.exists(path, new LinkOption[0]) && !Files.isDirectory(path, new LinkOption[0])) {
                throw LauncherMessages.MESSAGES.invalidDirectory(path);
            }
            this.logDir = path.toAbsolutePath().normalize();
        }
        return this.getThis();
    }

    public Path getConfigurationDirectory() {
        if (this.configDir == null) {
            return this.normalizePath(this.getBaseDirectory(), "configuration");
        }
        return this.configDir;
    }

    public T setConfigurationDirectory(String path) {
        this.configDir = AbstractCommandBuilder.validateAndNormalizeDir(path, true);
        return this.getThis();
    }

    public T setConfigurationDirectory(Path path) {
        this.configDir = AbstractCommandBuilder.validateAndNormalizeDir(path, true);
        return this.getThis();
    }

    public T addServerArgument(String arg) {
        Arguments.Argument argument;
        if (arg != null && this.addServerArgument(argument = Arguments.parse(arg))) {
            if (SECURITY_MANAGER_ARG.equals(arg)) {
                this.setUseSecurityManager(true);
            } else {
                this.serverArgs.add(argument);
            }
        }
        return this.getThis();
    }

    public T addServerArguments(String ... args) {
        if (args != null) {
            for (String arg : args) {
                this.addServerArgument(arg);
            }
        }
        return this.getThis();
    }

    public T addServerArguments(Iterable<String> args) {
        if (args != null) {
            for (String arg : args) {
                this.addServerArgument(arg);
            }
        }
        return this.getThis();
    }

    public T setAdminOnly() {
        return this.addServerArgument("--admin-only");
    }

    public T setStartSuspended() {
        return this.addServerArgument("--start-mode=suspend");
    }

    public T setBindAddressHint(String address) {
        this.setSingleServerArg("-b", address);
        return this.getThis();
    }

    public T setBindAddressHint(String interfaceName, String address) {
        if (interfaceName == null) {
            throw LauncherMessages.MESSAGES.nullParam("interfaceName");
        }
        this.setSingleServerArg("-b" + interfaceName, address);
        return this.getThis();
    }

    public T setMulticastAddressHint(String address) {
        this.setSingleServerArg("-u", address);
        return this.getThis();
    }

    public T addPropertiesFile(String file) {
        if (file != null) {
            this.addPropertiesFile(Paths.get(file, new String[0]));
        }
        return this.getThis();
    }

    public T addPropertiesFile(Path file) {
        if (file != null) {
            if (Files.notExists(file, new LinkOption[0])) {
                throw LauncherMessages.MESSAGES.pathDoesNotExist(file);
            }
            if (!Files.isRegularFile(file, new LinkOption[0])) {
                throw LauncherMessages.MESSAGES.pathNotAFile(file);
            }
            this.addServerArg("-P", file.toAbsolutePath().normalize().toString());
        }
        return this.getThis();
    }

    public T setPropertiesFile(String file) {
        Path path = file == null ? null : Paths.get(file, new String[0]);
        return this.setPropertiesFile(path);
    }

    public T setPropertiesFile(Path file) {
        this.serverArgs.remove("-P");
        return this.addPropertiesFile(file);
    }

    public Path getWildFlyHome() {
        return this.environment.getWildflyHome();
    }

    public abstract Path getJavaHome();

    protected String getLoggingPropertiesArgument(String fileName) {
        return "-Dlogging.configuration=file:" + this.normalizePath(this.getConfigurationDirectory(), fileName);
    }

    protected String getBootLogArgument(String fileName) {
        return "-Dorg.jboss.boot.log.file=" + this.normalizePath(this.getLogDirectory(), fileName);
    }

    public String getModulesJarName() {
        return this.environment.getModuleJar().toString();
    }

    protected Path normalizePath(String path) {
        return this.environment.resolvePath(path).toAbsolutePath().normalize();
    }

    protected Path normalizePath(Path parent, String path) {
        return parent.resolve(path).toAbsolutePath().normalize();
    }

    public abstract Path getBaseDirectory();

    public List<String> getServerArguments() {
        return this.serverArgs.asList();
    }

    protected abstract T getThis();

    protected void setSingleServerArg(String key, String value) {
        this.serverArgs.set(key, value);
    }

    protected void addServerArg(String key, String value) {
        this.serverArgs.add(key, value);
    }

    protected String getServerArg(String key) {
        return this.serverArgs.get(key);
    }

    abstract boolean addServerArgument(Arguments.Argument var1);

    protected static Path validateAndNormalizeDir(String path, boolean allowNull) {
        if (path == null) {
            if (allowNull) {
                return null;
            }
            throw LauncherMessages.MESSAGES.pathDoesNotExist(null);
        }
        return AbstractCommandBuilder.validateAndNormalizeDir(Paths.get(path, new String[0]), allowNull);
    }

    protected static Path validateAndNormalizeDir(Path path, boolean allowNull) {
        if (allowNull && path == null) {
            return null;
        }
        if (path == null || Files.notExists(path, new LinkOption[0])) {
            throw LauncherMessages.MESSAGES.pathDoesNotExist(path);
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            throw LauncherMessages.MESSAGES.invalidDirectory(path);
        }
        return path.toAbsolutePath().normalize();
    }

    protected static void addSystemPropertyArg(List<String> cmd, String key, Object value) {
        if (value != null) {
            cmd.add("-D" + key + "=" + value);
        }
    }

    static {
        ArrayList<String> javaOpts = new ArrayList<String>();
        javaOpts.add("-Xms64m");
        javaOpts.add("-Xmx512m");
        javaOpts.add("-Djava.net.preferIPv4Stack=true");
        javaOpts.add("-Djava.awt.headless=true");
        javaOpts.add("-Djboss.modules.system.pkgs=org.jboss.byteman");
        DEFAULT_VM_ARGUMENTS = javaOpts.toArray(new String[javaOpts.size()]);
        ArrayList<String> modularJavaOpts = new ArrayList<String>();
        modularJavaOpts.add("--add-exports=java.desktop/sun.awt=ALL-UNNAMED");
        modularJavaOpts.add("--add-opens=java.base/java.lang=ALL-UNNAMED");
        modularJavaOpts.add("--add-opens=java.base/java.lang.invoke=ALL-UNNAMED");
        modularJavaOpts.add("--add-opens=java.base/java.io=ALL-UNNAMED");
        modularJavaOpts.add("--add-opens=java.base/java.security=ALL-UNNAMED");
        modularJavaOpts.add("--add-opens=java.base/java.util=ALL-UNNAMED");
        modularJavaOpts.add("--add-opens=java.management/javax.management=ALL-UNNAMED");
        modularJavaOpts.add("--add-opens=java.naming/javax.naming=ALL-UNNAMED");
        modularJavaOpts.add("--add-modules=java.se");
        DEFAULT_MODULAR_VM_ARGUMENTS = Collections.unmodifiableList(modularJavaOpts);
    }
}

