/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.connector.subsystems.datasources;

import java.util.Map;
import org.jboss.as.connector.logging.ConnectorLogger;
import org.jboss.as.connector.subsystems.datasources.Constants;
import org.jboss.as.connector.subsystems.datasources.DataSourceDefinition;
import org.jboss.as.connector.subsystems.datasources.JdbcDriverDefinition;
import org.jboss.as.connector.subsystems.datasources.XaDataSourceDefinition;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.security.CredentialReference;
import org.jboss.as.controller.transform.ExtensionTransformerRegistration;
import org.jboss.as.controller.transform.SubsystemTransformerRegistration;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.ChainedTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.DiscardAttributeChecker;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.TransformationDescription;
import org.jboss.as.controller.transform.description.TransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;

public class DataSourcesTransformers
implements ExtensionTransformerRegistration {
    private static final String LEGACY_MCP = "org.jboss.jca.core.connectionmanager.pool.mcp.SemaphoreArrayListManagedConnectionPool";
    private static final ModelVersion EAP_6_2 = ModelVersion.create((int)1, (int)2, (int)0);
    private static final ModelVersion EAP_6_3 = ModelVersion.create((int)1, (int)3, (int)0);
    private static final ModelVersion EAP_7_0 = ModelVersion.create((int)4, (int)0, (int)0);
    private static final ModelVersion EAP_7_1 = ModelVersion.create((int)5, (int)0, (int)0);

    public String getSubsystemName() {
        return "datasources";
    }

    public void registerTransformers(SubsystemTransformerRegistration subsystemRegistration) {
        ChainedTransformationDescriptionBuilder chainedBuilder = TransformationDescriptionBuilder.Factory.createChainedSubystemInstance((ModelVersion)subsystemRegistration.getCurrentSubsystemVersion());
        DataSourcesTransformers.get500TransformationDescription(chainedBuilder.createBuilder(subsystemRegistration.getCurrentSubsystemVersion(), EAP_7_1));
        DataSourcesTransformers.get400TransformationDescription(chainedBuilder.createBuilder(EAP_7_1, EAP_7_0));
        DataSourcesTransformers.get130TransformationDescription(chainedBuilder.createBuilder(EAP_7_0, EAP_6_3));
        DataSourcesTransformers.get120TransformationDescription(chainedBuilder.createBuilder(EAP_6_3, EAP_6_2));
        chainedBuilder.buildAndRegister(subsystemRegistration, (ModelVersion[][])new ModelVersion[][]{{EAP_6_2, EAP_6_3, EAP_7_0, EAP_7_1}});
    }

    static TransformationDescription get130TransformationDescription(ResourceTransformationDescriptionBuilder parentBuilder) {
        ResourceTransformationDescriptionBuilder builder = parentBuilder.addChildResource(DataSourceDefinition.PATH_DATASOURCE);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DefaultDiscardAttributeChecker(){

            protected boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return attributeValue.equals(ModelNode.FALSE);
            }
        }, new AttributeDefinition[]{Constants.TRACKING})).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new String[]{"enabled"})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Constants.TRACKING})).end();
        builder = parentBuilder.addChildResource(XaDataSourceDefinition.PATH_XA_DATASOURCE);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DefaultDiscardAttributeChecker(){

            protected boolean isValueDiscardable(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return attributeValue.equals(ModelNode.FALSE);
            }
        }, new AttributeDefinition[]{Constants.TRACKING})).addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new String[]{"enabled"})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Constants.TRACKING})).end();
        return parentBuilder.build();
    }

    static TransformationDescription get120TransformationDescription(ResourceTransformationDescriptionBuilder parentBuilder) {
        ResourceTransformationDescriptionBuilder builder = parentBuilder.addChildResource(DataSourceDefinition.PATH_DATASOURCE);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FAIR, Constants.CONNECTABLE, Constants.ENLISTMENT_TRACE})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, false, new ModelNode[]{ModelNode.TRUE}), new String[]{"statistics-enabled"})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(LEGACY_MCP)}), new AttributeDefinition[]{Constants.MCP})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{org.jboss.as.connector.subsystems.common.pool.Constants.POOL_FAIR})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.SimpleRejectAttributeChecker(ModelNode.FALSE), new AttributeDefinition[]{Constants.ENLISTMENT_TRACE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Constants.MCP})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                return ConnectorLogger.ROOT_LOGGER.rejectAttributesMustBeTrue(attributes.keySet());
            }

            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return !attributeValue.isDefined() || !attributeValue.asString().equals("true");
            }
        }, new String[]{"statistics-enabled"})).end().addOperationTransformationOverride(Constants.DATASOURCE_ENABLE.getName()).end().addOperationTransformationOverride(Constants.DATASOURCE_DISABLE.getName()).end();
        builder = parentBuilder.addChildResource(XaDataSourceDefinition.PATH_XA_DATASOURCE);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{Constants.CONNECTABLE, Constants.ENLISTMENT_TRACE})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(false, false, new ModelNode[]{ModelNode.TRUE}), new String[]{"statistics-enabled"})).setDiscard((DiscardAttributeChecker)new DiscardAttributeChecker.DiscardAttributeValueChecker(new ModelNode[]{new ModelNode(LEGACY_MCP)}), new AttributeDefinition[]{Constants.MCP})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Constants.ENLISTMENT_TRACE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Constants.MCP})).addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                return ConnectorLogger.ROOT_LOGGER.rejectAttributesMustBeTrue(attributes.keySet());
            }

            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return !attributeValue.isDefined() || !attributeValue.asString().equals("true");
            }
        }, new String[]{"statistics-enabled"})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{Constants.TRACKING})).end().addOperationTransformationOverride(Constants.DATASOURCE_ENABLE.getName()).end().addOperationTransformationOverride(Constants.DATASOURCE_DISABLE.getName()).end();
        return parentBuilder.build();
    }

    private static TransformationDescription get400TransformationDescription(ResourceTransformationDescriptionBuilder parentBuilder) {
        ResourceTransformationDescriptionBuilder builder = parentBuilder.addChildResource(DataSourceDefinition.PATH_DATASOURCE);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{Constants.ELYTRON_ENABLED})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{Constants.AUTHENTICATION_CONTEXT, Constants.CREDENTIAL_REFERENCE})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Constants.ELYTRON_ENABLED, Constants.AUTHENTICATION_CONTEXT, Constants.CREDENTIAL_REFERENCE})).addRejectCheck(DataSourcesTransformers.createConnURLRejectChecker(), new AttributeDefinition[]{Constants.CONNECTION_URL})).setValueConverter(AttributeConverter.DEFAULT_VALUE, new AttributeDefinition[]{Constants.ENLISTMENT_TRACE})).end();
        builder = parentBuilder.addChildResource(XaDataSourceDefinition.PATH_XA_DATASOURCE);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setDiscard(DiscardAttributeChecker.DEFAULT_VALUE, new AttributeDefinition[]{Constants.ELYTRON_ENABLED, Constants.RECOVERY_ELYTRON_ENABLED})).setDiscard(DiscardAttributeChecker.UNDEFINED, new AttributeDefinition[]{Constants.RECOVERY_CREDENTIAL_REFERENCE, Constants.RECOVERY_AUTHENTICATION_CONTEXT, Constants.CREDENTIAL_REFERENCE, Constants.AUTHENTICATION_CONTEXT})).addRejectCheck(RejectAttributeChecker.DEFINED, new AttributeDefinition[]{Constants.RECOVERY_CREDENTIAL_REFERENCE, Constants.RECOVERY_ELYTRON_ENABLED, Constants.ELYTRON_ENABLED, Constants.RECOVERY_AUTHENTICATION_CONTEXT, Constants.CREDENTIAL_REFERENCE, Constants.AUTHENTICATION_CONTEXT})).setValueConverter(AttributeConverter.DEFAULT_VALUE, new AttributeDefinition[]{Constants.ENLISTMENT_TRACE})).end();
        ((AttributeTransformationDescriptionBuilder)parentBuilder.addChildResource(JdbcDriverDefinition.PATH_DRIVER).getAttributeBuilder().addRejectCheck(RejectAttributeChecker.SIMPLE_EXPRESSIONS, new AttributeDefinition[]{Constants.MODULE_SLOT, Constants.JDBC_COMPLIANT, Constants.PROFILE, Constants.DRIVER_MODULE_NAME, Constants.DRIVER_XA_DATASOURCE_CLASS_NAME, Constants.DRIVER_CLASS_NAME})).end();
        return parentBuilder.build();
    }

    private static TransformationDescription get500TransformationDescription(ResourceTransformationDescriptionBuilder parentBuilder) {
        ResourceTransformationDescriptionBuilder builder = parentBuilder.addChildResource(DataSourceDefinition.PATH_DATASOURCE);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRejectCheck(CredentialReference.REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT, new AttributeDefinition[]{Constants.CREDENTIAL_REFERENCE})).addRejectCheck(CredentialReference.REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT, new AttributeDefinition[]{Constants.RECOVERY_CREDENTIAL_REFERENCE})).end();
        builder = parentBuilder.addChildResource(XaDataSourceDefinition.PATH_XA_DATASOURCE);
        ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().addRejectCheck(CredentialReference.REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT, new AttributeDefinition[]{Constants.CREDENTIAL_REFERENCE})).addRejectCheck(CredentialReference.REJECT_CREDENTIAL_REFERENCE_WITH_BOTH_STORE_AND_CLEAR_TEXT, new AttributeDefinition[]{Constants.RECOVERY_CREDENTIAL_REFERENCE})).end();
        return parentBuilder.build();
    }

    private static RejectAttributeChecker createConnURLRejectChecker() {
        return new RejectAttributeChecker.DefaultRejectAttributeChecker(){

            public String getRejectionLogMessage(Map<String, ModelNode> attributes) {
                return RejectAttributeChecker.UNDEFINED.getRejectionLogMessage(attributes);
            }

            public boolean rejectOperationParameter(PathAddress address, String attributeName, ModelNode attributeValue, ModelNode operation, TransformationContext context) {
                return operation.get("operation").asString().equals("add") && !attributeValue.isDefined();
            }

            protected boolean rejectAttribute(PathAddress address, String attributeName, ModelNode attributeValue, TransformationContext context) {
                return !attributeValue.isDefined();
            }
        };
    }
}

