/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common;

import java.util.List;
import java.util.Objects;
import java.util.concurrent.ScheduledExecutorService;
import org.apache.sshd.agent.SshAgentFactory;
import org.apache.sshd.common.AttributeRepository;
import org.apache.sshd.common.AttributeStore;
import org.apache.sshd.common.Factory;
import org.apache.sshd.common.ServiceFactory;
import org.apache.sshd.common.channel.ChannelFactory;
import org.apache.sshd.common.channel.ChannelListenerManager;
import org.apache.sshd.common.channel.RequestHandler;
import org.apache.sshd.common.channel.throttle.ChannelStreamWriterResolverManager;
import org.apache.sshd.common.file.FileSystemFactory;
import org.apache.sshd.common.forward.ForwarderFactory;
import org.apache.sshd.common.forward.PortForwardingEventListenerManager;
import org.apache.sshd.common.io.IoServiceEventListenerManager;
import org.apache.sshd.common.io.IoServiceFactory;
import org.apache.sshd.common.kex.KexFactoryManager;
import org.apache.sshd.common.random.Random;
import org.apache.sshd.common.session.ConnectionService;
import org.apache.sshd.common.session.ReservedSessionMessagesManager;
import org.apache.sshd.common.session.SessionDisconnectHandlerManager;
import org.apache.sshd.common.session.SessionHeartbeatController;
import org.apache.sshd.common.session.SessionListenerManager;
import org.apache.sshd.common.session.UnknownChannelReferenceHandlerManager;
import org.apache.sshd.server.forward.AgentForwardingFilter;
import org.apache.sshd.server.forward.ForwardingFilter;
import org.apache.sshd.server.forward.TcpForwardingFilter;
import org.apache.sshd.server.forward.X11ForwardingFilter;

public interface FactoryManager
extends KexFactoryManager,
SessionListenerManager,
ReservedSessionMessagesManager,
SessionDisconnectHandlerManager,
ChannelListenerManager,
ChannelStreamWriterResolverManager,
UnknownChannelReferenceHandlerManager,
PortForwardingEventListenerManager,
IoServiceEventListenerManager,
AttributeStore,
SessionHeartbeatController {
    public static final String DEFAULT_VERSION = "SSHD-UNKNOWN";

    public String getVersion();

    public IoServiceFactory getIoServiceFactory();

    public Factory<Random> getRandomFactory();

    public List<ChannelFactory> getChannelFactories();

    public SshAgentFactory getAgentFactory();

    public ScheduledExecutorService getScheduledExecutorService();

    public ForwardingFilter getForwardingFilter();

    default public TcpForwardingFilter getTcpForwardingFilter() {
        return this.getForwardingFilter();
    }

    default public AgentForwardingFilter getAgentForwardingFilter() {
        return this.getForwardingFilter();
    }

    default public X11ForwardingFilter getX11ForwardingFilter() {
        return this.getForwardingFilter();
    }

    public ForwarderFactory getForwarderFactory();

    public FileSystemFactory getFileSystemFactory();

    public List<ServiceFactory> getServiceFactories();

    public List<RequestHandler<ConnectionService>> getGlobalRequestHandlers();

    default public <T> T resolveAttribute(AttributeRepository.AttributeKey<T> key) {
        return FactoryManager.resolveAttribute(this, key);
    }

    public static <T> T resolveAttribute(FactoryManager manager, AttributeRepository.AttributeKey<T> key) {
        Objects.requireNonNull(key, "No key");
        return (T)(manager == null ? null : manager.getAttribute(key));
    }
}

