/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.plugins.providers;

import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import javax.annotation.Priority;
import javax.ws.rs.Consumes;
import javax.ws.rs.Encoded;
import javax.ws.rs.Produces;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Form;
import javax.ws.rs.core.MediaType;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.Provider;
import org.jboss.resteasy.plugins.providers.FormUrlEncodedProvider;
import org.jboss.resteasy.resteasy_jaxrs.i18n.LogMessages;
import org.jboss.resteasy.spi.HttpRequest;
import org.jboss.resteasy.util.FindAnnotation;

@Priority(value=2000)
@Provider
@Produces(value={"application/x-www-form-urlencoded"})
@Consumes(value={"application/x-www-form-urlencoded"})
public class JaxrsServerFormUrlEncodedProvider
implements MessageBodyReader<Form> {
    protected boolean useContainerParams;
    @Context
    HttpRequest request;

    public JaxrsServerFormUrlEncodedProvider(boolean useContainerParams) {
        this.useContainerParams = useContainerParams;
    }

    public boolean isReadable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return this.useContainerParams && Form.class.isAssignableFrom(type);
    }

    public Form readFrom(Class<Form> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, String> httpHeaders, InputStream entityStream) throws IOException, WebApplicationException {
        LogMessages.LOGGER.debugf("Provider : %s,  Method : readFrom", this.getClass().getName());
        MultivaluedMap<String, String> map = null;
        if (this.useContainerParams) {
            boolean encoded;
            boolean bl = encoded = FindAnnotation.findAnnotation(annotations, Encoded.class) != null;
            map = encoded ? this.request.getFormParameters() : this.request.getDecodedFormParameters();
        } else {
            map = new FormUrlEncodedProvider().readFrom(null, null, annotations, mediaType, httpHeaders, entityStream);
        }
        return new Form(map);
    }
}

