/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.service;

import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;
import org.jboss.as.server.deployment.reflect.ClassReflectionIndex;
import org.jboss.as.service.logging.SarLogger;

final class ReflectionUtils {
    private static final Class<?>[] NO_ARGS = new Class[0];

    private ReflectionUtils() {
    }

    static Method getGetter(Class<?> clazz, String propertyName) {
        String getterName = "get" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        String iserName = "is" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        try {
            return clazz.getMethod(getterName, NO_ARGS);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return clazz.getMethod(iserName, NO_ARGS);
            }
            catch (NoSuchMethodException e) {
                String className = clazz.getName();
                throw SarLogger.ROOT_LOGGER.propertyMethodNotFound("Get", propertyName, className);
            }
        }
    }

    static Method getSetter(List<ClassReflectionIndex> classHierarchy, String propertyName) {
        String setterName = "set" + Character.toUpperCase(propertyName.charAt(0)) + propertyName.substring(1);
        for (ClassReflectionIndex classIndex : classHierarchy) {
            for (Method method : classIndex.getMethods()) {
                if (!setterName.equals(method.getName()) || method.getParameterTypes().length != 1) continue;
                return method;
            }
        }
        String className = classHierarchy.get(0).getIndexedClass().getName();
        throw SarLogger.ROOT_LOGGER.propertyMethodNotFound("Set", propertyName, className);
    }

    public static Method getMethod(Class<?> clazz, String methodName, Class<?>[] argumentList) {
        try {
            return clazz.getMethod(methodName, argumentList);
        }
        catch (NoSuchMethodException e) {
            throw SarLogger.ROOT_LOGGER.methodNotFound(methodName, ReflectionUtils.parameterList(argumentList), clazz.getName());
        }
    }

    static Method getNoArgMethod(List<ClassReflectionIndex> classHierarchy, String methodName) {
        for (ClassReflectionIndex classIndex : classHierarchy) {
            Collection methods = classIndex.getMethods(methodName, (Class[])NO_ARGS);
            if (methods.size() != 1) continue;
            return (Method)methods.iterator().next();
        }
        return null;
    }

    static Object newInstance(Constructor<?> constructor, Object[] args) {
        try {
            return constructor.newInstance(args);
        }
        catch (Exception e) {
            throw SarLogger.ROOT_LOGGER.classNotInstantiated(e);
        }
    }

    static Class<?> getClass(String className, ClassLoader classLoader) {
        try {
            return Class.forName(className, false, classLoader);
        }
        catch (ClassNotFoundException e) {
            throw SarLogger.ROOT_LOGGER.classNotFound(e);
        }
    }

    private static String parameterList(Class<?>[] parameterTypes) {
        StringBuilder result = new StringBuilder();
        if (parameterTypes != null && parameterTypes.length > 0) {
            result.append(parameterTypes[0]);
            for (int i = 1; i < parameterTypes.length; ++i) {
                result.append(", ").append(parameterTypes[i]);
            }
        }
        return result.toString();
    }
}

