/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.undertow;

import io.undertow.attribute.ExchangeAttribute;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HttpHandler;
import io.undertow.server.handlers.accesslog.AccessLogHandler;
import io.undertow.server.handlers.accesslog.AccessLogReceiver;
import io.undertow.server.handlers.accesslog.DefaultAccessLogReceiver;
import io.undertow.server.handlers.accesslog.ExtendedAccessLogParser;
import io.undertow.server.handlers.accesslog.JBossLoggingAccessLogReceiver;
import io.undertow.server.handlers.accesslog.LogFileHeaderGenerator;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.jboss.as.controller.services.path.PathManager;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.wildfly.extension.undertow.Host;
import org.wildfly.extension.undertow.logging.UndertowLogger;
import org.xnio.IoUtils;
import org.xnio.XnioWorker;

final class AccessLogService
implements Service<AccessLogService> {
    private final Consumer<AccessLogService> serviceConsumer;
    private final Supplier<Host> host;
    private final Supplier<XnioWorker> worker;
    private final Supplier<PathManager> pathManager;
    private final String pattern;
    private final String path;
    private final String pathRelativeTo;
    private final String filePrefix;
    private final String fileSuffix;
    private final boolean rotate;
    private final boolean useServerLog;
    private final boolean extended;
    private final Predicate predicate;
    private volatile AccessLogReceiver logReceiver;
    private PathManager.Callback.Handle callbackHandle;
    private Path directory;
    private ExchangeAttribute extendedPattern;

    AccessLogService(Consumer<AccessLogService> serviceConsumer, Supplier<Host> host, Supplier<XnioWorker> worker, Supplier<PathManager> pathManager, String pattern, boolean extended, Predicate predicate) {
        this(serviceConsumer, host, worker, pathManager, pattern, null, null, null, null, false, extended, predicate);
    }

    AccessLogService(Consumer<AccessLogService> serviceConsumer, Supplier<Host> host, Supplier<XnioWorker> worker, Supplier<PathManager> pathManager, String pattern, String path, String pathRelativeTo, String filePrefix, String fileSuffix, boolean rotate, boolean extended, Predicate predicate) {
        this.serviceConsumer = serviceConsumer;
        this.host = host;
        this.worker = worker;
        this.pathManager = pathManager;
        this.pattern = pattern;
        this.path = path;
        this.pathRelativeTo = pathRelativeTo;
        this.filePrefix = filePrefix;
        this.fileSuffix = fileSuffix;
        this.rotate = rotate;
        this.extended = extended;
        this.useServerLog = false;
        this.predicate = predicate == null ? Predicates.truePredicate() : predicate;
    }

    public void start(StartContext context) throws StartException {
        if (this.useServerLog) {
            this.logReceiver = new JBossLoggingAccessLogReceiver();
        } else {
            if (this.pathRelativeTo != null) {
                this.callbackHandle = this.pathManager.get().registerCallback(this.pathRelativeTo, PathManager.ReloadServerCallback.create(), new PathManager.Event[]{PathManager.Event.UPDATED, PathManager.Event.REMOVED});
            }
            this.directory = Paths.get(this.pathManager.get().resolveRelativePathEntry(this.path, this.pathRelativeTo), new String[0]);
            if (!Files.exists(this.directory, new LinkOption[0])) {
                try {
                    Files.createDirectories(this.directory, new FileAttribute[0]);
                }
                catch (IOException e) {
                    throw UndertowLogger.ROOT_LOGGER.couldNotCreateLogDirectory(this.directory, e);
                }
            }
            try {
                DefaultAccessLogReceiver.Builder builder = DefaultAccessLogReceiver.builder().setLogWriteExecutor((Executor)this.worker.get()).setOutputDirectory(this.directory).setLogBaseName(this.filePrefix).setLogNameSuffix(this.fileSuffix).setRotate(this.rotate);
                if (this.extended) {
                    builder.setLogFileHeaderGenerator((LogFileHeaderGenerator)new ExtendedAccessLogParser.ExtendedAccessLogHeaderGenerator(this.pattern));
                    this.extendedPattern = new ExtendedAccessLogParser(this.getClass().getClassLoader()).parse(this.pattern);
                } else {
                    this.extendedPattern = null;
                }
                this.logReceiver = builder.build();
            }
            catch (IllegalStateException e) {
                throw new StartException((Throwable)e);
            }
        }
        this.host.get().setAccessLogService(this);
        this.serviceConsumer.accept(this);
    }

    public void stop(StopContext context) {
        this.serviceConsumer.accept(null);
        this.host.get().setAccessLogService(null);
        if (this.callbackHandle != null) {
            this.callbackHandle.remove();
            this.callbackHandle = null;
        }
        if (this.logReceiver instanceof DefaultAccessLogReceiver) {
            IoUtils.safeClose((Closeable)((DefaultAccessLogReceiver)this.logReceiver));
        }
        this.logReceiver = null;
    }

    protected AccessLogHandler configureAccessLogHandler(HttpHandler handler) {
        if (this.extendedPattern != null) {
            return new AccessLogHandler(handler, this.logReceiver, this.pattern, this.extendedPattern, this.predicate);
        }
        return new AccessLogHandler(handler, this.logReceiver, this.pattern, this.getClass().getClassLoader(), this.predicate);
    }

    boolean isRotate() {
        return this.rotate;
    }

    String getPath() {
        return this.path;
    }

    public AccessLogService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }
}

