/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.ws.handler.Handler;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.jaxws.support.JaxWsEndpointImpl;
import org.jboss.ws.common.configuration.ConfigDelegateHandler;
import org.jboss.ws.common.deployment.ReferenceFactory;
import org.jboss.wsf.spi.deployment.InstanceProvider;
import org.jboss.wsf.spi.deployment.Reference;
import org.jboss.wsf.stack.cxf.i18n.Messages;

public final class CXFInstanceProvider
implements InstanceProvider {
    private final Object serviceBean;
    private final Endpoint cxfEndpoint;
    private final Map<String, Reference> cache = new HashMap<String, Reference>(8);

    public CXFInstanceProvider(Object serviceBean, Endpoint cxfEndpoint) {
        this.serviceBean = serviceBean;
        this.cxfEndpoint = cxfEndpoint;
    }

    public synchronized Reference getInstance(String className) {
        Reference instance = this.cache.get(className);
        if (instance == null) {
            List chain;
            if (className.equals(this.serviceBean.getClass().getName())) {
                instance = ReferenceFactory.newUninitializedReference((Object)this.serviceBean);
                this.cache.put(className, instance);
            }
            if (instance == null && (chain = ((JaxWsEndpointImpl)this.cxfEndpoint).getJaxwsBinding().getHandlerChain()) != null) {
                for (Handler handler : chain) {
                    if (handler instanceof ConfigDelegateHandler) {
                        handler = ((ConfigDelegateHandler)handler).getDelegate();
                    }
                    if (!className.equals(handler.getClass().getName())) continue;
                    instance = ReferenceFactory.newUninitializedReference((Object)handler);
                    this.cache.put(className, instance);
                }
            }
        }
        if (instance == null) {
            throw Messages.MESSAGES.cannotLoadClass(className);
        }
        return instance;
    }
}

