/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.webservices.dmr;

import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.web.host.CommonWebServer;
import org.jboss.as.webservices.config.ServerConfigFactoryImpl;
import org.jboss.as.webservices.config.ServerConfigImpl;
import org.jboss.as.webservices.dmr.Attributes;
import org.jboss.as.webservices.dmr.PackageUtils;
import org.jboss.as.webservices.dmr.WSDeploymentActivator;
import org.jboss.as.webservices.dmr.WSExtension;
import org.jboss.as.webservices.logging.WSLogger;
import org.jboss.as.webservices.service.ServerConfigService;
import org.jboss.as.webservices.service.XTSClientIntegrationService;
import org.jboss.as.webservices.util.ModuleClassLoaderProvider;
import org.jboss.dmr.ModelNode;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.wsf.spi.management.ServerConfig;

class WSSubsystemAdd
extends AbstractBoottimeAddStepHandler {
    static final WSSubsystemAdd INSTANCE = new WSSubsystemAdd();

    WSSubsystemAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        Attributes.STATISTICS_ENABLED.validateAndSet(operation, model);
        for (SimpleAttributeDefinition attr : Attributes.SUBSYSTEM_ATTRIBUTES) {
            attr.validateAndSet(operation, model);
        }
    }

    protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
        ServerConfigImpl serverConfig;
        WSLogger.ROOT_LOGGER.activatingWebservicesExtension();
        ModuleClassLoaderProvider.register();
        final boolean appclient = context.getProcessType() == ProcessType.APPLICATION_CLIENT;
        context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

            protected void execute(DeploymentProcessorTarget processorTarget) {
                WSDeploymentActivator.activate(processorTarget, appclient);
            }
        }, OperationContext.Stage.RUNTIME);
        ServiceTarget serviceTarget = context.getServiceTarget();
        boolean jmxAvailable = WSSubsystemAdd.isJMXSubsystemAvailable(context);
        if (appclient && model.hasDefined("wsdl-host")) {
            serverConfig = WSSubsystemAdd.createServerConfig(model, true, context);
            ServerConfigFactoryImpl.setConfig((ServerConfig)serverConfig);
            ServerConfigService.install(serviceTarget, serverConfig, WSSubsystemAdd.getServerConfigDependencies(context, appclient), jmxAvailable, false);
        }
        if (!appclient) {
            serverConfig = WSSubsystemAdd.createServerConfig(model, false, context);
            ServerConfigFactoryImpl.setConfig((ServerConfig)serverConfig);
            ServerConfigService.install(serviceTarget, serverConfig, WSSubsystemAdd.getServerConfigDependencies(context, appclient), jmxAvailable, true);
        }
        XTSClientIntegrationService.install(serviceTarget);
    }

    private static ServerConfigImpl createServerConfig(ModelNode configuration, boolean appclient, OperationContext context) throws OperationFailedException {
        ServerConfigImpl config = ServerConfigImpl.newInstance();
        try {
            ModelNode wsdlHost = Attributes.WSDL_HOST.resolveModelAttribute(context, configuration);
            config.setWebServiceHost(wsdlHost.isDefined() ? wsdlHost.asString() : null);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
        if (!appclient) {
            config.setModifySOAPAddress(Attributes.MODIFY_WSDL_ADDRESS.resolveModelAttribute(context, configuration).asBoolean());
            config.setStatisticsEnabled(Attributes.STATISTICS_ENABLED.resolveModelAttribute(context, configuration).asBoolean());
        }
        if (configuration.hasDefined("wsdl-port")) {
            config.setWebServicePort(Attributes.WSDL_PORT.resolveModelAttribute(context, configuration).asInt());
        }
        if (configuration.hasDefined("wsdl-secure-port")) {
            config.setWebServiceSecurePort(Attributes.WSDL_SECURE_PORT.resolveModelAttribute(context, configuration).asInt());
        }
        if (configuration.hasDefined("wsdl-uri-scheme")) {
            config.setWebServiceUriScheme(Attributes.WSDL_URI_SCHEME.resolveModelAttribute(context, configuration).asString());
        }
        if (configuration.hasDefined("wsdl-path-rewrite-rule")) {
            config.setWebServicePathRewriteRule(Attributes.WSDL_PATH_REWRITE_RULE.resolveModelAttribute(context, configuration).asString());
        }
        return config;
    }

    private static List<ServiceName> getServerConfigDependencies(OperationContext context, boolean appclient) {
        ArrayList<ServiceName> serviceNames = new ArrayList<ServiceName>();
        Resource subsystemResource = context.readResourceFromRoot(PathAddress.pathAddress((PathElement[])new PathElement[]{WSExtension.SUBSYSTEM_PATH}), false);
        WSSubsystemAdd.readConfigServiceNames(serviceNames, subsystemResource, "client-config");
        WSSubsystemAdd.readConfigServiceNames(serviceNames, subsystemResource, "endpoint-config");
        if (!appclient) {
            serviceNames.add(CommonWebServer.SERVICE_NAME);
        }
        return serviceNames;
    }

    private static void readConfigServiceNames(List<ServiceName> serviceNames, Resource subsystemResource, String configType) {
        for (String name : subsystemResource.getChildrenNames(configType)) {
            ServiceName configServiceName = "client-config".equals(configType) ? PackageUtils.getClientConfigServiceName(name) : PackageUtils.getEndpointConfigServiceName(name);
            serviceNames.add(configServiceName);
        }
    }

    private static boolean isJMXSubsystemAvailable(OperationContext context) {
        Resource root = context.readResourceFromRoot(PathAddress.pathAddress((PathAddress)PathAddress.EMPTY_ADDRESS, (PathElement[])new PathElement[0]), false);
        return root.hasChild(PathElement.pathElement((String)"subsystem", (String)"jmx"));
    }
}

