/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.clustering.infinispan.subsystem;

import java.util.EnumSet;
import java.util.function.UnaryOperator;
import org.infinispan.configuration.cache.StorageType;
import org.infinispan.eviction.EvictionType;
import org.jboss.as.clustering.controller.AttributeTranslation;
import org.jboss.as.clustering.controller.AttributeValueTranslator;
import org.jboss.as.clustering.controller.ManagementResourceRegistration;
import org.jboss.as.clustering.controller.ResourceDescriptor;
import org.jboss.as.clustering.controller.SimpleAliasEntry;
import org.jboss.as.clustering.controller.transform.SimpleAttributeConverter;
import org.jboss.as.clustering.controller.validation.EnumValidator;
import org.jboss.as.clustering.infinispan.subsystem.InfinispanModel;
import org.jboss.as.clustering.infinispan.subsystem.MemoryResourceDefinition;
import org.jboss.as.clustering.infinispan.subsystem.MemorySizeUnit;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.ModelVersion;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.operations.validation.ParameterValidator;
import org.jboss.as.controller.registry.AliasEntry;
import org.jboss.as.controller.registry.AttributeAccess;
import org.jboss.as.controller.transform.TransformationContext;
import org.jboss.as.controller.transform.description.AttributeConverter;
import org.jboss.as.controller.transform.description.AttributeTransformationDescriptionBuilder;
import org.jboss.as.controller.transform.description.RejectAttributeChecker;
import org.jboss.as.controller.transform.description.ResourceTransformationDescriptionBuilder;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;

public class OffHeapMemoryResourceDefinition
extends MemoryResourceDefinition {
    static final PathElement PATH = OffHeapMemoryResourceDefinition.pathElement("off-heap");
    static final PathElement BINARY_PATH = OffHeapMemoryResourceDefinition.pathElement("binary");

    static void buildTransformation(ModelVersion version, ResourceTransformationDescriptionBuilder parent) {
        if (InfinispanModel.VERSION_6_0_0.requiresTransformation(version)) {
            parent.rejectChildResource(PATH);
        } else {
            ResourceTransformationDescriptionBuilder builder = parent.addChildResource(PATH);
            for (MemorySizeUnit unit : EnumSet.complementOf(EnumSet.of(MemorySizeUnit.ENTRIES, MemorySizeUnit.BYTES))) {
                builder.getAttributeBuilder().addRejectCheck((RejectAttributeChecker)new RejectAttributeChecker.SimpleRejectAttributeChecker(new ModelNode(unit.name())), new String[]{Attribute.SIZE_UNIT.getName()});
            }
            SimpleAttributeConverter.Converter sizeUnitConverter = new SimpleAttributeConverter.Converter(){

                public void convert(PathAddress address, String name, ModelNode value, ModelNode model, TransformationContext context) {
                    if (value.isDefined()) {
                        MemorySizeUnit unit = MemorySizeUnit.valueOf(value.asString());
                        if (unit == MemorySizeUnit.ENTRIES) {
                            value.clear();
                        } else {
                            value.set(EvictionType.MEMORY.name());
                        }
                    }
                }
            };
            ((AttributeTransformationDescriptionBuilder)((AttributeTransformationDescriptionBuilder)builder.getAttributeBuilder().setValueConverter((AttributeConverter)new SimpleAttributeConverter(sizeUnitConverter), new String[]{Attribute.SIZE_UNIT.getName()})).addRename(Attribute.SIZE_UNIT.getName(), DeprecatedAttribute.EVICTION_TYPE.getName())).end();
        }
    }

    OffHeapMemoryResourceDefinition() {
        super(StorageType.OFF_HEAP, PATH, new ResourceDescriptorConfigurator(), Attribute.SIZE_UNIT);
    }

    @Override
    public ManagementResourceRegistration register(ManagementResourceRegistration parent) {
        ManagementResourceRegistration registration = super.register(parent);
        parent.registerAlias(BINARY_PATH, (AliasEntry)new SimpleAliasEntry((org.jboss.as.controller.registry.ManagementResourceRegistration)registration));
        return registration;
    }

    static class ResourceDescriptorConfigurator
    implements UnaryOperator<ResourceDescriptor> {
        ResourceDescriptorConfigurator() {
        }

        @Override
        public ResourceDescriptor apply(ResourceDescriptor descriptor) {
            return descriptor.addAttributes(Attribute.class).addAttributeTranslation((org.jboss.as.clustering.controller.Attribute)DeprecatedAttribute.EVICTION_TYPE, (AttributeTranslation)EvictionTypeTranslator.INSTANCE).addIgnoredAttributes(EnumSet.complementOf(EnumSet.of(DeprecatedAttribute.EVICTION_TYPE)));
        }
    }

    static enum EvictionTypeTranslator implements AttributeTranslation
    {
        INSTANCE;

        private final AttributeValueTranslator readTranslator = new AttributeValueTranslator(){

            public ModelNode translate(OperationContext context, ModelNode value) throws OperationFailedException {
                if (!value.isDefined()) {
                    return value;
                }
                MemorySizeUnit unit = MemorySizeUnit.valueOf(Attribute.SIZE_UNIT.getDefinition().resolveValue(context, value).asString());
                return new ModelNode((unit == MemorySizeUnit.ENTRIES ? EvictionType.COUNT : EvictionType.MEMORY).name());
            }
        };
        private final AttributeValueTranslator writeTranslator = new AttributeValueTranslator(){

            public ModelNode translate(OperationContext context, ModelNode value) throws OperationFailedException {
                if (!value.isDefined()) {
                    return value;
                }
                EvictionType type = EvictionType.valueOf((String)DeprecatedAttribute.EVICTION_TYPE.getDefinition().resolveValue(context, value).asString());
                return new ModelNode((type == EvictionType.COUNT ? MemorySizeUnit.ENTRIES : MemorySizeUnit.BYTES).name());
            }
        };

        public AttributeValueTranslator getReadTranslator() {
            return this.readTranslator;
        }

        public AttributeValueTranslator getWriteTranslator() {
            return this.writeTranslator;
        }

        public org.jboss.as.clustering.controller.Attribute getTargetAttribute() {
            return Attribute.SIZE_UNIT;
        }
    }

    @Deprecated
    static enum DeprecatedAttribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        CAPACITY("capacity", ModelType.INT, new ModelNode(0x100000), InfinispanModel.VERSION_12_0_0),
        EVICTION_TYPE("eviction-type", ModelType.STRING, new ModelNode(EvictionType.COUNT.name()), InfinispanModel.VERSION_13_0_0){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)new EnumValidator(EvictionType.class));
            }
        };

        private final AttributeDefinition definition;

        private DeprecatedAttribute(String name, ModelType type, ModelNode defaultValue, InfinispanModel deprecation) {
            this.definition = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder(name, type).setAllowExpression(true)).setRequired(false)).setDefaultValue(defaultValue)).setDeprecated(deprecation.getVersion())).setFlags(new AttributeAccess.Flag[]{AttributeAccess.Flag.RESTART_NONE})).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }

        @Override
        public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
            return builder;
        }
    }

    static enum Attribute implements org.jboss.as.clustering.controller.Attribute,
    UnaryOperator<SimpleAttributeDefinitionBuilder>
    {
        SIZE_UNIT(MemoryResourceDefinition.SharedAttribute.SIZE_UNIT){

            @Override
            public SimpleAttributeDefinitionBuilder apply(SimpleAttributeDefinitionBuilder builder) {
                return (SimpleAttributeDefinitionBuilder)builder.setValidator((ParameterValidator)new EnumValidator(MemorySizeUnit.class));
            }
        };

        private final AttributeDefinition definition;

        private Attribute(org.jboss.as.clustering.controller.Attribute basis) {
            this.definition = ((SimpleAttributeDefinitionBuilder)this.apply(new SimpleAttributeDefinitionBuilder((SimpleAttributeDefinition)basis.getDefinition()))).build();
        }

        public AttributeDefinition getDefinition() {
            return this.definition;
        }
    }
}

