/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.jca.core.workmanager;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import java.security.PrivilegedAction;

class SecurityActions {
    private SecurityActions() {
    }

    static ClassLoader getClassLoader(final Class<?> c) {
        if (System.getSecurityManager() == null) {
            return c.getClassLoader();
        }
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return c.getClassLoader();
            }
        });
    }

    static ClassLoader getThreadContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    static void setThreadContextClassLoader(final ClassLoader cl) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                Thread.currentThread().setContextClassLoader(cl);
                return null;
            }
        });
    }

    static Class<?>[] getDeclaredClasses(final Class<?> c) {
        if (System.getSecurityManager() == null) {
            return c.getDeclaredClasses();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Class<?>[]>(){

            @Override
            public Class<?>[] run() {
                return c.getDeclaredClasses();
            }
        });
    }

    static Field[] getDeclaredFields(final Class<?> c) {
        if (System.getSecurityManager() == null) {
            return c.getDeclaredFields();
        }
        return AccessController.doPrivileged(new PrivilegedAction<Field[]>(){

            @Override
            public Field[] run() {
                return c.getDeclaredFields();
            }
        });
    }

    static Field getDeclaredField(final Class<?> c, final String name) throws NoSuchFieldException {
        if (System.getSecurityManager() == null) {
            return c.getDeclaredField(name);
        }
        Field result = AccessController.doPrivileged(new PrivilegedAction<Field>(){

            @Override
            public Field run() {
                try {
                    return c.getDeclaredField(name);
                }
                catch (NoSuchFieldException e) {
                    return null;
                }
            }
        });
        if (result != null) {
            return result;
        }
        throw new NoSuchFieldException();
    }

    static void setAccessible(final AccessibleObject ao) {
        if (System.getSecurityManager() == null) {
            ao.setAccessible(true);
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                ao.setAccessible(true);
                return null;
            }
        });
    }

    static Method getMethod(final Class<?> c, final String name, final Class<?> ... params) throws NoSuchMethodException {
        if (System.getSecurityManager() == null) {
            return c.getMethod(name, params);
        }
        Method result = AccessController.doPrivileged(new PrivilegedAction<Method>(){

            @Override
            public Method run() {
                try {
                    return c.getMethod(name, params);
                }
                catch (NoSuchMethodException e) {
                    return null;
                }
            }
        });
        if (result != null) {
            return result;
        }
        throw new NoSuchMethodException();
    }
}

