/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.sts.token.validator.jwt;

import java.security.Principal;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import javax.security.auth.Subject;
import org.apache.cxf.common.security.SimpleGroup;
import org.apache.cxf.rs.security.jose.jwt.JwtToken;
import org.apache.cxf.sts.token.validator.DefaultSubjectRoleParser;
import org.apache.cxf.sts.token.validator.jwt.JWTRoleParser;

public class DefaultJWTRoleParser
extends DefaultSubjectRoleParser
implements JWTRoleParser {
    private boolean useJaasSubject = true;
    private String roleClaim;

    @Override
    public Set<Principal> parseRolesFromToken(Principal principal, Subject subject, JwtToken token) {
        if (subject != null && this.useJaasSubject) {
            return super.parseRolesFromSubject(principal, subject);
        }
        Set<Principal> roles = null;
        if (this.roleClaim != null && token != null && token.getClaims().containsProperty(this.roleClaim)) {
            roles = new HashSet<Principal>();
            String role = token.getClaims().getStringProperty(this.roleClaim).trim();
            for (String r : role.split(",")) {
                roles.add((Principal)new SimpleGroup(r));
            }
        } else {
            roles = Collections.emptySet();
        }
        return roles;
    }

    public boolean isUseJaasSubject() {
        return this.useJaasSubject;
    }

    public void setUseJaasSubject(boolean useJaasSubject) {
        this.useJaasSubject = useJaasSubject;
    }

    public String getRoleClaim() {
        return this.roleClaim;
    }

    public void setRoleClaim(String roleClaim) {
        this.roleClaim = roleClaim;
    }
}

