/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.client.auth.pubkey;

import java.security.Key;
import java.security.KeyPair;
import java.security.PublicKey;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.sshd.client.auth.pubkey.PublicKeyIdentity;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.NamedResource;
import org.apache.sshd.common.config.keys.KeyUtils;
import org.apache.sshd.common.session.SessionContext;
import org.apache.sshd.common.signature.Signature;
import org.apache.sshd.common.signature.SignatureFactoriesHolder;
import org.apache.sshd.common.signature.SignatureFactoriesManager;
import org.apache.sshd.common.signature.SignatureFactory;
import org.apache.sshd.common.util.GenericUtils;
import org.apache.sshd.common.util.ValidateUtils;

public class KeyPairIdentity
implements PublicKeyIdentity,
SignatureFactoriesHolder {
    protected final KeyPair pair;
    private final List<NamedFactory<Signature>> signatureFactories;

    public KeyPairIdentity(SignatureFactoriesManager primary, SignatureFactoriesManager secondary, KeyPair pair) {
        this.signatureFactories = Collections.unmodifiableList((List)ValidateUtils.checkNotNullAndNotEmpty((Collection)SignatureFactoriesManager.resolveSignatureFactories((SignatureFactoriesManager)primary, (SignatureFactoriesManager)secondary), (String)"No available signature factories", (Object[])new Object[0]));
        this.pair = Objects.requireNonNull(pair, "No key pair");
    }

    public PublicKey getPublicKey() {
        return this.pair.getPublic();
    }

    public List<NamedFactory<Signature>> getSignatureFactories() {
        return this.signatureFactories;
    }

    public Map.Entry<String, byte[]> sign(SessionContext session, String algo, byte[] data) throws Exception {
        NamedFactory factory;
        if (GenericUtils.isEmpty((CharSequence)algo)) {
            algo = KeyUtils.getKeyType((Key)this.getPublicKey());
            factory = SignatureFactory.resolveSignatureFactory((String)algo, this.getSignatureFactories());
        } else {
            factory = (NamedFactory)NamedResource.findByName((String)algo, (Comparator)String.CASE_INSENSITIVE_ORDER, this.getSignatureFactories());
        }
        Signature verifier = factory == null ? null : (Signature)factory.create();
        ValidateUtils.checkNotNull((Object)verifier, (String)"No signer could be located for key type=%s", (Object)algo);
        verifier.initSigner(session, this.pair.getPrivate());
        verifier.update(session, data);
        byte[] signature = verifier.sign(session);
        return new AbstractMap.SimpleImmutableEntry<String, byte[]>(factory.getName(), signature);
    }

    public String toString() {
        PublicKey pubKey = this.getPublicKey();
        return this.getClass().getSimpleName() + " type=" + KeyUtils.getKeyType((Key)pubKey) + ", factories=" + this.getSignatureFactoriesNameList() + ", fingerprint=" + KeyUtils.getFingerPrint((PublicKey)pubKey);
    }
}

