/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.protocols.ssl;

import io.undertow.connector.ByteBufferPool;
import io.undertow.protocols.ssl.SslConduit;
import java.io.IOException;
import java.net.SocketAddress;
import java.nio.channels.Channel;
import java.util.Set;
import java.util.concurrent.Executor;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLSession;
import org.xnio.ChannelListener;
import org.xnio.ChannelListeners;
import org.xnio.Option;
import org.xnio.Options;
import org.xnio.SslClientAuthMode;
import org.xnio.StreamConnection;
import org.xnio.ssl.SslConnection;

class UndertowSslConnection
extends SslConnection {
    private static final Set<Option<?>> SUPPORTED_OPTIONS = Option.setBuilder().add(Options.SECURE, Options.SSL_CLIENT_AUTH_MODE).create();
    private final StreamConnection delegate;
    private final SslConduit sslConduit;
    private final ChannelListener.SimpleSetter<SslConnection> handshakeSetter = new ChannelListener.SimpleSetter();
    private final SSLEngine engine;

    UndertowSslConnection(StreamConnection delegate, SSLEngine engine, ByteBufferPool bufferPool, Executor delegatedTaskExecutor) {
        super(delegate.getIoThread());
        this.delegate = delegate;
        this.engine = engine;
        this.sslConduit = new SslConduit(this, delegate, engine, delegatedTaskExecutor, bufferPool, new HandshakeCallback());
        this.setSourceConduit(this.sslConduit);
        this.setSinkConduit(this.sslConduit);
    }

    public void startHandshake() throws IOException {
        this.sslConduit.startHandshake();
    }

    public SSLSession getSslSession() {
        return this.sslConduit.getSslSession();
    }

    public ChannelListener.Setter<? extends SslConnection> getHandshakeSetter() {
        return this.handshakeSetter;
    }

    protected void notifyWriteClosed() {
        this.sslConduit.notifyWriteClosed();
    }

    protected void notifyReadClosed() {
        this.sslConduit.notifyReadClosed();
    }

    public SocketAddress getPeerAddress() {
        return this.delegate.getPeerAddress();
    }

    public SocketAddress getLocalAddress() {
        return this.delegate.getLocalAddress();
    }

    public SSLEngine getSSLEngine() {
        return this.sslConduit.getSSLEngine();
    }

    SslConduit getSslConduit() {
        return this.sslConduit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T setOption(Option<T> option, T value) throws IllegalArgumentException, IOException {
        if (option == Options.SSL_CLIENT_AUTH_MODE) {
            try {
                Object object = option.cast((Object)(this.engine.getNeedClientAuth() ? SslClientAuthMode.REQUIRED : (this.engine.getWantClientAuth() ? SslClientAuthMode.REQUESTED : SslClientAuthMode.NOT_REQUESTED)));
                return (T)object;
            }
            finally {
                this.engine.setWantClientAuth(false);
                this.engine.setNeedClientAuth(false);
                if (value == SslClientAuthMode.REQUESTED) {
                    this.engine.setWantClientAuth(true);
                } else if (value == SslClientAuthMode.REQUIRED) {
                    this.engine.setNeedClientAuth(true);
                }
            }
        }
        if (option == Options.SECURE) {
            throw new IllegalArgumentException();
        }
        return (T)this.delegate.setOption(option, value);
    }

    public <T> T getOption(Option<T> option) throws IOException {
        if (option == Options.SSL_CLIENT_AUTH_MODE) {
            return (T)option.cast((Object)(this.engine.getNeedClientAuth() ? SslClientAuthMode.REQUIRED : (this.engine.getWantClientAuth() ? SslClientAuthMode.REQUESTED : SslClientAuthMode.NOT_REQUESTED)));
        }
        return (T)(option == Options.SECURE ? Boolean.TRUE : this.delegate.getOption(option));
    }

    public boolean supportsOption(Option<?> option) {
        return SUPPORTED_OPTIONS.contains(option) || this.delegate.supportsOption(option);
    }

    protected boolean readClosed() {
        return super.readClosed();
    }

    protected boolean writeClosed() {
        return super.writeClosed();
    }

    protected void closeAction() {
        this.sslConduit.close();
    }

    private final class HandshakeCallback
    implements Runnable {
        private HandshakeCallback() {
        }

        @Override
        public void run() {
            ChannelListener listener = UndertowSslConnection.this.handshakeSetter.get();
            if (listener == null) {
                return;
            }
            ChannelListeners.invokeChannelListener((Channel)((Object)UndertowSslConnection.this), (ChannelListener)listener);
        }
    }
}

