/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.security;

import java.security.Policy;
import javax.security.auth.login.Configuration;
import javax.transaction.TransactionManager;
import org.jboss.as.controller.AbstractBoottimeAddStepHandler;
import org.jboss.as.controller.AbstractWriteAttributeHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.ProcessType;
import org.jboss.as.controller.ReloadRequiredRemoveStepHandler;
import org.jboss.as.controller.ReloadRequiredWriteAttributeHandler;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleAttributeDefinitionBuilder;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.access.constraint.SensitivityClassification;
import org.jboss.as.controller.access.management.AccessConstraintDefinition;
import org.jboss.as.controller.access.management.SensitiveTargetAccessConstraintDefinition;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.controller.capability.RuntimeCapability;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.as.controller.registry.Resource;
import org.jboss.as.controller.registry.RuntimePackageDependency;
import org.jboss.as.core.security.ServerSecurityManager;
import org.jboss.as.naming.ServiceBasedNamingStore;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.as.naming.service.BinderService;
import org.jboss.as.security.ModuleName;
import org.jboss.as.security.SecurityExtension;
import org.jboss.as.security.TransactionManagerLocatorService;
import org.jboss.as.security.context.SecurityDomainJndiInjectable;
import org.jboss.as.security.deployment.SecurityDependencyProcessor;
import org.jboss.as.security.deployment.SecurityEnablementProcessor;
import org.jboss.as.security.logging.SecurityLogger;
import org.jboss.as.security.service.JaasConfigurationService;
import org.jboss.as.security.service.SecurityBootstrapService;
import org.jboss.as.security.service.SecurityManagementService;
import org.jboss.as.security.service.SimpleSecurityManagerService;
import org.jboss.as.security.service.SubjectFactoryService;
import org.jboss.as.server.AbstractDeploymentChainStep;
import org.jboss.as.server.DeploymentProcessorTarget;
import org.jboss.as.server.Services;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.Phase;
import org.jboss.as.server.moduleservice.ServiceModuleLoader;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.ModelType;
import org.jboss.msc.inject.Injector;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.security.ISecurityManagement;
import org.jboss.security.SubjectFactory;
import org.jboss.security.auth.callback.JBossCallbackHandler;
import org.jboss.security.auth.login.XMLLoginConfigImpl;
import org.jboss.security.authentication.JBossCachedAuthenticationManager;
import org.jboss.security.plugins.JBossAuthorizationManager;
import org.jboss.security.plugins.JBossSecuritySubjectFactory;
import org.jboss.security.plugins.audit.JBossAuditManager;
import org.jboss.security.plugins.identitytrust.JBossIdentityTrustManager;
import org.jboss.security.plugins.mapping.JBossMappingManager;
import org.wildfly.security.manager.WildFlySecurityManager;

public class SecuritySubsystemRootResourceDefinition
extends SimpleResourceDefinition {
    private static final RuntimeCapability<Void> SECURITY_SUBSYSTEM = RuntimeCapability.Builder.of((String)"org.wildfly.legacy-security").build();
    private static final RuntimeCapability<Void> SERVER_SECURITY_MANAGER = RuntimeCapability.Builder.of((String)"org.wildfly.legacy-security.server-security-manager").setServiceType(ServerSecurityManager.class).build();
    private static final RuntimeCapability<Void> SUBJECT_FACTORY_CAP = RuntimeCapability.Builder.of((String)"org.wildfly.legacy-security.subject-factory").setServiceType(SubjectFactory.class).build();
    private static final RuntimeCapability<Void> JACC_CAPABILITY = RuntimeCapability.Builder.of((String)"org.wildfly.legacy-security.jacc").setServiceType(Policy.class).build();
    private static final RuntimeCapability<Void> JACC_CAPABILITY_TOMBSTONE = RuntimeCapability.Builder.of((String)"org.wildfly.legacy-security.jacc.tombstone").setServiceType(Void.class).build();
    private static final SensitiveTargetAccessConstraintDefinition MISC_SECURITY_SENSITIVITY = new SensitiveTargetAccessConstraintDefinition(new SensitivityClassification("security", "misc-security", false, true, true));
    static final SecuritySubsystemRootResourceDefinition INSTANCE = new SecuritySubsystemRootResourceDefinition();
    static final SimpleAttributeDefinition DEEP_COPY_SUBJECT_MODE = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("deep-copy-subject-mode", ModelType.BOOLEAN, true).setAccessConstraints(new AccessConstraintDefinition[]{MISC_SECURITY_SENSITIVITY})).setDefaultValue(ModelNode.FALSE)).setAllowExpression(true)).build();
    static final SimpleAttributeDefinition INITIALIZE_JACC = ((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)((SimpleAttributeDefinitionBuilder)new SimpleAttributeDefinitionBuilder("initialize-jacc", ModelType.BOOLEAN, true).setDefaultValue(ModelNode.TRUE)).setRestartJVM()).setAllowExpression(true)).build();

    private SecuritySubsystemRootResourceDefinition() {
        super(new SimpleResourceDefinition.Parameters(SecurityExtension.PATH_SUBSYSTEM, (ResourceDescriptionResolver)SecurityExtension.getResourceDescriptionResolver("security")).setAddHandler(SecuritySubsystemAdd.INSTANCE).setRemoveHandler((OperationStepHandler)new ReloadRequiredRemoveStepHandler(){

            protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
                super.recordCapabilitiesAndRequirements(context, operation, resource);
                context.deregisterCapability(JACC_CAPABILITY.getName());
            }
        }).setCapabilities(new RuntimeCapability[]{SECURITY_SUBSYSTEM, SERVER_SECURITY_MANAGER, SUBJECT_FACTORY_CAP}));
        this.setDeprecated(SecurityExtension.DEPRECATED_SINCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)DEEP_COPY_SUBJECT_MODE, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{DEEP_COPY_SUBJECT_MODE}));
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)INITIALIZE_JACC, null, (OperationStepHandler)new ReloadRequiredWriteAttributeHandler(new AttributeDefinition[]{INITIALIZE_JACC}){

            protected boolean applyUpdateToRuntime(OperationContext context, ModelNode operation, String attributeName, ModelNode resolvedValue, ModelNode currentValue, AbstractWriteAttributeHandler.HandbackHolder<Void> voidHandback) throws OperationFailedException {
                CapabilityServiceSupport capabilitySupport = context.getCapabilityServiceSupport();
                boolean elytronJacc = capabilitySupport.hasCapability("org.wildfly.security.jacc-policy");
                if (resolvedValue.asBoolean() && elytronJacc) {
                    throw SecurityLogger.ROOT_LOGGER.unableToEnableJaccSupport();
                }
                return super.applyUpdateToRuntime(context, operation, attributeName, resolvedValue, currentValue, voidHandback);
            }

            protected void recordCapabilitiesAndRequirements(OperationContext context, AttributeDefinition attributeDefinition, ModelNode newValue, ModelNode oldValue) {
                super.recordCapabilitiesAndRequirements(context, attributeDefinition, newValue, oldValue);
                boolean shouldRegister = this.resolveValue(context, attributeDefinition, newValue);
                boolean registered = this.resolveValue(context, attributeDefinition, oldValue);
                if (!shouldRegister) {
                    context.deregisterCapability(JACC_CAPABILITY.getName());
                }
                if (!registered && shouldRegister) {
                    context.registerCapability(JACC_CAPABILITY);
                }
            }

            private boolean resolveValue(OperationContext context, AttributeDefinition attributeDefinition, ModelNode node) {
                try {
                    return attributeDefinition.resolveValue(context, node).asBoolean();
                }
                catch (OperationFailedException e) {
                    throw new IllegalStateException(e);
                }
            }
        });
    }

    public void registerAdditionalRuntimePackages(ManagementResourceRegistration resourceRegistration) {
        resourceRegistration.registerAdditionalRuntimePackages(new RuntimePackageDependency[]{RuntimePackageDependency.required((String)"javax.security.auth.message.api")});
    }

    private static class SecuritySubsystemAdd
    extends AbstractBoottimeAddStepHandler {
        private static final String AUTHENTICATION_MANAGER = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JBossCachedAuthenticationManager.class.getName();
        private static final String CALLBACK_HANDLER = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JBossCallbackHandler.class.getName();
        private static final String AUTHORIZATION_MANAGER = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JBossAuthorizationManager.class.getName();
        private static final String AUDIT_MANAGER = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JBossAuditManager.class.getName();
        private static final String IDENTITY_TRUST_MANAGER = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JBossIdentityTrustManager.class.getName();
        private static final String MAPPING_MANAGER = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JBossMappingManager.class.getName();
        private static final String SUBJECT_FACTORY = ModuleName.PICKETBOX.getName() + ":" + ModuleName.PICKETBOX.getSlot() + ":" + JBossSecuritySubjectFactory.class.getName();
        public static final OperationStepHandler INSTANCE = new SecuritySubsystemAdd();

        private SecuritySubsystemAdd() {
        }

        protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
            DEEP_COPY_SUBJECT_MODE.validateAndSet(operation, model);
            INITIALIZE_JACC.validateAndSet(operation, model);
        }

        protected void recordCapabilitiesAndRequirements(OperationContext context, ModelNode operation, Resource resource) throws OperationFailedException {
            super.recordCapabilitiesAndRequirements(context, operation, resource);
            if (INITIALIZE_JACC.resolveModelAttribute(context, resource.getModel()).asBoolean()) {
                context.registerCapability(JACC_CAPABILITY);
                if (context.isBooting()) {
                    context.registerCapability(JACC_CAPABILITY_TOMBSTONE);
                }
            }
        }

        protected void performBoottime(OperationContext context, ModelNode operation, ModelNode model) throws OperationFailedException {
            SecurityLogger.ROOT_LOGGER.activatingSecuritySubsystem();
            if (context.getProcessType() != ProcessType.APPLICATION_CLIENT) {
                WildFlySecurityManager.setPropertyPrivileged((String)"org.jboss.security.context.ThreadLocal", (String)"true");
            }
            ServiceTarget target = context.getServiceTarget();
            ModelNode initializeJaccNode = INITIALIZE_JACC.resolveModelAttribute(context, model);
            SecurityBootstrapService bootstrapService = new SecurityBootstrapService(initializeJaccNode.asBoolean());
            ServiceBuilder builder = target.addService(SecurityBootstrapService.SERVICE_NAME, (Service)bootstrapService).addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ServiceModuleLoader.class, bootstrapService.getServiceModuleLoaderInjectedValue()).setInitialMode(ServiceController.Mode.ACTIVE);
            if (initializeJaccNode.asBoolean()) {
                builder.addAliases(new ServiceName[]{context.getCapabilityServiceName(JACC_CAPABILITY.getName(), Policy.class)});
            }
            builder.install();
            SecurityDomainJndiInjectable securityDomainJndiInjectable = new SecurityDomainJndiInjectable();
            BinderService binderService = new BinderService("jaas");
            binderService.getManagedObjectInjector().inject((Object)securityDomainJndiInjectable);
            target.addService(ContextNames.JBOSS_CONTEXT_SERVICE_NAME.append(new String[]{"jaas"}), (Service)binderService).addDependency(ContextNames.JBOSS_CONTEXT_SERVICE_NAME, ServiceBasedNamingStore.class, (Injector)binderService.getNamingStoreInjector()).addDependency(SecurityManagementService.SERVICE_NAME, ISecurityManagement.class, securityDomainJndiInjectable.getSecurityManagementInjector()).install();
            ModelNode modelNode = DEEP_COPY_SUBJECT_MODE.resolveModelAttribute(context, model);
            SecurityManagementService securityManagementService = new SecurityManagementService(AUTHENTICATION_MANAGER, modelNode.isDefined() && modelNode.asBoolean(), CALLBACK_HANDLER, AUTHORIZATION_MANAGER, AUDIT_MANAGER, IDENTITY_TRUST_MANAGER, MAPPING_MANAGER);
            ServiceBuilder securityManagementServiceSB = target.addService(SecurityManagementService.SERVICE_NAME, (Service)securityManagementService);
            securityManagementServiceSB.addDependency(Services.JBOSS_SERVICE_MODULE_LOADER, ServiceModuleLoader.class, securityManagementService.getServiceModuleLoaderInjectedValue());
            securityManagementServiceSB.requires(JaasConfigurationService.SERVICE_NAME);
            securityManagementServiceSB.setInitialMode(ServiceController.Mode.ACTIVE).install();
            SubjectFactoryService subjectFactoryService = new SubjectFactoryService(SUBJECT_FACTORY);
            target.addService(SUBJECT_FACTORY_CAP.getCapabilityServiceName(), (Service)subjectFactoryService).addAliases(new ServiceName[]{SubjectFactoryService.SERVICE_NAME}).addDependency(SecurityManagementService.SERVICE_NAME, ISecurityManagement.class, subjectFactoryService.getSecurityManagementInjector()).setInitialMode(ServiceController.Mode.ACTIVE).install();
            XMLLoginConfigImpl loginConfig = XMLLoginConfigImpl.getInstance();
            JaasConfigurationService jaasConfigurationService = new JaasConfigurationService((Configuration)loginConfig);
            target.addService(JaasConfigurationService.SERVICE_NAME, (Service)jaasConfigurationService).setInitialMode(ServiceController.Mode.ACTIVE).install();
            if (context.hasOptionalCapability("org.wildfly.transactions", SECURITY_SUBSYSTEM.getName(), null)) {
                TransactionManagerLocatorService service = new TransactionManagerLocatorService();
                target.addService(TransactionManagerLocatorService.SERVICE_NAME, (Service)service).addDependency(ServiceName.JBOSS.append(new String[]{"txn", "TransactionManager"}), TransactionManager.class, service.getTransactionManagerInjectedValue()).install();
            } else {
                target.addService(TransactionManagerLocatorService.SERVICE_NAME, Service.NULL).install();
            }
            SimpleSecurityManagerService simpleSecurityManagerService = new SimpleSecurityManagerService();
            ServiceBuilder simpleSecurityManagerServiceSB = target.addService(SERVER_SECURITY_MANAGER.getCapabilityServiceName(), (Service)simpleSecurityManagerService);
            simpleSecurityManagerServiceSB.addAliases(new ServiceName[]{SimpleSecurityManagerService.SERVICE_NAME});
            simpleSecurityManagerServiceSB.requires(SecurityManagementService.SERVICE_NAME);
            simpleSecurityManagerServiceSB.install();
            context.addStep((OperationStepHandler)new AbstractDeploymentChainStep(){

                protected void execute(DeploymentProcessorTarget processorTarget) {
                    processorTarget.addDeploymentProcessor("security", Phase.DEPENDENCIES, 3152, (DeploymentUnitProcessor)new SecurityDependencyProcessor());
                    processorTarget.addDeploymentProcessor("security", Phase.PARSE, 128, (DeploymentUnitProcessor)new SecurityEnablementProcessor());
                }
            }, OperationContext.Stage.RUNTIME);
        }
    }
}

