/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedMap;
import java.util.function.Function;
import org.infinispan.protostream.descriptors.WireType;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;
import org.wildfly.clustering.marshalling.protostream.util.AbstractMapMarshaller;
import org.wildfly.clustering.marshalling.protostream.util.ComparatorMarshaller;

public class SortedMapMarshaller<T extends SortedMap<Object, Object>>
extends AbstractMapMarshaller<T> {
    private static final int COMPARATOR_INDEX = 3;
    private final Function<Comparator<? super Object>, T> factory;

    public SortedMapMarshaller(Function<Comparator<? super Object>, T> factory) {
        super(((SortedMap)factory.apply((Comparator<? super Object>)ComparatorMarshaller.INSTANCE.getBuilder())).getClass());
        this.factory = factory;
    }

    @Override
    public T readFrom(ProtoStreamReader reader) throws IOException {
        Comparator<?> comparator = ComparatorMarshaller.INSTANCE.getBuilder();
        SortedMap map = (SortedMap)this.factory.apply((Comparator<? super Object>)comparator);
        LinkedList<Object> keys = new LinkedList<Object>();
        LinkedList<Object> values = new LinkedList<Object>();
        while (!reader.isAtEnd()) {
            int tag = reader.readTag();
            int index = WireType.getTagFieldNumber((int)tag);
            if (index == 1) {
                keys.add(reader.readObject(Any.class).get());
                continue;
            }
            if (index == 2) {
                values.add(reader.readObject(Any.class).get());
                continue;
            }
            if (index >= 3 && index < 3 + ComparatorMarshaller.INSTANCE.getFields()) {
                comparator = ComparatorMarshaller.INSTANCE.readField(reader, index - 3, comparator);
                map = (SortedMap)this.factory.apply(comparator);
                continue;
            }
            reader.skipField(tag);
        }
        Iterator keyIterator = keys.iterator();
        Iterator valueIterator = values.iterator();
        while (keyIterator.hasNext() || valueIterator.hasNext()) {
            map.put(keyIterator.next(), valueIterator.next());
        }
        return (T)map;
    }

    @Override
    public void writeTo(ProtoStreamWriter writer, T map) throws IOException {
        super.writeTo(writer, map);
        Comparator comparator = map.comparator();
        if (comparator != ComparatorMarshaller.INSTANCE.getBuilder()) {
            ComparatorMarshaller.INSTANCE.writeFields(writer, 3, comparator);
        }
    }
}

