/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.protocol.amqp.proton;

import org.apache.activemq.artemis.core.persistence.impl.nullpm.NullStorageManager;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPLargeMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPMessage;
import org.apache.activemq.artemis.protocol.amqp.broker.AMQPSessionCallback;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPException;
import org.apache.activemq.artemis.protocol.amqp.exceptions.ActiveMQAMQPInternalErrorException;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPConnectionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.AMQPSessionContext;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonDeliveryHandler;
import org.apache.activemq.artemis.protocol.amqp.proton.ProtonInitializable;
import org.apache.qpid.proton.amqp.transaction.TransactionalState;
import org.apache.qpid.proton.amqp.transport.ErrorCondition;
import org.apache.qpid.proton.codec.ReadableBuffer;
import org.apache.qpid.proton.engine.Delivery;
import org.apache.qpid.proton.engine.Receiver;

public abstract class ProtonAbstractReceiver
extends ProtonInitializable
implements ProtonDeliveryHandler {
    protected final AMQPConnectionContext connection;
    protected final AMQPSessionContext protonSession;
    protected final Receiver receiver;
    protected final int amqpCredits;
    protected final int minCreditRefresh;
    protected final int minLargeMessageSize;
    final RoutingContext routingContext;
    protected final AMQPSessionCallback sessionSPI;
    protected volatile AMQPLargeMessage currentLargeMessage;
    protected final Runnable creditRunnable;
    protected final boolean useModified;
    protected int pendingSettles = 0;

    public static boolean isBellowThreshold(int credit, int pending, int threshold) {
        return credit <= threshold - pending;
    }

    public static int calculatedUpdateRefill(int refill, int credits, int pending) {
        return refill - credits - pending;
    }

    public ProtonAbstractReceiver(AMQPSessionCallback sessionSPI, AMQPConnectionContext connection, AMQPSessionContext protonSession, Receiver receiver) {
        this.sessionSPI = sessionSPI;
        this.connection = connection;
        this.protonSession = protonSession;
        this.receiver = receiver;
        this.amqpCredits = connection.getAmqpCredits();
        this.minCreditRefresh = connection.getAmqpLowCredits();
        this.minLargeMessageSize = connection.getProtocolManager().getAmqpMinLargeMessageSize();
        this.creditRunnable = ProtonAbstractReceiver.createCreditRunnable(this.amqpCredits, this.minCreditRefresh, receiver, connection, this);
        this.useModified = this.connection.getProtocolManager().isUseModifiedForTransientDeliveryErrors();
        this.routingContext = new RoutingContextImpl(null).setDuplicateDetection(connection.getProtocolManager().isAmqpDuplicateDetection());
        if (sessionSPI != null) {
            sessionSPI.addCloseable(failed -> this.clearLargeMessage());
        }
    }

    protected void clearLargeMessage() {
        this.connection.runNow(() -> {
            if (this.currentLargeMessage != null) {
                try {
                    this.currentLargeMessage.deleteFile();
                }
                catch (Throwable error) {
                    ActiveMQServerLogger.LOGGER.errorDeletingLargeMessageFile(error);
                }
                finally {
                    this.currentLargeMessage = null;
                }
            }
        });
    }

    public static Runnable createCreditRunnable(int refill, int threshold, Receiver receiver, AMQPConnectionContext connection, ProtonAbstractReceiver context) {
        return new FlowControlRunner(refill, threshold, receiver, connection, context);
    }

    public static Runnable createCreditRunnable(int refill, int threshold, Receiver receiver, AMQPConnectionContext connection) {
        return new FlowControlRunner(refill, threshold, receiver, connection, null);
    }

    public int incrementSettle() {
        assert (this.pendingSettles >= 0);
        this.connection.requireInHandler();
        return this.pendingSettles++;
    }

    public void settle(Delivery settlement) {
        this.connection.requireInHandler();
        --this.pendingSettles;
        assert (this.pendingSettles >= 0);
        settlement.settle();
        this.flow();
    }

    @Override
    public void onFlow(int credits, boolean drain) {
        this.flow();
    }

    @Override
    public void onMessage(Delivery delivery) throws ActiveMQAMQPException {
        this.connection.requireInHandler();
        Receiver receiver = (Receiver)delivery.getLink();
        if (receiver.current() != delivery) {
            return;
        }
        try {
            AMQPMessage message;
            if (delivery.isAborted()) {
                this.clearLargeMessage();
                receiver.advance();
                delivery.settle();
                if (!receiver.getDrain()) {
                    receiver.flow(1);
                }
                return;
            }
            if (delivery.isPartial()) {
                if (this.sessionSPI.getStorageManager() instanceof NullStorageManager) {
                    return;
                }
                if (this.currentLargeMessage == null) {
                    if (this.minLargeMessageSize > 0 && delivery.available() >= this.minLargeMessageSize) {
                        this.initializeCurrentLargeMessage(delivery, receiver);
                    }
                } else {
                    this.currentLargeMessage.addBytes(receiver.recv());
                }
                return;
            }
            if (!(this.sessionSPI.getStorageManager() instanceof NullStorageManager) && this.currentLargeMessage == null && this.minLargeMessageSize > 0 && delivery.available() >= this.minLargeMessageSize) {
                this.initializeCurrentLargeMessage(delivery, receiver);
            }
            if (this.currentLargeMessage != null) {
                this.currentLargeMessage.addBytes(receiver.recv());
                receiver.advance();
                this.currentLargeMessage.finishParse();
                message = this.currentLargeMessage;
                this.currentLargeMessage = null;
            } else {
                ReadableBuffer data = receiver.recv();
                receiver.advance();
                message = this.sessionSPI.createStandardMessage(delivery, data);
            }
            Transaction tx = null;
            if (delivery.getRemoteState() instanceof TransactionalState) {
                TransactionalState txState = (TransactionalState)delivery.getRemoteState();
                tx = this.sessionSPI.getTransaction(txState.getTxnId(), false);
            }
            this.actualDelivery(message, delivery, receiver, tx);
        }
        catch (Exception e) {
            throw new ActiveMQAMQPInternalErrorException(e.getMessage(), e);
        }
    }

    protected void initializeCurrentLargeMessage(Delivery delivery, Receiver receiver) throws Exception {
        long id = this.sessionSPI.getStorageManager().generateID();
        this.currentLargeMessage = new AMQPLargeMessage(id, delivery.getMessageFormat(), null, this.sessionSPI.getCoreMessageObjectPools(), this.sessionSPI.getStorageManager());
        ReadableBuffer dataBuffer = receiver.recv();
        this.currentLargeMessage.parseHeader(dataBuffer);
        this.sessionSPI.getStorageManager().largeMessageCreated(id, (LargeServerMessage)this.currentLargeMessage);
        this.currentLargeMessage.addBytes(dataBuffer);
    }

    @Override
    public void close(boolean remoteLinkClose) throws ActiveMQAMQPException {
        this.protonSession.removeReceiver(this.receiver);
    }

    @Override
    public void close(ErrorCondition condition) throws ActiveMQAMQPException {
        this.receiver.setCondition(condition);
        this.close(false);
        this.clearLargeMessage();
    }

    protected abstract void actualDelivery(AMQPMessage var1, Delivery var2, Receiver var3, Transaction var4);

    public abstract void flow();

    static class FlowControlRunner
    implements Runnable {
        final int refill;
        final int threshold;
        final Receiver receiver;
        final AMQPConnectionContext connection;
        final ProtonAbstractReceiver context;

        FlowControlRunner(int refill, int threshold, Receiver receiver, AMQPConnectionContext connection, ProtonAbstractReceiver context) {
            this.refill = refill;
            this.threshold = threshold;
            this.receiver = receiver;
            this.connection = connection;
            this.context = context;
        }

        @Override
        public void run() {
            int topUp;
            int pending;
            if (!this.connection.isHandler()) {
                this.connection.runLater(this);
                return;
            }
            this.connection.requireInHandler();
            int n = pending = this.context != null ? this.context.pendingSettles : 0;
            if (ProtonAbstractReceiver.isBellowThreshold(this.receiver.getCredit(), pending, this.threshold) && (topUp = ProtonAbstractReceiver.calculatedUpdateRefill(this.refill, this.receiver.getCredit(), pending)) > 0) {
                this.receiver.flow(topUp);
                this.connection.instantFlush();
            }
        }
    }
}

