/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.modules;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.net.URL;
import java.net.URLConnection;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import org.jboss.modules.GetURLConnectionAction;
import org.jboss.modules.JDKSpecific;
import org.jboss.modules.LocalLoader;
import org.jboss.modules.Resource;
import org.jboss.modules.URLConnectionResource;

final class ClassLoaderLocalLoader
implements LocalLoader {
    static final LocalLoader SYSTEM = JDKSpecific.getSystemLocalLoader();
    private final ClassLoader classLoader;
    private final AccessControlContext context;

    ClassLoaderLocalLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        this.context = AccessController.getContext();
    }

    @Override
    public Class<?> loadClassLocal(String name, boolean resolve) {
        try {
            return Class.forName(name, resolve, this.classLoader);
        }
        catch (ClassNotFoundException e) {
            Throwable cause = e.getCause();
            if (cause instanceof Error) {
                throw (Error)cause;
            }
            if (cause instanceof RuntimeException) {
                throw (RuntimeException)cause;
            }
            return null;
        }
    }

    @Override
    public Package loadPackageLocal(String name) {
        return JDKSpecific.getPackage(this.classLoader, name);
    }

    @Override
    public List<Resource> loadResourceLocal(String name) {
        Enumeration<URL> urls;
        ClassLoader classLoader = this.classLoader;
        try {
            urls = classLoader == null ? JDKSpecific.getSystemResources(name) : classLoader.getResources(name);
        }
        catch (IOException e) {
            return Collections.emptyList();
        }
        ArrayList<Resource> list = new ArrayList<Resource>();
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            URLConnection connection = null;
            try {
                connection = AccessController.doPrivileged(new GetURLConnectionAction(url), this.context);
            }
            catch (PrivilegedActionException e) {
                try {
                    throw e.getException();
                }
                catch (IOException iOException) {
                }
                catch (RuntimeException re) {
                    throw re;
                }
                catch (Exception e2) {
                    throw new UndeclaredThrowableException(e2);
                }
            }
            list.add(new URLConnectionResource(connection));
        }
        return list;
    }
}

