/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.core.postoffice.impl;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executor;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Stream;
import org.apache.activemq.artemis.api.core.ActiveMQAddressDoesNotExistException;
import org.apache.activemq.artemis.api.core.ActiveMQAddressFullException;
import org.apache.activemq.artemis.api.core.ActiveMQDuplicateIdException;
import org.apache.activemq.artemis.api.core.ActiveMQException;
import org.apache.activemq.artemis.api.core.ActiveMQNonExistentQueueException;
import org.apache.activemq.artemis.api.core.ActiveMQShutdownException;
import org.apache.activemq.artemis.api.core.Message;
import org.apache.activemq.artemis.api.core.Pair;
import org.apache.activemq.artemis.api.core.QueueConfiguration;
import org.apache.activemq.artemis.api.core.RoutingType;
import org.apache.activemq.artemis.api.core.SimpleString;
import org.apache.activemq.artemis.api.core.management.CoreNotificationType;
import org.apache.activemq.artemis.api.core.management.ManagementHelper;
import org.apache.activemq.artemis.api.core.management.NotificationType;
import org.apache.activemq.artemis.api.core.management.ResourceNames;
import org.apache.activemq.artemis.core.config.DivertConfiguration;
import org.apache.activemq.artemis.core.config.WildcardConfiguration;
import org.apache.activemq.artemis.core.filter.Filter;
import org.apache.activemq.artemis.core.filter.impl.FilterImpl;
import org.apache.activemq.artemis.core.io.IOCallback;
import org.apache.activemq.artemis.core.message.impl.CoreMessage;
import org.apache.activemq.artemis.core.paging.PagingManager;
import org.apache.activemq.artemis.core.paging.PagingStore;
import org.apache.activemq.artemis.core.persistence.StorageManager;
import org.apache.activemq.artemis.core.postoffice.AddressManager;
import org.apache.activemq.artemis.core.postoffice.Binding;
import org.apache.activemq.artemis.core.postoffice.BindingType;
import org.apache.activemq.artemis.core.postoffice.Bindings;
import org.apache.activemq.artemis.core.postoffice.BindingsFactory;
import org.apache.activemq.artemis.core.postoffice.DuplicateIDCache;
import org.apache.activemq.artemis.core.postoffice.PostOffice;
import org.apache.activemq.artemis.core.postoffice.QueueBinding;
import org.apache.activemq.artemis.core.postoffice.QueueInfo;
import org.apache.activemq.artemis.core.postoffice.RoutingStatus;
import org.apache.activemq.artemis.core.postoffice.impl.BindingsImpl;
import org.apache.activemq.artemis.core.postoffice.impl.DuplicateIDCacheImpl;
import org.apache.activemq.artemis.core.postoffice.impl.SimpleAddressManager;
import org.apache.activemq.artemis.core.postoffice.impl.WildcardAddressManager;
import org.apache.activemq.artemis.core.server.ActiveMQMessageBundle;
import org.apache.activemq.artemis.core.server.ActiveMQScheduledComponent;
import org.apache.activemq.artemis.core.server.ActiveMQServer;
import org.apache.activemq.artemis.core.server.ActiveMQServerLogger;
import org.apache.activemq.artemis.core.server.ComponentConfigurationRoutingType;
import org.apache.activemq.artemis.core.server.LargeServerMessage;
import org.apache.activemq.artemis.core.server.MessageReference;
import org.apache.activemq.artemis.core.server.Queue;
import org.apache.activemq.artemis.core.server.QueueFactory;
import org.apache.activemq.artemis.core.server.RouteContextList;
import org.apache.activemq.artemis.core.server.RoutingContext;
import org.apache.activemq.artemis.core.server.cluster.impl.MessageLoadBalancingType;
import org.apache.activemq.artemis.core.server.group.GroupingHandler;
import org.apache.activemq.artemis.core.server.impl.AckReason;
import org.apache.activemq.artemis.core.server.impl.AddressInfo;
import org.apache.activemq.artemis.core.server.impl.QueueManagerImpl;
import org.apache.activemq.artemis.core.server.impl.RoutingContextImpl;
import org.apache.activemq.artemis.core.server.management.ManagementService;
import org.apache.activemq.artemis.core.server.management.Notification;
import org.apache.activemq.artemis.core.server.management.NotificationListener;
import org.apache.activemq.artemis.core.server.mirror.MirrorController;
import org.apache.activemq.artemis.core.settings.HierarchicalRepository;
import org.apache.activemq.artemis.core.settings.HierarchicalRepositoryChangeListener;
import org.apache.activemq.artemis.core.settings.impl.AddressSettings;
import org.apache.activemq.artemis.core.transaction.Transaction;
import org.apache.activemq.artemis.core.transaction.TransactionOperation;
import org.apache.activemq.artemis.core.transaction.TransactionOperationAbstract;
import org.apache.activemq.artemis.core.transaction.impl.TransactionImpl;
import org.apache.activemq.artemis.utils.CompositeAddress;
import org.apache.activemq.artemis.utils.UUIDGenerator;
import org.apache.activemq.artemis.utils.collections.IterableStream;
import org.apache.activemq.artemis.utils.collections.TypedProperties;
import org.jboss.logging.Logger;

public class PostOfficeImpl
implements PostOffice,
NotificationListener,
BindingsFactory {
    private static final Logger logger = Logger.getLogger(PostOfficeImpl.class);
    public static final SimpleString HDR_RESET_QUEUE_DATA = new SimpleString("_AMQ_RESET_QUEUE_DATA");
    public static final SimpleString HDR_RESET_QUEUE_DATA_COMPLETE = new SimpleString("_AMQ_RESET_QUEUE_DATA_COMPLETE");
    public static final SimpleString BRIDGE_CACHE_STR = new SimpleString("BRIDGE.");
    private final AddressManager addressManager;
    private final QueueFactory queueFactory;
    private final StorageManager storageManager;
    private final PagingManager pagingManager;
    private volatile boolean started;
    private final ManagementService managementService;
    private ExpiryReaper expiryReaperRunnable;
    private final long expiryReaperPeriod;
    private AddressQueueReaper addressQueueReaperRunnable;
    private final long addressQueueReaperPeriod;
    private final ConcurrentMap<SimpleString, DuplicateIDCache> duplicateIDCaches = new ConcurrentHashMap<SimpleString, DuplicateIDCache>();
    private final int idCacheSize;
    private final boolean persistIDCache;
    private final Map<SimpleString, QueueInfo> queueInfos = new HashMap<SimpleString, QueueInfo>();
    private final Object notificationLock = new Object();
    private final HierarchicalRepository<AddressSettings> addressSettingsRepository;
    private final ActiveMQServer server;
    private MirrorController mirrorControllerSource;

    public PostOfficeImpl(ActiveMQServer server, StorageManager storageManager, PagingManager pagingManager, QueueFactory bindableFactory, ManagementService managementService, long expiryReaperPeriod, long addressQueueReaperPeriod, WildcardConfiguration wildcardConfiguration, int idCacheSize, boolean persistIDCache, HierarchicalRepository<AddressSettings> addressSettingsRepository) {
        this.storageManager = storageManager;
        this.queueFactory = bindableFactory;
        this.managementService = managementService;
        this.pagingManager = pagingManager;
        this.expiryReaperPeriod = expiryReaperPeriod;
        this.addressQueueReaperPeriod = addressQueueReaperPeriod;
        this.addressManager = wildcardConfiguration.isRoutingEnabled() ? new WildcardAddressManager(this, wildcardConfiguration, storageManager, server.getMetricsManager()) : new SimpleAddressManager(this, wildcardConfiguration, storageManager, server.getMetricsManager());
        this.idCacheSize = idCacheSize;
        this.persistIDCache = persistIDCache;
        this.addressSettingsRepository = addressSettingsRepository;
        this.server = server;
    }

    public synchronized void start() throws Exception {
        if (this.started) {
            return;
        }
        this.managementService.addNotificationListener(this);
        this.queueFactory.setPostOffice(this);
        this.started = true;
    }

    public synchronized void stop() throws Exception {
        this.started = false;
        this.managementService.removeNotificationListener(this);
        if (this.expiryReaperRunnable != null) {
            this.expiryReaperRunnable.stop();
        }
        if (this.addressQueueReaperRunnable != null) {
            this.addressQueueReaperRunnable.stop();
        }
        this.addressManager.clear();
        this.queueInfos.clear();
    }

    public boolean isStarted() {
        return this.started;
    }

    @Override
    public MirrorController getMirrorControlSource() {
        return this.mirrorControllerSource;
    }

    @Override
    public PostOfficeImpl setMirrorControlSource(MirrorController mirrorControllerSource) {
        this.mirrorControllerSource = mirrorControllerSource;
        return this;
    }

    @Override
    public void postAcknowledge(MessageReference ref, AckReason reason) {
        if (this.mirrorControllerSource != null) {
            try {
                this.mirrorControllerSource.postAcknowledge(ref, reason);
            }
            catch (Exception e) {
                logger.warn((Object)e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void scanAddresses(MirrorController mirrorController) throws Exception {
        this.addressManager.scanAddresses(mirrorController);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onNotification(Notification notification) {
        if (!(notification.getType() instanceof CoreNotificationType)) {
            return;
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Receiving notification : " + notification + " on server " + this.server));
        }
        Object object = this.notificationLock;
        synchronized (object) {
            CoreNotificationType type = (CoreNotificationType)notification.getType();
            switch (type) {
                case BINDING_ADDED: {
                    TypedProperties props = notification.getProperties();
                    if (!props.containsProperty(ManagementHelper.HDR_BINDING_TYPE)) {
                        throw ActiveMQMessageBundle.BUNDLE.bindingTypeNotSpecified();
                    }
                    Integer bindingType = props.getIntProperty(ManagementHelper.HDR_BINDING_TYPE);
                    if (bindingType == 2) {
                        return;
                    }
                    SimpleString routingName = props.getSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME);
                    SimpleString clusterName = props.getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
                    SimpleString address = props.getSimpleStringProperty(ManagementHelper.HDR_ADDRESS);
                    if (!props.containsProperty(ManagementHelper.HDR_BINDING_ID)) {
                        throw ActiveMQMessageBundle.BUNDLE.bindingIdNotSpecified();
                    }
                    long id = props.getLongProperty(ManagementHelper.HDR_BINDING_ID);
                    SimpleString filterString = props.getSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING);
                    if (!props.containsProperty(ManagementHelper.HDR_DISTANCE)) {
                        logger.debug((Object)"PostOffice notification / BINDING_ADDED: HDR_DISANCE not specified, giving up propagation on notifications");
                        return;
                    }
                    int distance = props.getIntProperty(ManagementHelper.HDR_DISTANCE);
                    QueueInfo info = new QueueInfo(routingName, clusterName, address, filterString, id, distance);
                    this.queueInfos.put(clusterName, info);
                    break;
                }
                case BINDING_REMOVED: {
                    TypedProperties props = notification.getProperties();
                    if (!props.containsProperty(ManagementHelper.HDR_CLUSTER_NAME)) {
                        logger.debug((Object)"PostOffice notification / BINDING_REMOVED: HDR_CLUSTER_NAME not specified, giving up propagation on notifications");
                        return;
                    }
                    SimpleString clusterName = props.getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
                    QueueInfo info = this.queueInfos.remove(clusterName);
                    if (info != null) break;
                    logger.debug((Object)"PostOffice notification / BINDING_REMOVED: Cannot find queue info for queue \" + clusterName");
                    return;
                }
                case CONSUMER_CREATED: {
                    TypedProperties props = notification.getProperties();
                    if (!props.containsProperty(ManagementHelper.HDR_CLUSTER_NAME)) {
                        logger.debug((Object)"PostOffice notification / CONSUMER_CREATED: No clusterName defined");
                        return;
                    }
                    SimpleString clusterName = props.getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
                    SimpleString filterString = props.getSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING);
                    QueueInfo info = this.queueInfos.get(clusterName);
                    if (info == null) {
                        logger.debug((Object)("PostOffice notification / CONSUMER_CREATED: Could not find queue created on clusterName = " + clusterName));
                        return;
                    }
                    info.incrementConsumers();
                    if (filterString != null) {
                        List<SimpleString> filterStrings = info.getFilterStrings();
                        if (filterStrings == null) {
                            filterStrings = new ArrayList<SimpleString>();
                            info.setFilterStrings(filterStrings);
                        }
                        filterStrings.add(filterString);
                    }
                    if (!props.containsProperty(ManagementHelper.HDR_DISTANCE)) {
                        logger.debug((Object)"PostOffice notification / CONSUMER_CREATED: No distance specified");
                        return;
                    }
                    int distance = props.getIntProperty(ManagementHelper.HDR_DISTANCE);
                    if (distance <= 0) break;
                    SimpleString queueName = props.getSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME);
                    if (queueName == null) {
                        logger.debug((Object)"PostOffice notification / CONSUMER_CREATED: No queue defined");
                        return;
                    }
                    Binding binding = this.getBinding(queueName);
                    if (binding == null) break;
                    Queue queue = (Queue)binding.getBindable();
                    AddressSettings addressSettings = this.addressSettingsRepository.getMatch(binding.getAddress().toString());
                    long redistributionDelay = addressSettings.getRedistributionDelay();
                    if (redistributionDelay == -1L) break;
                    queue.addRedistributor(redistributionDelay);
                    break;
                }
                case CONSUMER_CLOSED: {
                    TypedProperties props = notification.getProperties();
                    SimpleString clusterName = props.getSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME);
                    if (clusterName == null) {
                        logger.debug((Object)"PostOffice notification / CONSUMER_CLOSED: No cluster name");
                        return;
                    }
                    SimpleString filterString = props.getSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING);
                    QueueInfo info = this.queueInfos.get(clusterName);
                    if (info == null) {
                        return;
                    }
                    info.decrementConsumers();
                    if (filterString != null) {
                        List<SimpleString> filterStrings = info.getFilterStrings();
                        filterStrings.remove(filterString);
                    }
                    if (info.getNumberOfConsumers() > 0) break;
                    if (!props.containsProperty(ManagementHelper.HDR_DISTANCE)) {
                        logger.debug((Object)"PostOffice notification / CONSUMER_CLOSED: HDR_DISTANCE not defined");
                        return;
                    }
                    int distance = props.getIntProperty(ManagementHelper.HDR_DISTANCE);
                    if (distance != 0) break;
                    SimpleString queueName = props.getSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME);
                    if (queueName == null) {
                        logger.debug((Object)"PostOffice notification / CONSUMER_CLOSED: No queue name");
                        return;
                    }
                    Binding binding = this.getBinding(queueName);
                    if (binding == null) {
                        logger.debug((Object)("PostOffice notification / CONSUMER_CLOSED: Could not find queue " + queueName));
                        return;
                    }
                    Queue queue = (Queue)binding.getBindable();
                    AddressSettings addressSettings = this.addressSettingsRepository.getMatch(binding.getAddress().toString());
                    long redistributionDelay = addressSettings.getRedistributionDelay();
                    if (redistributionDelay == -1L) break;
                    queue.addRedistributor(redistributionDelay);
                    break;
                }
            }
        }
    }

    @Override
    public void reloadAddressInfo(AddressInfo addressInfo) throws Exception {
        this.internalAddressInfo(addressInfo, true);
    }

    @Override
    public boolean addAddressInfo(AddressInfo addressInfo) throws Exception {
        return this.internalAddressInfo(addressInfo, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean internalAddressInfo(AddressInfo addressInfo, boolean reload) throws Exception {
        PostOfficeImpl postOfficeImpl = this;
        synchronized (postOfficeImpl) {
            boolean result;
            if (this.server.hasBrokerAddressPlugins()) {
                this.server.callBrokerAddressPlugins(plugin -> plugin.beforeAddAddress(addressInfo, reload));
            }
            if (this.mirrorControllerSource != null) {
                this.mirrorControllerSource.addAddress(addressInfo);
            }
            if (result = reload ? this.addressManager.reloadAddressInfo(addressInfo) : this.addressManager.addAddressInfo(addressInfo)) {
                try {
                    long retroactiveMessageCount;
                    if (!addressInfo.isInternal()) {
                        this.managementService.registerAddress(addressInfo);
                    }
                    if (this.server.hasBrokerAddressPlugins()) {
                        this.server.callBrokerAddressPlugins(plugin -> plugin.afterAddAddress(addressInfo, reload));
                    }
                    if ((retroactiveMessageCount = this.addressSettingsRepository.getMatch(addressInfo.getName().toString()).getRetroactiveMessageCount()) > 0L && !addressInfo.isInternal() && !ResourceNames.isRetroactiveResource((String)this.server.getInternalNamingPrefix(), (SimpleString)addressInfo.getName())) {
                        this.createRetroactiveResources(addressInfo.getName(), retroactiveMessageCount, reload);
                    }
                    if (ResourceNames.isRetroactiveResource((String)this.server.getInternalNamingPrefix(), (SimpleString)addressInfo.getName())) {
                        this.registerRepositoryListenerForRetroactiveAddress(addressInfo.getName());
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return result;
        }
    }

    private void registerRepositoryListenerForRetroactiveAddress(SimpleString name) {
        HierarchicalRepositoryChangeListener repositoryChangeListener = () -> {
            Queue internalMulticastQueue;
            String prefix = this.server.getInternalNamingPrefix();
            String delimiter = this.server.getConfiguration().getWildcardConfiguration().getDelimiterString();
            String address = ResourceNames.decomposeRetroactiveResourceAddressName((String)prefix, (String)delimiter, (String)name.toString());
            AddressSettings settings = this.addressSettingsRepository.getMatch(address);
            Queue internalAnycastQueue = this.server.locateQueue(ResourceNames.getRetroactiveResourceQueueName((String)prefix, (String)delimiter, (SimpleString)SimpleString.toSimpleString((String)address), (RoutingType)RoutingType.ANYCAST));
            if (internalAnycastQueue != null && internalAnycastQueue.getRingSize() != settings.getRetroactiveMessageCount()) {
                internalAnycastQueue.setRingSize(settings.getRetroactiveMessageCount());
            }
            if ((internalMulticastQueue = this.server.locateQueue(ResourceNames.getRetroactiveResourceQueueName((String)prefix, (String)delimiter, (SimpleString)SimpleString.toSimpleString((String)address), (RoutingType)RoutingType.MULTICAST))) != null && internalMulticastQueue.getRingSize() != settings.getRetroactiveMessageCount()) {
                internalMulticastQueue.setRingSize(settings.getRetroactiveMessageCount());
            }
        };
        this.addressSettingsRepository.registerListener(repositoryChangeListener);
        this.server.getAddressInfo(name).setRepositoryChangeListener(repositoryChangeListener);
    }

    private void createRetroactiveResources(SimpleString retroactiveAddressName, long retroactiveMessageCount, boolean reload) throws Exception {
        String prefix = this.server.getInternalNamingPrefix();
        String delimiter = this.server.getConfiguration().getWildcardConfiguration().getDelimiterString();
        SimpleString internalAddressName = ResourceNames.getRetroactiveResourceAddressName((String)prefix, (String)delimiter, (SimpleString)retroactiveAddressName);
        SimpleString internalAnycastQueueName = ResourceNames.getRetroactiveResourceQueueName((String)prefix, (String)delimiter, (SimpleString)retroactiveAddressName, (RoutingType)RoutingType.ANYCAST);
        SimpleString internalMulticastQueueName = ResourceNames.getRetroactiveResourceQueueName((String)prefix, (String)delimiter, (SimpleString)retroactiveAddressName, (RoutingType)RoutingType.MULTICAST);
        SimpleString internalDivertName = ResourceNames.getRetroactiveResourceDivertName((String)prefix, (String)delimiter, (SimpleString)retroactiveAddressName);
        if (!reload) {
            AddressInfo addressInfo = new AddressInfo(internalAddressName).addRoutingType(RoutingType.MULTICAST).addRoutingType(RoutingType.ANYCAST).setInternal(false);
            this.addAddressInfo(addressInfo);
            this.server.createQueue(new QueueConfiguration(internalMulticastQueueName).setAddress(internalAddressName).setRoutingType(RoutingType.MULTICAST).setMaxConsumers(Integer.valueOf(0)).setRingSize(Long.valueOf(retroactiveMessageCount)));
            this.server.createQueue(new QueueConfiguration(internalAnycastQueueName).setAddress(internalAddressName).setRoutingType(RoutingType.ANYCAST).setMaxConsumers(Integer.valueOf(0)).setRingSize(Long.valueOf(retroactiveMessageCount)));
        }
        this.server.deployDivert(new DivertConfiguration().setName(internalDivertName.toString()).setAddress(retroactiveAddressName.toString()).setExclusive(false).setForwardingAddress(internalAddressName.toString()).setRoutingType(ComponentConfigurationRoutingType.PASS));
    }

    private void removeRetroactiveResources(SimpleString address) throws Exception {
        SimpleString internalAddressName;
        SimpleString internalMulticastQueueName;
        SimpleString internalAnycastQueueName;
        String delimiter;
        String prefix = this.server.getInternalNamingPrefix();
        SimpleString internalDivertName = ResourceNames.getRetroactiveResourceDivertName((String)prefix, (String)(delimiter = this.server.getConfiguration().getWildcardConfiguration().getDelimiterString()), (SimpleString)address);
        if (this.getBinding(internalDivertName) != null) {
            this.server.destroyDivert(internalDivertName);
        }
        if (this.server.locateQueue(internalAnycastQueueName = ResourceNames.getRetroactiveResourceQueueName((String)prefix, (String)delimiter, (SimpleString)address, (RoutingType)RoutingType.ANYCAST)) != null) {
            this.server.destroyQueue(internalAnycastQueueName);
        }
        if (this.server.locateQueue(internalMulticastQueueName = ResourceNames.getRetroactiveResourceQueueName((String)prefix, (String)delimiter, (SimpleString)address, (RoutingType)RoutingType.MULTICAST)) != null) {
            this.server.destroyQueue(internalMulticastQueueName);
        }
        if (this.server.getAddressInfo(internalAddressName = ResourceNames.getRetroactiveResourceAddressName((String)prefix, (String)delimiter, (SimpleString)address)) != null) {
            this.server.removeAddressInfo(internalAddressName, null);
        }
    }

    @Override
    @Deprecated
    public QueueBinding updateQueue(SimpleString name, RoutingType routingType, Filter filter, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, SimpleString groupFirstKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, SimpleString user, Boolean configurationManaged) throws Exception {
        return this.updateQueue(name, routingType, filter, maxConsumers, purgeOnNoConsumers, exclusive, groupRebalance, groupBuckets, groupFirstKey, nonDestructive, consumersBeforeDispatch, delayBeforeDispatch, user, configurationManaged, null);
    }

    @Override
    @Deprecated
    public QueueBinding updateQueue(SimpleString name, RoutingType routingType, Filter filter, Integer maxConsumers, Boolean purgeOnNoConsumers, Boolean exclusive, Boolean groupRebalance, Integer groupBuckets, SimpleString groupFirstKey, Boolean nonDestructive, Integer consumersBeforeDispatch, Long delayBeforeDispatch, SimpleString user, Boolean configurationManaged, Long ringSize) throws Exception {
        return this.updateQueue(new QueueConfiguration(name).setRoutingType(routingType).setFilterString(filter.getFilterString()).setMaxConsumers(maxConsumers).setPurgeOnNoConsumers(purgeOnNoConsumers).setExclusive(exclusive).setGroupRebalance(groupRebalance).setGroupBuckets(groupBuckets).setGroupFirstKey(groupFirstKey).setNonDestructive(nonDestructive).setConsumersBeforeDispatch(consumersBeforeDispatch).setDelayBeforeDispatch(delayBeforeDispatch).setUser(user).setConfigurationManaged(configurationManaged).setRingSize(ringSize));
    }

    @Override
    public QueueBinding updateQueue(QueueConfiguration queueConfiguration) throws Exception {
        return this.updateQueue(queueConfiguration, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueueBinding updateQueue(QueueConfiguration queueConfiguration, boolean forceUpdate) throws Exception {
        PostOfficeImpl postOfficeImpl = this;
        synchronized (postOfficeImpl) {
            QueueBinding queueBinding;
            block28: {
                queueBinding = (QueueBinding)this.addressManager.getBinding(queueConfiguration.getName());
                if (queueBinding == null) {
                    return null;
                }
                Bindings bindingsOnQueue = this.addressManager.getBindingsForRoutingAddress(queueBinding.getAddress());
                try {
                    SimpleString address;
                    AddressInfo addressInfo;
                    EnumSet<RoutingType> addressRoutingTypes;
                    int consumerCount;
                    Queue queue = queueBinding.getQueue();
                    boolean changed = false;
                    if (queueConfiguration.getMaxConsumers() != null && queueConfiguration.getMaxConsumers() != -1 && (consumerCount = queue.getConsumerCount()) > queueConfiguration.getMaxConsumers()) {
                        throw ActiveMQMessageBundle.BUNDLE.invalidMaxConsumersUpdate(queueConfiguration.getName().toString(), queueConfiguration.getMaxConsumers(), consumerCount);
                    }
                    if (queueConfiguration.getRoutingType() != null && !(addressRoutingTypes = (addressInfo = this.addressManager.getAddressInfo(address = queue.getAddress())).getRoutingTypes()).contains(queueConfiguration.getRoutingType())) {
                        throw ActiveMQMessageBundle.BUNDLE.invalidRoutingTypeUpdate(queueConfiguration.getName().toString(), queueConfiguration.getRoutingType(), address.toString(), addressRoutingTypes);
                    }
                    if ((forceUpdate || queueConfiguration.getMaxConsumers() != null) && !Objects.equals(queue.getMaxConsumers(), queueConfiguration.getMaxConsumers())) {
                        changed = true;
                        queue.setMaxConsumer(queueConfiguration.getMaxConsumers());
                    }
                    if ((forceUpdate || queueConfiguration.getRoutingType() != null) && !Objects.equals(queue.getRoutingType(), queueConfiguration.getRoutingType())) {
                        changed = true;
                        queue.setRoutingType(queueConfiguration.getRoutingType());
                    }
                    if ((forceUpdate || queueConfiguration.isPurgeOnNoConsumers() != null) && !Objects.equals(queue.isPurgeOnNoConsumers(), queueConfiguration.isPurgeOnNoConsumers())) {
                        changed = true;
                        queue.setPurgeOnNoConsumers(queueConfiguration.isPurgeOnNoConsumers());
                    }
                    if ((forceUpdate || queueConfiguration.isEnabled() != null) && !Objects.equals(queue.isEnabled(), queueConfiguration.isEnabled())) {
                        changed = true;
                        queue.setEnabled(queueConfiguration.isEnabled());
                    }
                    if ((forceUpdate || queueConfiguration.isExclusive() != null) && !Objects.equals(queue.isExclusive(), queueConfiguration.isExclusive())) {
                        changed = true;
                        queue.setExclusive(queueConfiguration.isExclusive());
                    }
                    if ((forceUpdate || queueConfiguration.isGroupRebalance() != null) && !Objects.equals(queue.isGroupRebalance(), queueConfiguration.isGroupRebalance())) {
                        changed = true;
                        queue.setGroupRebalance(queueConfiguration.isGroupRebalance());
                    }
                    if ((forceUpdate || queueConfiguration.isGroupRebalancePauseDispatch() != null) && !Objects.equals(queue.isGroupRebalancePauseDispatch(), queueConfiguration.isGroupRebalancePauseDispatch())) {
                        changed = true;
                        queue.setGroupRebalancePauseDispatch(queueConfiguration.isGroupRebalancePauseDispatch());
                    }
                    if ((forceUpdate || queueConfiguration.getGroupBuckets() != null) && !Objects.equals(queue.getGroupBuckets(), queueConfiguration.getGroupBuckets())) {
                        changed = true;
                        queue.setGroupBuckets(queueConfiguration.getGroupBuckets());
                    }
                    if ((forceUpdate || queueConfiguration.getGroupFirstKey() != null) && !Objects.equals(queueConfiguration.getGroupFirstKey(), queue.getGroupFirstKey())) {
                        changed = true;
                        queue.setGroupFirstKey(queueConfiguration.getGroupFirstKey());
                    }
                    if ((forceUpdate || queueConfiguration.isNonDestructive() != null) && !Objects.equals(queue.isNonDestructive(), queueConfiguration.isNonDestructive())) {
                        changed = true;
                        queue.setNonDestructive(queueConfiguration.isNonDestructive());
                    }
                    if ((forceUpdate || queueConfiguration.getConsumersBeforeDispatch() != null) && !Objects.equals(queueConfiguration.getConsumersBeforeDispatch(), queue.getConsumersBeforeDispatch())) {
                        changed = true;
                        queue.setConsumersBeforeDispatch(queueConfiguration.getConsumersBeforeDispatch());
                    }
                    if ((forceUpdate || queueConfiguration.getDelayBeforeDispatch() != null) && !Objects.equals(queueConfiguration.getDelayBeforeDispatch(), queue.getDelayBeforeDispatch())) {
                        changed = true;
                        queue.setDelayBeforeDispatch(queueConfiguration.getDelayBeforeDispatch());
                    }
                    SimpleString empty = new SimpleString("");
                    Filter oldFilter = FilterImpl.createFilter(queue.getFilter() == null ? empty : queue.getFilter().getFilterString());
                    Filter newFilter = FilterImpl.createFilter(queueConfiguration.getFilterString() == null ? empty : queueConfiguration.getFilterString());
                    if ((forceUpdate || newFilter != oldFilter) && !Objects.equals(oldFilter, newFilter)) {
                        changed = true;
                        queue.setFilter(newFilter);
                    }
                    if ((forceUpdate || queueConfiguration.isConfigurationManaged() != null) && !Objects.equals(queueConfiguration.isConfigurationManaged(), queue.isConfigurationManaged())) {
                        changed = true;
                        queue.setConfigurationManaged(queueConfiguration.isConfigurationManaged());
                    }
                    if ((forceUpdate || queueConfiguration.getUser() != null) && !Objects.equals(queueConfiguration.getUser(), queue.getUser())) {
                        changed = true;
                        queue.setUser(queueConfiguration.getUser());
                    }
                    if ((forceUpdate || queueConfiguration.getRingSize() != null) && !Objects.equals(queueConfiguration.getRingSize(), queue.getRingSize())) {
                        changed = true;
                        queue.setRingSize(queueConfiguration.getRingSize());
                    }
                    if (!changed) break block28;
                    long txID = this.storageManager.generateID();
                    try {
                        this.storageManager.updateQueueBinding(txID, queueBinding);
                        this.storageManager.commitBindings(txID);
                    }
                    catch (Throwable throwable) {
                        this.storageManager.rollback(txID);
                        logger.warn((Object)throwable.getMessage(), throwable);
                        throw throwable;
                    }
                }
                finally {
                    if (bindingsOnQueue != null) {
                        bindingsOnQueue.updated(queueBinding);
                    }
                }
            }
            return queueBinding;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressInfo updateAddressInfo(SimpleString addressName, EnumSet<RoutingType> routingTypes) throws Exception {
        PostOfficeImpl postOfficeImpl = this;
        synchronized (postOfficeImpl) {
            if (this.server.hasBrokerAddressPlugins()) {
                this.server.callBrokerAddressPlugins(plugin -> plugin.beforeUpdateAddress(addressName, routingTypes));
            }
            AddressInfo address = this.addressManager.updateAddressInfo(addressName, routingTypes);
            if (this.server.hasBrokerAddressPlugins()) {
                this.server.callBrokerAddressPlugins(plugin -> plugin.afterUpdateAddress(address));
            }
            return address;
        }
    }

    @Override
    public AddressInfo removeAddressInfo(SimpleString address) throws Exception {
        return this.removeAddressInfo(address, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AddressInfo removeAddressInfo(SimpleString address, boolean force) throws Exception {
        PostOfficeImpl postOfficeImpl = this;
        synchronized (postOfficeImpl) {
            if (this.server.hasBrokerAddressPlugins()) {
                this.server.callBrokerAddressPlugins(plugin -> plugin.beforeRemoveAddress(address));
            }
            Collection<Binding> bindingsForAddress = this.getDirectBindings(address);
            if (force) {
                for (Binding binding : bindingsForAddress) {
                    if (!(binding instanceof QueueBinding)) continue;
                    ((QueueBinding)binding).getQueue().deleteQueue(true);
                }
            } else if (!bindingsForAddress.isEmpty()) {
                throw ActiveMQMessageBundle.BUNDLE.addressHasBindings(address);
            }
            this.managementService.unregisterAddress(address);
            AddressInfo addressInfo = this.addressManager.removeAddressInfo(address);
            if (this.mirrorControllerSource != null && addressInfo != null) {
                this.mirrorControllerSource.deleteAddress(addressInfo);
            }
            this.removeRetroactiveResources(address);
            if (this.server.hasBrokerAddressPlugins()) {
                this.server.callBrokerAddressPlugins(plugin -> plugin.afterRemoveAddress(address, addressInfo));
            }
            return addressInfo;
        }
    }

    @Override
    public AddressInfo getAddressInfo(SimpleString addressName) {
        return this.addressManager.getAddressInfo(addressName);
    }

    @Override
    public List<Queue> listQueuesForAddress(SimpleString address) throws Exception {
        Bindings bindingsForAddress = this.lookupBindingsForAddress(address);
        ArrayList<Queue> queues = new ArrayList<Queue>();
        if (bindingsForAddress != null) {
            for (Binding b : bindingsForAddress.getBindings()) {
                if (!(b instanceof QueueBinding)) continue;
                Queue q = ((QueueBinding)b).getQueue();
                queues.add(q);
            }
        }
        return queues;
    }

    @Override
    public synchronized void addBinding(Binding binding) throws Exception {
        if (this.server.hasBrokerBindingPlugins()) {
            this.server.callBrokerBindingPlugins(plugin -> plugin.beforeAddBinding(binding));
        }
        this.addressManager.addBinding(binding);
        TypedProperties props = new TypedProperties();
        props.putIntProperty(ManagementHelper.HDR_BINDING_TYPE, binding.getType().toInt());
        props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, binding.getAddress());
        props.putSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME, binding.getClusterName());
        props.putSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME, binding.getRoutingName());
        props.putLongProperty(ManagementHelper.HDR_BINDING_ID, binding.getID());
        props.putIntProperty(ManagementHelper.HDR_DISTANCE, binding.getDistance());
        Filter filter = binding.getFilter();
        if (filter != null) {
            props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, filter.getFilterString());
        }
        String uid = UUIDGenerator.getInstance().generateStringUUID();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("ClusterCommunication::Sending notification for addBinding " + binding + " from server " + this.server));
        }
        this.managementService.sendNotification(new Notification(uid, (NotificationType)CoreNotificationType.BINDING_ADDED, props));
        if (this.server.hasBrokerBindingPlugins()) {
            this.server.callBrokerBindingPlugins(plugin -> plugin.afterAddBinding(binding));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized Binding removeBinding(SimpleString uniqueName, Transaction tx, boolean deleteData) throws Exception {
        if (this.server.hasBrokerBindingPlugins()) {
            this.server.callBrokerBindingPlugins(plugin -> plugin.beforeRemoveBinding(uniqueName, tx, deleteData));
        }
        try {
            Binding binding = this.addressManager.removeBinding(uniqueName, tx);
            if (binding == null) {
                throw new ActiveMQNonExistentQueueException();
            }
            if (deleteData && this.addressManager.getBindingsForRoutingAddress(binding.getAddress()) == null) {
                this.deleteDuplicateCache(binding.getAddress());
            }
            if (binding.getType() == BindingType.LOCAL_QUEUE) {
                Queue queue = (Queue)binding.getBindable();
                this.managementService.unregisterQueue(uniqueName, binding.getAddress(), queue.getRoutingType());
            } else if (binding.getType() == BindingType.DIVERT) {
                this.managementService.unregisterDivert(uniqueName, binding.getAddress());
            }
            AddressInfo addressInfo = this.getAddressInfo(binding.getAddress());
            if (addressInfo != null) {
                addressInfo.setBindingRemovedTimestamp(System.currentTimeMillis());
            }
            if (binding.getType() != BindingType.DIVERT) {
                TypedProperties props = new TypedProperties();
                props.putSimpleStringProperty(ManagementHelper.HDR_ADDRESS, binding.getAddress());
                props.putSimpleStringProperty(ManagementHelper.HDR_CLUSTER_NAME, binding.getClusterName());
                props.putSimpleStringProperty(ManagementHelper.HDR_ROUTING_NAME, binding.getRoutingName());
                props.putIntProperty(ManagementHelper.HDR_DISTANCE, binding.getDistance());
                props.putLongProperty(ManagementHelper.HDR_BINDING_ID, binding.getID());
                if (binding.getFilter() == null) {
                    props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, null);
                } else {
                    props.putSimpleStringProperty(ManagementHelper.HDR_FILTERSTRING, binding.getFilter().getFilterString());
                }
                this.managementService.sendNotification(new Notification(null, (NotificationType)CoreNotificationType.BINDING_REMOVED, props));
            }
            binding.close();
            if (this.server.hasBrokerBindingPlugins()) {
                this.server.callBrokerBindingPlugins(plugin -> plugin.afterRemoveBinding(binding, tx, deleteData));
            }
            Binding binding2 = binding;
            return binding2;
        }
        finally {
            this.server.clearAddressCache();
        }
    }

    private void deleteDuplicateCache(SimpleString address) throws Exception {
        DuplicateIDCache cache = (DuplicateIDCache)this.duplicateIDCaches.remove(address);
        if (cache != null) {
            cache.clear();
        }
        if ((cache = (DuplicateIDCache)this.duplicateIDCaches.remove(BRIDGE_CACHE_STR.concat(address))) != null) {
            cache.clear();
        }
    }

    @Override
    public boolean isAddressBound(SimpleString address) throws Exception {
        Bindings bindings = this.lookupBindingsForAddress(address);
        return bindings != null && !bindings.getBindings().isEmpty();
    }

    @Override
    public Bindings getBindingsForAddress(SimpleString address) throws Exception {
        Bindings bindings = this.addressManager.getBindingsForRoutingAddress(address);
        if (bindings == null) {
            bindings = this.createBindings(address);
        }
        return bindings;
    }

    @Override
    public Bindings lookupBindingsForAddress(SimpleString address) throws Exception {
        return this.addressManager.getBindingsForRoutingAddress(address);
    }

    @Override
    public Binding getBinding(SimpleString name) {
        return this.addressManager.getBinding(name);
    }

    @Override
    public Collection<Binding> getMatchingBindings(SimpleString address) throws Exception {
        return this.addressManager.getMatchingBindings(address);
    }

    @Override
    public Collection<Binding> getDirectBindings(SimpleString address) throws Exception {
        return this.addressManager.getDirectBindings(address);
    }

    @Override
    public Stream<Binding> getAllBindings() {
        return this.addressManager.getBindings();
    }

    @Override
    public RoutingStatus route(Message message, boolean direct) throws Exception {
        return this.route(message, (Transaction)null, direct);
    }

    @Override
    public RoutingStatus route(Message message, Transaction tx, boolean direct) throws Exception {
        return this.route(message, new RoutingContextImpl(tx), direct);
    }

    @Override
    public RoutingStatus route(Message message, Transaction tx, boolean direct, boolean rejectDuplicates) throws Exception {
        return this.route(message, new RoutingContextImpl(tx), direct, rejectDuplicates, null);
    }

    @Override
    public RoutingStatus route(Message message, Transaction tx, boolean direct, boolean rejectDuplicates, Binding binding) throws Exception {
        return this.route(message, new RoutingContextImpl(tx), direct, rejectDuplicates, binding);
    }

    @Override
    public RoutingStatus route(Message message, RoutingContext context, boolean direct) throws Exception {
        return this.route(message, context, direct, true, null, false);
    }

    @Override
    public RoutingStatus route(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates, Binding bindingMove) throws Exception {
        return this.route(message, context, direct, rejectDuplicates, bindingMove, false);
    }

    private RoutingStatus route(Message message, RoutingContext context, boolean direct, boolean rejectDuplicates, Binding bindingMove, boolean sendToDLA) throws Exception {
        RoutingStatus result;
        if (message.getRefCount() > 0) {
            throw new IllegalStateException("Message cannot be routed more than once");
        }
        SimpleString address = context.getAddress(message);
        AtomicBoolean startedTX = new AtomicBoolean(false);
        this.applyExpiryDelay(message, address);
        if (context.isDuplicateDetection() && !this.checkDuplicateID(message, context, rejectDuplicates, startedTX)) {
            return RoutingStatus.DUPLICATED_ID;
        }
        message.clearInternalProperties();
        Bindings bindings = this.addressManager.getBindingsForRoutingAddress(address);
        AddressInfo addressInfo = this.addressManager.getAddressInfo(address);
        if (bindingMove != null) {
            context.clear();
            context.setReusable(false);
            bindingMove.route(message, context);
            if (addressInfo != null) {
                addressInfo.incrementRoutedMessageCount();
            }
        } else if (bindings != null) {
            bindings.route(message, context);
            if (addressInfo != null) {
                addressInfo.incrementRoutedMessageCount();
            }
        } else {
            context.setReusable(false);
            if (addressInfo != null) {
                addressInfo.incrementUnRoutedMessageCount();
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("Couldn't find any bindings for address=" + address + " on message=" + message));
            }
        }
        if (this.server.hasBrokerMessagePlugins()) {
            this.server.callBrokerMessagePlugins(plugin -> plugin.beforeMessageRoute(message, context, direct, rejectDuplicates));
        }
        if (logger.isTraceEnabled()) {
            logger.trace((Object)("Message after routed=" + message + "\n" + context.toString()));
        }
        try {
            if (context.getQueueCount() == 0) {
                AddressSettings addressSettings = this.addressSettingsRepository.getMatch(address.toString());
                if (sendToDLA = sendToDLA ? false : addressSettings.isSendToDLAOnNoRoute()) {
                    SimpleString dlaAddress = addressSettings.getDeadLetterAddress();
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("sending message to dla address = " + dlaAddress + ", message=" + message));
                    }
                    if (dlaAddress == null) {
                        result = RoutingStatus.NO_BINDINGS;
                        ActiveMQServerLogger.LOGGER.noDLA(address);
                    } else {
                        message.referenceOriginalMessage(message, null);
                        message.setAddress(dlaAddress);
                        message.reencode();
                        this.route(message, new RoutingContextImpl(context.getTransaction()), false, true, null, sendToDLA);
                        result = RoutingStatus.NO_BINDINGS_DLA;
                    }
                } else {
                    result = RoutingStatus.NO_BINDINGS;
                    if (logger.isDebugEnabled()) {
                        logger.debug((Object)("Message " + message + " is not going anywhere as it didn't have a binding on address:" + address));
                    }
                    if (message.isLargeMessage()) {
                        ((LargeServerMessage)message).deleteFile();
                    }
                }
            } else {
                result = RoutingStatus.OK;
                try {
                    this.processRoute(message, context, direct);
                }
                catch (ActiveMQAddressFullException e) {
                    if (startedTX.get()) {
                        context.getTransaction().rollback();
                    } else if (context.getTransaction() != null) {
                        context.getTransaction().markAsRollbackOnly((ActiveMQException)((Object)e));
                    }
                    throw e;
                }
            }
            if (startedTX.get()) {
                context.getTransaction().commit();
            }
        }
        catch (Exception e) {
            if (this.server.hasBrokerMessagePlugins()) {
                this.server.callBrokerMessagePlugins(plugin -> plugin.onMessageRouteException(message, context, direct, rejectDuplicates, e));
            }
            throw e;
        }
        if (this.server.hasBrokerMessagePlugins()) {
            this.server.callBrokerMessagePlugins(plugin -> plugin.afterMessageRoute(message, context, direct, rejectDuplicates, result));
        }
        return result;
    }

    private void applyExpiryDelay(Message message, SimpleString address) {
        long expirationOverride = this.addressSettingsRepository.getMatch(address.toString()).getExpiryDelay();
        if (expirationOverride >= 0L) {
            if (message.getExpiration() == 0L) {
                message.setExpiration(System.currentTimeMillis() + expirationOverride);
            }
        } else {
            long minExpiration = this.addressSettingsRepository.getMatch(address.toString()).getMinExpiryDelay();
            long maxExpiration = this.addressSettingsRepository.getMatch(address.toString()).getMaxExpiryDelay();
            if (maxExpiration != -1L && (message.getExpiration() == 0L || message.getExpiration() > System.currentTimeMillis() + maxExpiration)) {
                message.setExpiration(System.currentTimeMillis() + maxExpiration);
            } else if (minExpiration != -1L && message.getExpiration() < System.currentTimeMillis() + minExpiration) {
                message.setExpiration(System.currentTimeMillis() + minExpiration);
            }
        }
    }

    @Override
    public MessageReference reload(Message message, Queue queue, Transaction tx) throws Exception {
        Long scheduledDeliveryTime;
        MessageReference reference = MessageReference.Factory.createReference(message, queue, this.pagingManager.getPageStore(message.getAddressSimpleString()));
        if (message.hasScheduledDeliveryTime() && (scheduledDeliveryTime = message.getScheduledDeliveryTime()) != null) {
            reference.setScheduledDeliveryTime(scheduledDeliveryTime);
        }
        queue.refUp(reference);
        queue.durableUp(message);
        if (tx == null) {
            queue.reload(reference);
        } else {
            ArrayList<MessageReference> refs = new ArrayList<MessageReference>(1);
            refs.add(reference);
            tx.addOperation(new AddOperation(refs));
        }
        return reference;
    }

    @Override
    public Pair<RoutingContext, Message> redistribute(Message message, Queue originatingQueue, Transaction tx) throws Exception {
        Bindings bindings = this.addressManager.getBindingsForRoutingAddress(originatingQueue.getAddress());
        if (bindings != null && bindings.allowRedistribute()) {
            RoutingContextImpl context;
            boolean routed;
            final Message copyRedistribute = message.copy(this.storageManager.generateID());
            copyRedistribute.setAddress(originatingQueue.getAddress());
            if (tx != null) {
                tx.addOperation(new TransactionOperationAbstract(){

                    @Override
                    public void afterRollback(Transaction tx) {
                    }
                });
            }
            if (routed = bindings.redistribute(copyRedistribute, originatingQueue, context = new RoutingContextImpl(tx))) {
                return new Pair((Object)context, (Object)copyRedistribute);
            }
        }
        return null;
    }

    @Override
    public DuplicateIDCache getDuplicateIDCache(SimpleString address) {
        DuplicateIDCache oldCache;
        DuplicateIDCache cache = (DuplicateIDCache)this.duplicateIDCaches.get(address);
        if (cache == null && (oldCache = this.duplicateIDCaches.putIfAbsent(address, cache = new DuplicateIDCacheImpl(address, this.idCacheSize, this.storageManager, this.persistIDCache))) != null) {
            cache = oldCache;
        }
        return cache;
    }

    public ConcurrentMap<SimpleString, DuplicateIDCache> getDuplicateIDCaches() {
        return this.duplicateIDCaches;
    }

    @Override
    public Object getNotificationLock() {
        return this.notificationLock;
    }

    @Override
    public Set<SimpleString> getAddresses() {
        return this.addressManager.getAddresses();
    }

    @Override
    public void updateMessageLoadBalancingTypeForAddress(SimpleString address, MessageLoadBalancingType messageLoadBalancingType) throws Exception {
        this.addressManager.updateMessageLoadBalancingTypeForAddress(address, messageLoadBalancingType);
    }

    @Override
    public SimpleString getMatchingQueue(SimpleString address, RoutingType routingType) throws Exception {
        return this.addressManager.getMatchingQueue(address, routingType);
    }

    @Override
    public SimpleString getMatchingQueue(SimpleString address, SimpleString queueName, RoutingType routingType) throws Exception {
        return this.addressManager.getMatchingQueue(address, queueName, routingType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void sendQueueInfoToQueue(SimpleString queueName, SimpleString address) throws Exception {
        Binding binding = this.addressManager.getBinding(queueName);
        if (binding == null) {
            throw new IllegalStateException("Cannot find queue " + queueName);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("PostOffice.sendQueueInfoToQueue on server=" + this.server + ", queueName=" + queueName + " and address=" + address));
        }
        Queue queue = (Queue)binding.getBindable();
        Object object = this.notificationLock;
        synchronized (object) {
            CoreMessage message = new CoreMessage(this.storageManager.generateID(), 50);
            message.setAddress(queueName);
            message.putBooleanProperty(HDR_RESET_QUEUE_DATA, true);
            this.routeQueueInfo((Message)message, queue, false);
            for (QueueInfo info : this.queueInfos.values()) {
                if (logger.isTraceEnabled()) {
                    logger.trace((Object)("QueueInfo on sendQueueInfoToQueue = " + info));
                }
                if (!info.matchesAddress(address)) continue;
                message = this.createQueueInfoMessage((NotificationType)CoreNotificationType.BINDING_ADDED, queueName);
                message.putStringProperty(ManagementHelper.HDR_ADDRESS, info.getAddress());
                message.putStringProperty(ManagementHelper.HDR_CLUSTER_NAME, info.getClusterName());
                message.putStringProperty(ManagementHelper.HDR_ROUTING_NAME, info.getRoutingName());
                message.putLongProperty(ManagementHelper.HDR_BINDING_ID, info.getID());
                message.putStringProperty(ManagementHelper.HDR_FILTERSTRING, info.getFilterString());
                message.putIntProperty(ManagementHelper.HDR_DISTANCE, info.getDistance());
                this.routeQueueInfo((Message)message, queue, true);
                int consumersWithFilters = info.getFilterStrings() != null ? info.getFilterStrings().size() : 0;
                for (int i = 0; i < info.getNumberOfConsumers() - consumersWithFilters; ++i) {
                    message = this.createQueueInfoMessage((NotificationType)CoreNotificationType.CONSUMER_CREATED, queueName);
                    message.putStringProperty(ManagementHelper.HDR_ADDRESS, info.getAddress());
                    message.putStringProperty(ManagementHelper.HDR_CLUSTER_NAME, info.getClusterName());
                    message.putStringProperty(ManagementHelper.HDR_ROUTING_NAME, info.getRoutingName());
                    message.putIntProperty(ManagementHelper.HDR_DISTANCE, info.getDistance());
                    this.routeQueueInfo((Message)message, queue, true);
                }
                if (info.getFilterStrings() == null) continue;
                for (SimpleString filterString : info.getFilterStrings()) {
                    message = this.createQueueInfoMessage((NotificationType)CoreNotificationType.CONSUMER_CREATED, queueName);
                    message.putStringProperty(ManagementHelper.HDR_ADDRESS, info.getAddress());
                    message.putStringProperty(ManagementHelper.HDR_CLUSTER_NAME, info.getClusterName());
                    message.putStringProperty(ManagementHelper.HDR_ROUTING_NAME, info.getRoutingName());
                    message.putStringProperty(ManagementHelper.HDR_FILTERSTRING, filterString);
                    message.putIntProperty(ManagementHelper.HDR_DISTANCE, info.getDistance());
                    this.routeQueueInfo((Message)message, queue, true);
                }
            }
            CoreMessage completeMessage = new CoreMessage(this.storageManager.generateID(), 50);
            completeMessage.setAddress(queueName);
            completeMessage.putBooleanProperty(HDR_RESET_QUEUE_DATA_COMPLETE, true);
            this.routeQueueInfo((Message)completeMessage, queue, false);
        }
    }

    public String toString() {
        return "PostOfficeImpl [server=" + this.server + "]";
    }

    private void routeQueueInfo(Message message, Queue queue, boolean applyFilters) throws Exception {
        if (!applyFilters || queue.getFilter() == null || queue.getFilter().match(message)) {
            RoutingContextImpl context = new RoutingContextImpl(null);
            queue.route(message, context);
            this.processRoute(message, context, false);
        }
    }

    @Override
    public void processRoute(Message message, final RoutingContext context, final boolean direct) throws Exception {
        final ArrayList<MessageReference> refs = new ArrayList<MessageReference>();
        Transaction tx = context.getTransaction();
        Long deliveryTime = null;
        if (message.hasScheduledDeliveryTime()) {
            deliveryTime = message.getScheduledDeliveryTime();
        }
        PagingStore owningStore = this.pagingManager.getPageStore(message.getAddressSimpleString());
        for (Map.Entry<SimpleString, RouteContextList> entry : context.getContexListing().entrySet()) {
            MessageReference reference;
            PagingStore store = entry.getKey() == message.getAddressSimpleString() || entry.getKey().equals((Object)message.getAddressSimpleString()) ? owningStore : this.pagingManager.getPageStore(entry.getKey());
            if (store != null && this.storageManager.addToPage(store, message, context.getTransaction(), entry.getValue())) {
                if (message.isLargeMessage()) {
                    this.confirmLargeMessageSend(tx, message);
                }
                this.schedulePageDelivery(tx, entry);
                continue;
            }
            for (Queue queue : entry.getValue().getNonDurableQueues()) {
                reference = MessageReference.Factory.createReference(message, queue, owningStore);
                if (deliveryTime != null) {
                    reference.setScheduledDeliveryTime(deliveryTime);
                }
                refs.add(reference);
                queue.refUp(reference);
            }
            Iterator<Queue> iter = entry.getValue().getDurableQueues().iterator();
            while (iter.hasNext()) {
                Queue queue;
                queue = iter.next();
                reference = MessageReference.Factory.createReference(message, queue, owningStore);
                if (context.isAlreadyAcked(context.getAddress(message), queue)) {
                    reference.setAlreadyAcked();
                    if (tx != null) {
                        queue.acknowledge(tx, reference);
                    }
                }
                if (deliveryTime != null) {
                    reference.setScheduledDeliveryTime(deliveryTime);
                }
                refs.add(reference);
                queue.refUp(reference);
                if (!message.isDurable()) continue;
                int durableRefCount = queue.durableUp(message);
                if (durableRefCount == 1) {
                    if (tx != null) {
                        this.storageManager.storeMessageTransactional(tx.getID(), message);
                    } else {
                        this.storageManager.storeMessage(message);
                    }
                    if (message.isLargeMessage()) {
                        this.confirmLargeMessageSend(tx, message);
                    }
                }
                if (tx != null) {
                    this.storageManager.storeReferenceTransactional(tx.getID(), queue.getID(), message.getMessageID());
                    tx.setContainsPersistent();
                } else {
                    this.storageManager.storeReference(queue.getID(), message.getMessageID(), !iter.hasNext());
                }
                if (deliveryTime == null || deliveryTime <= 0L) continue;
                if (tx != null) {
                    this.storageManager.updateScheduledDeliveryTimeTransactional(tx.getID(), reference);
                    continue;
                }
                this.storageManager.updateScheduledDeliveryTime(reference);
            }
        }
        if (this.mirrorControllerSource != null && !context.isMirrorController()) {
            this.mirrorControllerSource.sendMessage(message, context, refs);
        }
        if (tx != null) {
            tx.addOperation(new AddOperation(refs));
        } else {
            this.storageManager.afterCompleteOperations(new IOCallback(){

                public void onError(int errorCode, String errorMessage) {
                    ActiveMQServerLogger.LOGGER.ioErrorAddingReferences(errorCode, errorMessage);
                }

                public void done() {
                    context.processReferences(refs, direct);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void confirmLargeMessageSend(Transaction tx, Message message) throws Exception {
        LargeServerMessage largeServerMessage;
        LargeServerMessage largeServerMessage2 = largeServerMessage = (LargeServerMessage)message;
        synchronized (largeServerMessage2) {
            if (largeServerMessage.getPendingRecordID() >= 0L) {
                if (tx == null) {
                    this.storageManager.confirmPendingLargeMessage(largeServerMessage.getPendingRecordID());
                } else {
                    this.storageManager.confirmPendingLargeMessageTX(tx, largeServerMessage.getMessageID(), largeServerMessage.getPendingRecordID());
                }
                largeServerMessage.setPendingRecordID(-1L);
            }
        }
    }

    private void schedulePageDelivery(Transaction tx, Map.Entry<SimpleString, RouteContextList> entry) {
        if (tx != null) {
            PageDelivery delivery = (PageDelivery)tx.getProperty(7);
            if (delivery == null) {
                delivery = new PageDelivery();
                tx.putProperty(7, delivery);
                tx.addOperation(delivery);
            }
            delivery.addQueues(entry.getValue().getDurableQueues());
            delivery.addQueues(entry.getValue().getNonDurableQueues());
        } else {
            List<Queue> durableQueues = entry.getValue().getDurableQueues();
            List<Queue> nonDurableQueues = entry.getValue().getNonDurableQueues();
            final ArrayList<Queue> queues = new ArrayList<Queue>(durableQueues.size() + nonDurableQueues.size());
            queues.addAll(durableQueues);
            queues.addAll(nonDurableQueues);
            this.storageManager.afterCompleteOperations(new IOCallback(){

                public void onError(int errorCode, String errorMessage) {
                }

                public void done() {
                    for (Queue queue : queues) {
                        queue.deliverAsync();
                    }
                }
            });
        }
    }

    private boolean checkDuplicateID(Message message, RoutingContext context, boolean rejectDuplicates, AtomicBoolean startedTX) throws Exception {
        byte[] bridgeDup = message.removeExtraBytesProperty(Message.HDR_BRIDGE_DUPLICATE_ID);
        if (bridgeDup != null) {
            byte[] bridgeDupBytes = bridgeDup;
            DuplicateIDCache cacheBridge = this.getDuplicateIDCache(BRIDGE_CACHE_STR.concat(context.getAddress(message).toString()));
            if (context.getTransaction() == null) {
                context.setTransaction(new TransactionImpl(this.storageManager));
                startedTX.set(true);
            }
            if (!cacheBridge.atomicVerify(bridgeDupBytes, context.getTransaction())) {
                context.getTransaction().rollback();
                startedTX.set(false);
                message.usageDown();
                return false;
            }
        } else {
            byte[] duplicateIDBytes = message.getDuplicateIDBytes();
            DuplicateIDCache cache = null;
            boolean isDuplicate = false;
            if (duplicateIDBytes != null) {
                cache = this.getDuplicateIDCache(context.getAddress(message));
                isDuplicate = cache.contains(duplicateIDBytes);
                if (rejectDuplicates && isDuplicate) {
                    ActiveMQServerLogger.LOGGER.duplicateMessageDetected(message);
                    String warnMessage = "Duplicate message detected - message will not be routed. Message information:" + message.toString();
                    if (context.getTransaction() != null) {
                        context.getTransaction().markAsRollbackOnly((ActiveMQException)new ActiveMQDuplicateIdException(warnMessage));
                    }
                    message.usageDown();
                    return false;
                }
            }
            if (cache != null && !isDuplicate) {
                if (context.getTransaction() == null) {
                    context.setTransaction(new TransactionImpl(this.storageManager));
                    startedTX.set(true);
                }
                cache.addToCache(duplicateIDBytes, context.getTransaction(), startedTX.get());
            }
        }
        return true;
    }

    @Override
    public synchronized void startExpiryScanner() {
        if (this.expiryReaperPeriod > 0L) {
            if (this.expiryReaperRunnable != null) {
                this.expiryReaperRunnable.stop();
            }
            this.expiryReaperRunnable = new ExpiryReaper(this.server.getScheduledPool(), (Executor)this.server.getExecutorFactory().getExecutor(), this.expiryReaperPeriod, TimeUnit.MILLISECONDS, false);
            this.expiryReaperRunnable.start();
        }
    }

    @Override
    public synchronized void startAddressQueueScanner() {
        if (this.addressQueueReaperPeriod > 0L) {
            if (this.addressQueueReaperRunnable != null) {
                this.addressQueueReaperRunnable.stop();
            }
            this.addressQueueReaperRunnable = new AddressQueueReaper(this.server.getScheduledPool(), (Executor)this.server.getExecutorFactory().getExecutor(), this.addressQueueReaperPeriod, TimeUnit.MILLISECONDS, false);
            this.addressQueueReaperRunnable.start();
        }
    }

    private Message createQueueInfoMessage(NotificationType type, SimpleString queueName) {
        CoreMessage message = new CoreMessage().initBuffer(50).setMessageID(this.storageManager.generateID());
        message.setAddress(queueName);
        message.putStringProperty(ManagementHelper.HDR_NOTIFICATION_TYPE, new SimpleString(type.toString()));
        long timestamp = System.currentTimeMillis();
        message.putLongProperty(ManagementHelper.HDR_NOTIFICATION_TIMESTAMP, timestamp);
        message.setTimestamp(timestamp);
        return message;
    }

    private Stream<Queue> getLocalQueues() {
        return this.addressManager.getBindings().filter(binding -> binding.getType() == BindingType.LOCAL_QUEUE).map(binding -> (Queue)binding.getBindable());
    }

    @Override
    public Bindings createBindings(SimpleString address) {
        GroupingHandler groupingHandler = this.server.getGroupingHandler();
        BindingsImpl bindings = new BindingsImpl(CompositeAddress.extractAddressName((SimpleString)address), groupingHandler);
        if (groupingHandler != null) {
            groupingHandler.addListener(bindings);
        }
        return bindings;
    }

    public AddressManager getAddressManager() {
        return this.addressManager;
    }

    public ActiveMQServer getServer() {
        return this.server;
    }

    public static final class AddOperation
    implements TransactionOperation {
        private final List<MessageReference> refs;

        AddOperation(List<MessageReference> refs) {
            this.refs = refs;
        }

        @Override
        public void afterCommit(Transaction tx) {
            for (MessageReference ref : this.refs) {
                if (ref.isAlreadyAcked()) continue;
                ref.getQueue().addTail(ref, false);
            }
        }

        @Override
        public void afterPrepare(Transaction tx) {
            for (MessageReference ref : this.refs) {
                if (!ref.isAlreadyAcked()) continue;
                ref.getQueue().referenceHandled(ref);
                ref.getQueue().incrementMesssagesAdded();
            }
        }

        @Override
        public void afterRollback(Transaction tx) {
        }

        @Override
        public void beforeCommit(Transaction tx) throws Exception {
        }

        @Override
        public void beforePrepare(Transaction tx) throws Exception {
        }

        @Override
        public void beforeRollback(Transaction tx) throws Exception {
            for (MessageReference ref : this.refs) {
                ref.getQueue().refDown(ref);
                Message message = ref.getMessage();
                if (!message.isDurable() || !ref.getQueue().isDurable()) continue;
                ref.getQueue().durableDown(message);
            }
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return this.refs;
        }

        @Override
        public List<MessageReference> getListOnConsumer(long consumerID) {
            return Collections.emptyList();
        }
    }

    private final class AddressQueueReaper
    extends ActiveMQScheduledComponent {
        AddressQueueReaper(ScheduledExecutorService scheduledExecutorService, Executor executor, long checkPeriod, TimeUnit timeUnit, boolean onDemand) {
            super(scheduledExecutorService, executor, checkPeriod, timeUnit, onDemand);
        }

        public void run() {
            PostOfficeImpl.this.getLocalQueues().forEach(queue -> {
                if (!queue.isInternalQueue() && QueueManagerImpl.isAutoDelete(queue) && QueueManagerImpl.consumerCountCheck(queue) && QueueManagerImpl.delayCheck(queue) && QueueManagerImpl.messageCountCheck(queue) && this.queueWasUsed((Queue)queue)) {
                    QueueManagerImpl.performAutoDeleteQueue(PostOfficeImpl.this.server, queue);
                }
            });
            Set<SimpleString> addresses = PostOfficeImpl.this.addressManager.getAddresses();
            for (SimpleString address : addresses) {
                AddressInfo addressInfo = PostOfficeImpl.this.getAddressInfo(address);
                AddressSettings settings = (AddressSettings)PostOfficeImpl.this.addressSettingsRepository.getMatch(address.toString());
                try {
                    if (!settings.isAutoDeleteAddresses() || addressInfo == null || !addressInfo.isAutoCreated() || PostOfficeImpl.this.isAddressBound(address) || addressInfo.getBindingRemovedTimestamp() == -1L || System.currentTimeMillis() - addressInfo.getBindingRemovedTimestamp() < settings.getAutoDeleteAddressesDelay()) continue;
                    if (ActiveMQServerLogger.LOGGER.isDebugEnabled()) {
                        ActiveMQServerLogger.LOGGER.debug("deleting auto-created address \"" + address + ".\"");
                    }
                    PostOfficeImpl.this.server.removeAddressInfo(address, null);
                }
                catch (ActiveMQShutdownException e) {
                    logger.debug((Object)e.getMessage(), (Throwable)e);
                }
                catch (Exception e) {
                    if (e instanceof ActiveMQAddressDoesNotExistException && PostOfficeImpl.this.getAddressInfo(address) == null) {
                        logger.debug((Object)e.getMessage(), (Throwable)e);
                        continue;
                    }
                    ActiveMQServerLogger.LOGGER.errorRemovingAutoCreatedQueue(e, address);
                }
            }
        }

        private boolean queueWasUsed(Queue queue) {
            return queue.getMessagesExpired() > 0L || queue.getMessagesAcknowledged() > 0L || queue.getMessagesKilled() > 0L || queue.getConsumerRemovedTimestamp() != -1L;
        }
    }

    private final class ExpiryReaper
    extends ActiveMQScheduledComponent {
        ExpiryReaper(ScheduledExecutorService scheduledExecutorService, Executor executor, long checkPeriod, TimeUnit timeUnit, boolean onDemand) {
            super(scheduledExecutorService, executor, checkPeriod, timeUnit, onDemand);
        }

        public void run() {
            for (Queue queue : IterableStream.iterableOf((Stream)PostOfficeImpl.this.getLocalQueues())) {
                try {
                    queue.expireReferences();
                }
                catch (Exception e) {
                    ActiveMQServerLogger.LOGGER.errorExpiringMessages(e);
                }
            }
        }
    }

    private static class PageDelivery
    extends TransactionOperationAbstract {
        private final Set<Queue> queues = new HashSet<Queue>();

        private PageDelivery() {
        }

        public void addQueues(List<Queue> queueList) {
            this.queues.addAll(queueList);
        }

        @Override
        public void afterCommit(Transaction tx) {
            for (Queue queue : this.queues) {
                queue.deliverAsync();
            }
        }

        @Override
        public List<MessageReference> getRelatedMessageReferences() {
            return Collections.emptyList();
        }
    }
}

