/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.clustering.marshalling.protostream.util;

import java.io.IOException;
import java.util.Comparator;
import org.wildfly.clustering.marshalling.protostream.Any;
import org.wildfly.clustering.marshalling.protostream.FieldSetMarshaller;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamReader;
import org.wildfly.clustering.marshalling.protostream.ProtoStreamWriter;

public enum ComparatorMarshaller implements FieldSetMarshaller<Comparator<?>, Comparator<?>>
{
    INSTANCE;

    private static final int REVERSE_INDEX = 0;
    private static final int COMPARATOR_INDEX = 1;
    private static final int FIELDS = 2;

    @Override
    public Comparator<?> getBuilder() {
        return Comparator.naturalOrder();
    }

    @Override
    public int getFields() {
        return 2;
    }

    @Override
    public Comparator<?> readField(ProtoStreamReader reader, int index, Comparator<?> comparator) throws IOException {
        switch (index) {
            case 0: {
                return reader.readBool() ? Comparator.reverseOrder() : Comparator.naturalOrder();
            }
            case 1: {
                return (Comparator)reader.readObject(Any.class).get();
            }
        }
        throw new IllegalArgumentException(Integer.toString(index));
    }

    @Override
    public void writeFields(ProtoStreamWriter writer, int startIndex, Comparator<?> comparator) throws IOException {
        boolean reverse;
        boolean natural = comparator == Comparator.naturalOrder();
        boolean bl = reverse = comparator == Comparator.reverseOrder();
        if (natural || reverse) {
            writer.writeBool(startIndex + 0, reverse);
        } else {
            writer.writeObject(startIndex + 1, new Any(comparator));
        }
    }
}

