/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.search.spi.impl;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.hibernate.search.exception.AssertionFailure;
import org.hibernate.search.spi.IndexedTypeIdentifier;
import org.hibernate.search.spi.IndexedTypeSet;

final class HashSetIndexedTypeSet
implements IndexedTypeSet,
Serializable {
    public static final IndexedTypeSet EMPTY = new HashSetIndexedTypeSet(Collections.EMPTY_SET);
    private final Set<IndexedTypeIdentifier> set;

    HashSetIndexedTypeSet(IndexedTypeIdentifier singleton) {
        Objects.requireNonNull(singleton);
        this.set = Collections.singleton(singleton);
    }

    HashSetIndexedTypeSet(Set<IndexedTypeIdentifier> set) {
        Objects.requireNonNull(set);
        if (set.size() == 1) {
            throw new AssertionFailure("singleton sets should not be constructed using this implementation");
        }
        this.set = set;
    }

    @Override
    public Iterator<IndexedTypeIdentifier> iterator() {
        return this.set.iterator();
    }

    @Override
    public int size() {
        return this.set.size();
    }

    @Override
    public boolean isEmpty() {
        return this.set.isEmpty();
    }

    @Override
    @Deprecated
    public Set<Class<?>> toPojosSet() {
        return this.set.stream().map(IndexedTypeIdentifier::getPojoType).collect(Collectors.toSet());
    }

    boolean contains(IndexedTypeIdentifier id) {
        return this.set.contains(id);
    }

    Set<IndexedTypeIdentifier> cloneInternalSet() {
        return new HashSet<IndexedTypeIdentifier>(this.set);
    }

    public String toString() {
        return this.set.toString();
    }

    public int hashCode() {
        return this.set.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (HashSetIndexedTypeSet.class != obj.getClass()) {
            return false;
        }
        HashSetIndexedTypeSet other = (HashSetIndexedTypeSet)obj;
        return this.set.equals(other.set);
    }

    @Override
    public boolean containsAll(IndexedTypeSet subsetCandidate) {
        for (IndexedTypeIdentifier e : subsetCandidate) {
            if (this.set.contains(e)) continue;
            return false;
        }
        return true;
    }
}

