/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.wsf.stack.cxf.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.cxf.helpers.FileUtils;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.tools.common.ToolContext;
import org.apache.cxf.tools.wsdlto.WSDLToJava;
import org.jboss.ws.api.tools.WSContractConsumer;
import org.jboss.ws.common.utils.NullPrintStream;
import org.jboss.wsf.stack.cxf.i18n.Messages;
import org.jboss.wsf.stack.cxf.tools.JBossModulesAwareCompiler;
import org.jboss.wsf.stack.cxf.tools.Jdk9PlusJBossModulesAwareCompiler;

public class CXFConsumerImpl
extends WSContractConsumer {
    private List<File> bindingFiles = null;
    private File catalog = null;
    private File clientJar = null;
    private boolean extension;
    private boolean generateSource = false;
    private File outputDir = new File("output");
    private File sourceDir = null;
    private String targetPackage = null;
    private PrintStream messageStream = null;
    private String wsdlLocation = null;
    private String encoding = null;
    private List<String> additionalCompilerClassPath = new ArrayList<String>();
    private boolean additionalHeaders = false;
    private String target;
    private boolean nocompile = false;

    public void setBindingFiles(List<File> bindingFiles) {
        this.bindingFiles = bindingFiles;
    }

    public void setCatalog(File catalog) {
        this.catalog = catalog;
    }

    public void setExtension(boolean extension) {
        this.extension = extension;
    }

    public void setGenerateSource(boolean generateSource) {
        this.generateSource = generateSource;
    }

    public void setMessageStream(PrintStream messageStream) {
        this.messageStream = messageStream;
    }

    public void setOutputDirectory(File directory) {
        this.outputDir = directory;
    }

    public void setSourceDirectory(File directory) {
        this.sourceDir = directory;
    }

    public void setTargetPackage(String targetPackage) {
        this.targetPackage = targetPackage;
    }

    public void setWsdlLocation(String wsdlLocation) {
        this.wsdlLocation = wsdlLocation;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public void setAdditionalCompilerClassPath(List<String> additionalCompilerClassPath) {
        this.additionalCompilerClassPath = additionalCompilerClassPath;
    }

    public void setAdditionalHeaders(boolean additionalHeaders) {
        this.additionalHeaders = additionalHeaders;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setNoCompile(boolean nocompile) {
        this.nocompile = nocompile;
    }

    public void setClientJar(File clientJar) {
        this.clientJar = clientJar;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void consume(URL wsdl) {
        block74: {
            ArrayList<String> args = new ArrayList<String>();
            PrintStream stream = this.messageStream;
            boolean verbose = false;
            if (stream != null) {
                verbose = true;
            } else {
                stream = NullPrintStream.getInstance();
            }
            if ("2.1".equals(this.target)) {
                args.add("-frontend");
                args.add("jaxws21");
            } else if (this.target != null && !this.target.equals("2.2")) {
                stream.println(Messages.MESSAGES.unsupportedTargetUsingDefault(this.target, "2.2"));
            }
            if (this.bindingFiles != null) {
                for (File file : this.bindingFiles) {
                    args.add("-b");
                    args.add(file.getAbsolutePath());
                }
            }
            if (this.catalog != null) {
                args.add("-catalog");
                args.add(this.catalog.getAbsolutePath());
            }
            if (this.clientJar != null) {
                args.add("-clientjar");
                args.add(this.clientJar.getName());
            }
            if (!this.nocompile) {
                args.add("-compile");
            }
            args.add("-exsh");
            args.add(this.additionalHeaders ? "true" : "false");
            if (this.targetPackage != null) {
                args.add("-p");
                args.add(this.targetPackage);
            }
            File sourceTempDir = null;
            if (this.generateSource) {
                if (this.sourceDir == null) {
                    this.sourceDir = this.outputDir;
                }
                if (!this.sourceDir.exists() && !this.sourceDir.mkdirs()) {
                    throw Messages.MESSAGES.couldNotMakeDirectory(this.sourceDir.getName());
                }
                args.add("-d");
                args.add(this.sourceDir.getAbsolutePath());
            } else {
                sourceTempDir = new File(this.outputDir, "tmp" + Math.round(Math.random() * 1.0E7));
                FileUtils.mkDir((File)sourceTempDir);
                args.add("-d");
                args.add(sourceTempDir.getAbsolutePath());
            }
            if (this.wsdlLocation != null) {
                args.add("-wsdlLocation");
                args.add(this.wsdlLocation);
            }
            if (verbose) {
                args.add("-verbose");
            }
            if (this.encoding != null) {
                args.add("-encoding");
                args.add(this.encoding);
            }
            if (this.extension) {
                stream.println("TODO! Cheek SOAP 1.2 extension");
            }
            if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
                throw Messages.MESSAGES.couldNotMakeDirectory(this.outputDir.getName());
            }
            if (!this.nocompile) {
                args.add("-classdir");
                args.add(this.outputDir.getAbsolutePath());
            }
            args.add("-allowElementReferences");
            args.add(wsdl.toString());
            if (!this.additionalCompilerClassPath.isEmpty()) {
                StringBuffer javaCP = new StringBuffer();
                for (String s : this.additionalCompilerClassPath) {
                    javaCP.append(s).append(File.pathSeparator);
                }
                System.setProperty("java.class.path", javaCP.toString());
            }
            WSDLToJava w2j = new WSDLToJava(args.toArray(new String[0]));
            try {
                File[] ctx = new ToolContext();
                if (CXFConsumerImpl.getJVMMajorVersion() > 8) {
                    ctx.put("compiler", (Object)new Jdk9PlusJBossModulesAwareCompiler());
                } else {
                    ctx.put("compiler", (Object)new JBossModulesAwareCompiler());
                }
                w2j.run((ToolContext)ctx, (OutputStream)stream);
                if (sourceTempDir == null) break block74;
            }
            catch (Throwable t) {
                try {
                    if (this.messageStream != null) {
                        this.messageStream.println(Messages.MESSAGES.failedToInvoke(WSDLToJava.class.getName()));
                        t.printStackTrace(this.messageStream);
                    } else {
                        t.printStackTrace();
                    }
                    if (sourceTempDir == null) break block74;
                }
                catch (Throwable throwable) {
                    if (sourceTempDir != null) {
                        for (File file : sourceTempDir.listFiles(new FilenameFilter(){

                            @Override
                            public boolean accept(File dir, String name) {
                                return !name.endsWith(".java");
                            }
                        })) {
                            try (FileInputStream input2 = new FileInputStream(file);
                                 FileOutputStream output = new FileOutputStream(new File(this.outputDir, file.getName()));){
                                IOUtils.copy((InputStream)input2, (OutputStream)output);
                            }
                            catch (FileNotFoundException input2) {
                            }
                            catch (IOException e) {
                                throw new RuntimeException(e);
                            }
                        }
                        FileUtils.removeDir((File)sourceTempDir);
                    }
                    throw throwable;
                }
                for (File file : sourceTempDir.listFiles(new /* invalid duplicate definition of identical inner class */)) {
                    try (FileInputStream input3 = new FileInputStream(file);
                         FileOutputStream output = new FileOutputStream(new File(this.outputDir, file.getName()));){
                        IOUtils.copy((InputStream)input3, (OutputStream)output);
                    }
                    catch (FileNotFoundException input3) {
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                FileUtils.removeDir((File)sourceTempDir);
            }
            for (File file : sourceTempDir.listFiles(new /* invalid duplicate definition of identical inner class */)) {
                try (FileInputStream input4 = new FileInputStream(file);
                     FileOutputStream output = new FileOutputStream(new File(this.outputDir, file.getName()));){
                    IOUtils.copy((InputStream)input4, (OutputStream)output);
                }
                catch (FileNotFoundException input4) {
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
            FileUtils.removeDir((File)sourceTempDir);
        }
    }

    protected static int getJVMMajorVersion() {
        try {
            String vmVersionStr = System.getProperty("java.specification.version", null);
            Matcher matcher = Pattern.compile("^(?:1\\.)?(\\d+)$").matcher(vmVersionStr);
            if (matcher.find()) {
                return Integer.valueOf(matcher.group(1));
            }
            throw new RuntimeException("Unknown version of jvm " + vmVersionStr);
        }
        catch (Exception e) {
            return 8;
        }
    }
}

