/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.remoting;

import io.undertow.server.ListenerRegistry;
import io.undertow.server.handlers.ChannelUpgradeHandler;
import io.undertow.server.handlers.HttpUpgradeHandshake;
import java.io.IOException;
import java.security.Permission;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.security.sasl.SaslServerFactory;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.network.SocketBinding;
import org.jboss.as.remoting.Protocol;
import org.jboss.as.remoting.RemotingConnectorBindingInfoService;
import org.jboss.as.remoting.RemotingServices;
import org.jboss.as.remoting.SimpleHttpUpgradeHandshake;
import org.jboss.as.remoting.logging.RemotingLogger;
import org.jboss.msc.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.ServiceTarget;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.remoting3.Endpoint;
import org.jboss.remoting3.UnknownURISchemeException;
import org.jboss.remoting3.spi.ExternalConnectionProvider;
import org.wildfly.security.auth.permission.LoginPermission;
import org.wildfly.security.auth.server.MechanismConfiguration;
import org.wildfly.security.auth.server.SaslAuthenticationFactory;
import org.wildfly.security.auth.server.SecurityDomain;
import org.wildfly.security.auth.server.SecurityRealm;
import org.wildfly.security.permission.PermissionUtil;
import org.wildfly.security.permission.PermissionVerifier;
import org.wildfly.security.sasl.anonymous.AnonymousServerFactory;
import org.xnio.ChannelListener;
import org.xnio.OptionMap;
import org.xnio.StreamConnection;

public class RemotingHttpUpgradeService
implements Service {
    public static final String JBOSS_REMOTING = "jboss-remoting";
    private static final String[] ADDITIONAL_PERMISSION = new String[]{"org.wildfly.transaction.client.RemoteTransactionPermission", "org.jboss.ejb.client.RemoteEJBPermission"};
    public static final String MAGIC_NUMBER = "CF70DEB8-70F9-4FBA-8B4F-DFC3E723B4CD";
    public static final String SEC_JBOSS_REMOTING_KEY = "Sec-JbossRemoting-Key";
    public static final String SEC_JBOSS_REMOTING_ACCEPT = "Sec-JbossRemoting-Accept";
    public static final ServiceName HTTP_UPGRADE_REGISTRY = ServiceName.JBOSS.append(new String[]{"http-upgrade-registry"});
    public static final ServiceName UPGRADE_SERVICE_NAME = ServiceName.JBOSS.append(new String[]{"remoting", "remoting-http-upgrade-service"});
    private final String httpConnectorName;
    private final String endpointName;
    private final Consumer<RemotingHttpUpgradeService> serviceConsumer;
    private final Supplier<ChannelUpgradeHandler> upgradeRegistrySupplier;
    private final Supplier<ListenerRegistry> listenerRegistrySupplier;
    private final Supplier<Endpoint> endpointSupplier;
    private final Supplier<SaslAuthenticationFactory> saslAuthenticationFactorySupplier;
    private final OptionMap connectorPropertiesOptionMap;
    private ListenerRegistry.HttpUpgradeMetadata httpUpgradeMetadata;

    public RemotingHttpUpgradeService(Consumer<RemotingHttpUpgradeService> serviceConsumer, Supplier<ChannelUpgradeHandler> upgradeRegistrySupplier, Supplier<ListenerRegistry> listenerRegistrySupplier, Supplier<Endpoint> endpointSupplier, Supplier<SaslAuthenticationFactory> saslAuthenticationFactorySupplier, String httpConnectorName, String endpointName, OptionMap connectorPropertiesOptionMap) {
        this.serviceConsumer = serviceConsumer;
        this.upgradeRegistrySupplier = upgradeRegistrySupplier;
        this.listenerRegistrySupplier = listenerRegistrySupplier;
        this.endpointSupplier = endpointSupplier;
        this.saslAuthenticationFactorySupplier = saslAuthenticationFactorySupplier;
        this.httpConnectorName = httpConnectorName;
        this.endpointName = endpointName;
        this.connectorPropertiesOptionMap = connectorPropertiesOptionMap;
    }

    public static void installServices(OperationContext context, String remotingConnectorName, String httpConnectorName, ServiceName endpointName, OptionMap connectorPropertiesOptionMap, String saslAuthenticationFactory) {
        ServiceTarget serviceTarget = context.getServiceTarget();
        ServiceName serviceName = UPGRADE_SERVICE_NAME.append(new String[]{remotingConnectorName});
        ServiceBuilder sb = serviceTarget.addService(serviceName);
        Consumer serviceConsumer = sb.provides(new ServiceName[]{serviceName});
        Supplier urSupplier = sb.requires(HTTP_UPGRADE_REGISTRY.append(new String[]{httpConnectorName}));
        Supplier lrSupplier = sb.requires(RemotingServices.HTTP_LISTENER_REGISTRY);
        Supplier eSupplier = sb.requires(endpointName);
        Supplier safSupplier = saslAuthenticationFactory != null ? sb.requires(context.getCapabilityServiceName("org.wildfly.security.sasl-authentication-factory", saslAuthenticationFactory, SaslAuthenticationFactory.class)) : null;
        sb.setInstance((Service)new RemotingHttpUpgradeService(serviceConsumer, urSupplier, lrSupplier, eSupplier, safSupplier, httpConnectorName, endpointName.getSimpleName(), connectorPropertiesOptionMap));
        sb.setInitialMode(ServiceController.Mode.ACTIVE);
        sb.install();
    }

    public synchronized void start(StartContext context) throws StartException {
        Endpoint endpoint = this.endpointSupplier.get();
        OptionMap.Builder builder = OptionMap.builder();
        ListenerRegistry.Listener listenerInfo = this.listenerRegistrySupplier.get().getListener(this.httpConnectorName);
        assert (listenerInfo != null);
        this.httpUpgradeMetadata = new ListenerRegistry.HttpUpgradeMetadata(JBOSS_REMOTING, this.endpointName);
        listenerInfo.addHttpUpgradeMetadata(this.httpUpgradeMetadata);
        RemotingConnectorBindingInfoService.install(context.getChildTarget(), context.getController().getName().getSimpleName(), (SocketBinding)listenerInfo.getContextInformation("socket-binding"), listenerInfo.getProtocol().equals("https") ? Protocol.REMOTE_HTTPS : Protocol.REMOTE_HTTP);
        if (this.connectorPropertiesOptionMap != null) {
            builder.addAll(this.connectorPropertiesOptionMap);
        }
        OptionMap resultingMap = builder.getMap();
        try {
            SaslAuthenticationFactory saslAuthenticationFactory;
            ExternalConnectionProvider provider = (ExternalConnectionProvider)endpoint.getConnectionProviderInterface(Protocol.HTTP_REMOTING.toString(), ExternalConnectionProvider.class);
            SaslAuthenticationFactory saslAuthenticationFactory2 = saslAuthenticationFactory = this.saslAuthenticationFactorySupplier != null ? this.saslAuthenticationFactorySupplier.get() : null;
            if (saslAuthenticationFactory == null) {
                RemotingLogger.ROOT_LOGGER.warn("****** All authentication is ANONYMOUS for " + this.getClass().getName());
                SecurityDomain.Builder domainBuilder = SecurityDomain.builder();
                domainBuilder.addRealm("default", SecurityRealm.EMPTY_REALM).build();
                domainBuilder.setDefaultRealmName("default");
                domainBuilder.setPermissionMapper((permissionMappable, roles) -> RemotingHttpUpgradeService.createPermissionVerifier());
                SaslAuthenticationFactory.Builder authBuilder = SaslAuthenticationFactory.builder();
                authBuilder.setSecurityDomain(domainBuilder.build());
                authBuilder.setFactory((SaslServerFactory)new AnonymousServerFactory());
                authBuilder.setMechanismConfigurationSelector(mechanismInformation -> MechanismConfiguration.EMPTY);
                saslAuthenticationFactory = authBuilder.build();
            }
            final Consumer adaptor = provider.createConnectionAdaptor(resultingMap, saslAuthenticationFactory);
            this.upgradeRegistrySupplier.get().addProtocol(JBOSS_REMOTING, (ChannelListener)new ChannelListener<StreamConnection>(){

                public void handleEvent(StreamConnection channel) {
                    adaptor.accept(channel);
                }
            }, (HttpUpgradeHandshake)new SimpleHttpUpgradeHandshake(MAGIC_NUMBER, SEC_JBOSS_REMOTING_KEY, SEC_JBOSS_REMOTING_ACCEPT));
            this.serviceConsumer.accept(this);
        }
        catch (UnknownURISchemeException e) {
            throw new StartException((Throwable)e);
        }
        catch (IOException e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        this.serviceConsumer.accept(null);
        this.listenerRegistrySupplier.get().getListener(this.httpConnectorName).removeHttpUpgradeMetadata(this.httpUpgradeMetadata);
        this.httpUpgradeMetadata = null;
        this.upgradeRegistrySupplier.get().removeProtocol(JBOSS_REMOTING);
    }

    private static PermissionVerifier createPermissionVerifier() {
        LoginPermission permissionVerifier = LoginPermission.getInstance();
        for (String permissionName : ADDITIONAL_PERMISSION) {
            try {
                Permission permission = PermissionUtil.createPermission((ClassLoader)RemotingHttpUpgradeService.class.getClassLoader(), (String)permissionName, null, null);
                permissionVerifier = permissionVerifier.or(PermissionVerifier.from((Permission)permission));
            }
            catch (Exception e) {
                RemotingLogger.ROOT_LOGGER.tracef(e, "Unable to create permission '%s'", permissionName);
            }
        }
        return permissionVerifier;
    }
}

