/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.cli.gui.component;

import java.util.ArrayList;
import java.util.List;
import javax.swing.JRadioButton;
import org.jboss.as.cli.gui.CliGuiContext;
import org.jboss.as.cli.gui.component.StandaloneDeploymentTableModel;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;

public class DomainDeploymentTableModel
extends StandaloneDeploymentTableModel {
    private CliGuiContext cliGuiCtx;

    public DomainDeploymentTableModel(CliGuiContext cliGuiCtx) {
        super(cliGuiCtx);
        this.cliGuiCtx = cliGuiCtx;
        this.colNames = new String[]{"Name", "Runtime Name", "Assigned Server Groups"};
        this.initializeServerGroups();
        this.setServerGroups();
    }

    private void initializeServerGroups() {
        for (Object[] deployment : this.data) {
            deployment[2] = new ArrayList();
        }
    }

    private void setServerGroups() {
        ModelNode deploymentsQuery = null;
        String queryString = "/server-group=*/deployment=*/:read-resource";
        try {
            deploymentsQuery = this.cliGuiCtx.getExecutor().doCommand(queryString);
            if (deploymentsQuery.get("outcome").asString().equals("failed")) {
                return;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return;
        }
        for (ModelNode node : deploymentsQuery.get("result").asList()) {
            String serverGroup = ((Property)node.get("address").asPropertyList().get(0)).getValue().asString();
            ModelNode deploymentNode = node.get("result");
            Object[] deployment = this.findDeployment(deploymentNode.get("name").asString());
            List serverGroups = (List)deployment[2];
            Boolean enabled = deploymentNode.get("enabled").asBoolean();
            if (!enabled.booleanValue()) {
                serverGroup = serverGroup + " (disabled)";
            }
            serverGroups.add(serverGroup);
        }
    }

    private Object[] findDeployment(String name) {
        for (Object[] deployment : this.data) {
            JRadioButton nameButton = (JRadioButton)deployment[0];
            if (!nameButton.getText().equals(name)) continue;
            return deployment;
        }
        throw new IllegalStateException("Deployment " + name + " exists in server group but not in content repository.");
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        if (columnIndex == 0) {
            return JRadioButton.class;
        }
        if (columnIndex == 2) {
            return List.class;
        }
        return String.class;
    }
}

