/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jaxrs.deployment;

import java.util.ArrayList;
import org.jboss.as.controller.capability.CapabilityServiceSupport;
import org.jboss.as.jaxrs.JaxrsSubsystemDefinition;
import org.jboss.as.server.deployment.Attachments;
import org.jboss.as.server.deployment.DeploymentPhaseContext;
import org.jboss.as.server.deployment.DeploymentUnit;
import org.jboss.as.server.deployment.DeploymentUnitProcessingException;
import org.jboss.as.server.deployment.DeploymentUnitProcessor;
import org.jboss.as.server.deployment.module.ModuleDependency;
import org.jboss.as.server.deployment.module.ModuleSpecification;
import org.jboss.as.server.deployment.module.ResourceRoot;
import org.jboss.as.weld.WeldCapability;
import org.jboss.modules.Module;
import org.jboss.modules.ModuleIdentifier;
import org.jboss.modules.ModuleLoader;
import org.jboss.modules.filter.PathFilters;
import org.jboss.vfs.VirtualFile;

public class JaxrsDependencyProcessor
implements DeploymentUnitProcessor {
    private static final String CLIENT_BUILDER = "META-INF/services/javax.ws.rs.client.ClientBuilder";

    public void deploy(DeploymentPhaseContext phaseContext) throws DeploymentUnitProcessingException {
        WeldCapability api;
        DeploymentUnit deploymentUnit = phaseContext.getDeploymentUnit();
        ModuleSpecification moduleSpecification = (ModuleSpecification)deploymentUnit.getAttachment(Attachments.MODULE_SPECIFICATION);
        boolean deploymentBundlesClientBuilder = this.isClientBuilderInDeployment(deploymentUnit);
        ModuleLoader moduleLoader = Module.getBootModuleLoader();
        this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.JAXRS_API, false, false);
        this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.JAXB_API, false, false);
        this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.JSON_API, false, false);
        this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.RESTEASY_ATOM, true, false);
        this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.RESTEASY_VALIDATOR, true, false);
        this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.RESTEASY_CLIENT, true, deploymentBundlesClientBuilder);
        this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.RESTEASY_CLIENT_API, true, deploymentBundlesClientBuilder);
        this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.RESTEASY_CORE, true, deploymentBundlesClientBuilder);
        this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.RESTEASY_CORE_SPI, true, deploymentBundlesClientBuilder);
        this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.RESTEASY_CLIENT_MICROPROFILE, true, false);
        this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.RESTEASY_JAXB, true, false);
        this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.RESTEASY_JACKSON2, true, false);
        this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.RESTEASY_JSON_P_PROVIDER, true, false);
        this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.RESTEASY_JSON_B_PROVIDER, true, false);
        this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.RESTEASY_JSAPI, true, false);
        this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.RESTEASY_MULTIPART, true, false);
        this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.RESTEASY_CRYPTO, true, false);
        this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.JACKSON_DATATYPE_JDK8, true, false);
        this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.JACKSON_DATATYPE_JSR310, true, false);
        this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.MP_REST_CLIENT, true, false);
        CapabilityServiceSupport support = (CapabilityServiceSupport)deploymentUnit.getAttachment(Attachments.CAPABILITY_SERVICE_SUPPORT);
        if (support.hasCapability("org.wildfly.weld") && (api = (WeldCapability)support.getOptionalCapabilityRuntimeAPI("org.wildfly.weld", WeldCapability.class).get()).isPartOfWeldDeployment(deploymentUnit)) {
            this.addDependency(moduleSpecification, moduleLoader, JaxrsSubsystemDefinition.RESTEASY_CDI, true, false);
        }
    }

    private boolean isClientBuilderInDeployment(DeploymentUnit deploymentUnit) {
        ResourceRoot root = (ResourceRoot)deploymentUnit.getAttachment(Attachments.DEPLOYMENT_ROOT);
        ArrayList<ResourceRoot> roots = new ArrayList<ResourceRoot>(deploymentUnit.getAttachmentList(Attachments.RESOURCE_ROOTS));
        roots.add(root);
        for (ResourceRoot r : roots) {
            VirtualFile file = r.getRoot().getChild(CLIENT_BUILDER);
            if (!file.exists()) continue;
            return true;
        }
        return false;
    }

    private void addDependency(ModuleSpecification moduleSpecification, ModuleLoader moduleLoader, ModuleIdentifier moduleIdentifier, boolean optional, boolean deploymentBundelesClientBuilder) {
        ModuleDependency dependency = new ModuleDependency(moduleLoader, moduleIdentifier, optional, false, true, false);
        if (deploymentBundelesClientBuilder) {
            dependency.addImportFilter(PathFilters.is((String)CLIENT_BUILDER), false);
        }
        moduleSpecification.addSystemDependency(dependency);
    }

    public void undeploy(DeploymentUnit context) {
    }
}

