/*
 * Decompiled with CFR 0.152.
 */
package org.apache.activemq.artemis.tools.migrate.config;

import java.io.File;
import org.apache.activemq.artemis.tools.migrate.config.XMLConfigurationMigration;

public class Main {
    public static void main(String[] args) throws Exception {
        if (args.length == 0) {
            System.err.println("Invalid args");
            Main.printUsage();
        } else {
            File input = new File(args[0]);
            if (input.isDirectory()) {
                System.out.println("Scanning directory: " + input.getAbsolutePath());
                Main.scanAndTransform(input);
            } else if (args.length != 2) {
                System.err.println("Invalid args");
                Main.printUsage();
            } else {
                try {
                    XMLConfigurationMigration migration = new XMLConfigurationMigration(input, new File(args[1]));
                    migration.transform();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private static void recursiveTransform(File root) throws Exception {
        for (File file : root.listFiles()) {
            Main.scanAndTransform(file);
        }
    }

    public static void scanAndTransform(File f) throws Exception {
        block6: {
            try {
                if (f.isDirectory()) {
                    Main.recursiveTransform(f);
                    break block6;
                }
                try {
                    File file;
                    XMLConfigurationMigration migration;
                    if (f.getName().endsWith("xml") && (migration = new XMLConfigurationMigration(f, file = new File(f.getAbsolutePath() + ".new"))).transform()) {
                        File r = new File(f.getAbsolutePath());
                        f.renameTo(new File(f.getAbsolutePath() + ".bk"));
                        file.renameTo(r);
                        System.out.println(f + " converted, old file renamed as " + f.getAbsolutePath() + ".bk");
                    }
                }
                catch (Exception file) {}
            }
            catch (NullPointerException e) {
                System.out.println(f.getAbsoluteFile());
            }
        }
    }

    public static void printUsage() {
        System.out.println("Please specify a directory to scan, or input and output file");
    }
}

