/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.as.jsf.injection;

import java.lang.annotation.Annotation;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.faces.bean.ManagedBean;
import javax.faces.component.FacesComponent;
import javax.faces.component.behavior.FacesBehavior;
import javax.faces.context.ExternalContext;
import javax.faces.convert.FacesConverter;
import javax.faces.event.NamedEvent;
import javax.faces.render.FacesBehaviorRenderer;
import javax.faces.render.FacesRenderer;
import javax.faces.validator.FacesValidator;
import javax.servlet.ServletContext;

public class AnnotationMap {
    public static final String FACES_ANNOTATIONS_SC_ATTR = "org.jboss.as.jsf.FACES_ANNOTATIONS";
    private static final String ANNOTATION_MAP_CONVERTED = "org.jboss.as.jsf.ANNOTATION_MAP_CONVERTED";
    private static final Map<String, Class<? extends Annotation>> stringToAnnoMap = new HashMap<String, Class<? extends Annotation>>();

    private AnnotationMap() {
    }

    private static void addAnnotationIfPresent(ClassLoader loader, String name) {
        try {
            Class<?> clazz = loader.loadClass(name);
            if (Annotation.class.isAssignableFrom(clazz)) {
                stringToAnnoMap.put(name, clazz);
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public static Map<Class<? extends Annotation>, Set<Class<?>>> get(ExternalContext extContext) {
        Map appMap = extContext.getApplicationMap();
        if (appMap.get(ANNOTATION_MAP_CONVERTED) != null) {
            return (Map)appMap.get(FACES_ANNOTATIONS_SC_ATTR);
        }
        appMap.put(ANNOTATION_MAP_CONVERTED, Boolean.TRUE);
        return AnnotationMap.convert((Map)appMap.get(FACES_ANNOTATIONS_SC_ATTR));
    }

    public static Map<Class<? extends Annotation>, Set<Class<?>>> get(ServletContext servletContext) {
        Map annotations = (Map)servletContext.getAttribute(FACES_ANNOTATIONS_SC_ATTR);
        if (servletContext.getAttribute(ANNOTATION_MAP_CONVERTED) != null) {
            return annotations;
        }
        servletContext.setAttribute(ANNOTATION_MAP_CONVERTED, (Object)Boolean.TRUE);
        return AnnotationMap.convert(annotations);
    }

    private static Map<Class<? extends Annotation>, Set<Class<?>>> convert(Map<Class<? extends Annotation>, Set<Class<?>>> annotations) {
        HashMap convertedAnnotatedClasses = new HashMap();
        for (Map.Entry<Class<Annotation>, Set<Class<?>>> entry : annotations.entrySet()) {
            Class<? extends Annotation> annotation = entry.getKey();
            Set<Class<?>> annotated = entry.getValue();
            Class<? extends Annotation> knownAnnotation = stringToAnnoMap.get(annotation.getName());
            if (knownAnnotation != null) {
                convertedAnnotatedClasses.put(knownAnnotation, annotated);
                continue;
            }
            convertedAnnotatedClasses.put(annotation, annotated);
        }
        return convertedAnnotatedClasses;
    }

    static {
        try {
            stringToAnnoMap.put(FacesComponent.class.getName(), FacesComponent.class);
            stringToAnnoMap.put(FacesConverter.class.getName(), FacesConverter.class);
            stringToAnnoMap.put(FacesValidator.class.getName(), FacesValidator.class);
            stringToAnnoMap.put(FacesRenderer.class.getName(), FacesRenderer.class);
            stringToAnnoMap.put(ManagedBean.class.getName(), ManagedBean.class);
            stringToAnnoMap.put(NamedEvent.class.getName(), NamedEvent.class);
            stringToAnnoMap.put(FacesBehavior.class.getName(), FacesBehavior.class);
            stringToAnnoMap.put(FacesBehaviorRenderer.class.getName(), FacesBehaviorRenderer.class);
            ClassLoader loader = AnnotationMap.class.getClassLoader();
            AnnotationMap.addAnnotationIfPresent(loader, "javax.faces.view.facelets.FaceletsResourceResolver");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

