/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.ws.rm.soap;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.TimerTask;
import java.util.TreeSet;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.stream.XMLStreamReader;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.apache.cxf.io.CachedOutputStream;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.Phase;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.phase.PhaseManager;
import org.apache.cxf.staxutils.StaxSource;
import org.apache.cxf.ws.rm.DestinationSequence;
import org.apache.cxf.ws.rm.RMCaptureInInterceptor;
import org.apache.cxf.ws.rm.RMContextUtils;
import org.apache.cxf.ws.rm.RMManager;
import org.apache.cxf.ws.rm.RMProperties;
import org.apache.cxf.ws.rm.RedeliveryQueue;
import org.apache.cxf.ws.rm.RetryStatus;
import org.apache.cxf.ws.rm.manager.RetryPolicyType;
import org.apache.cxf.ws.rm.persistence.RMStore;
import org.apache.cxf.ws.rm.v200702.Identifier;
import org.apache.cxf.ws.rm.v200702.SequenceType;
import org.w3c.dom.Node;

public class RedeliveryQueueImpl
implements RedeliveryQueue {
    private static final Logger LOG = LogUtils.getL7dLogger(RedeliveryQueueImpl.class);
    private Map<String, List<RedeliverCandidate>> candidates = new HashMap<String, List<RedeliverCandidate>>();
    private Map<String, List<RedeliverCandidate>> suspendedCandidates = new HashMap<String, List<RedeliverCandidate>>();
    private RMManager manager;
    private int undeliveredCount;

    public RedeliveryQueueImpl(RMManager m) {
        this.manager = m;
    }

    public RMManager getManager() {
        return this.manager;
    }

    public void setManager(RMManager m) {
        this.manager = m;
    }

    @Override
    public void addUndelivered(Message message) {
        this.cacheUndelivered(message);
    }

    @Override
    public synchronized int countUndelivered(DestinationSequence seq) {
        List<RedeliverCandidate> sequenceCandidates = this.getSequenceCandidates(seq);
        return sequenceCandidates == null ? 0 : sequenceCandidates.size();
    }

    @Override
    public int countUndelivered() {
        return this.undeliveredCount;
    }

    @Override
    public boolean isEmpty() {
        return this.getUndelivered().isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeAll(DestinationSequence seq) {
        RMStore store;
        ArrayList<Long> purged = new ArrayList<Long>();
        RedeliveryQueueImpl redeliveryQueueImpl = this;
        synchronized (redeliveryQueueImpl) {
            LOG.fine("Start purging redeliver candidates.");
            List<RedeliverCandidate> sequenceCandidates = this.getSequenceCandidates(seq);
            if (null != sequenceCandidates) {
                for (int i = sequenceCandidates.size() - 1; i >= 0; --i) {
                    RedeliverCandidate candidate = sequenceCandidates.get(i);
                    long m = candidate.getNumber();
                    sequenceCandidates.remove(i);
                    candidate.resolved();
                    --this.undeliveredCount;
                    purged.add(m);
                }
                if (sequenceCandidates.isEmpty()) {
                    this.candidates.remove(seq.getIdentifier().getValue());
                }
            }
            LOG.fine("Completed purging redeliver candidates.");
        }
        if (!purged.isEmpty() && null != (store = this.manager.getStore())) {
            store.removeMessages(seq.getIdentifier(), purged, false);
        }
    }

    @Override
    public List<Long> getUndeliveredMessageNumbers(DestinationSequence seq) {
        ArrayList<Long> undelivered = new ArrayList<Long>();
        List<RedeliverCandidate> sequenceCandidates = this.getSequenceCandidates(seq);
        if (null != sequenceCandidates) {
            for (int i = 0; i < sequenceCandidates.size(); ++i) {
                RedeliverCandidate candidate = sequenceCandidates.get(i);
                RMProperties properties = RMContextUtils.retrieveRMProperties(candidate.getMessage(), false);
                SequenceType st = properties.getSequence();
                undelivered.add(st.getMessageNumber());
            }
        }
        return undelivered;
    }

    protected List<RedeliverCandidate> getSequenceCandidates(DestinationSequence seq) {
        return this.getSequenceCandidates(seq.getIdentifier().getValue());
    }

    protected List<RedeliverCandidate> getSequenceCandidates(String key) {
        List<RedeliverCandidate> sc = this.candidates.get(key);
        if (null == sc) {
            sc = this.suspendedCandidates.get(key);
        }
        return sc;
    }

    protected boolean isSequenceSuspended(String key) {
        return this.suspendedCandidates.containsKey(key);
    }

    @Override
    public RetryStatus getRedeliveryStatus(DestinationSequence seq, long num) {
        List<RedeliverCandidate> sequenceCandidates = this.getSequenceCandidates(seq);
        if (null != sequenceCandidates) {
            for (int i = 0; i < sequenceCandidates.size(); ++i) {
                RedeliverCandidate candidate = sequenceCandidates.get(i);
                RMProperties properties = RMContextUtils.retrieveRMProperties(candidate.getMessage(), false);
                SequenceType st = properties.getSequence();
                if (num != st.getMessageNumber()) continue;
                return candidate;
            }
        }
        return null;
    }

    @Override
    public Map<Long, RetryStatus> getRedeliveryStatuses(DestinationSequence seq) {
        HashMap<Long, RetryStatus> cp = new HashMap<Long, RetryStatus>();
        List<RedeliverCandidate> sequenceCandidates = this.getSequenceCandidates(seq);
        if (null != sequenceCandidates) {
            for (int i = 0; i < sequenceCandidates.size(); ++i) {
                RedeliverCandidate candidate = sequenceCandidates.get(i);
                RMProperties properties = RMContextUtils.retrieveRMProperties(candidate.getMessage(), false);
                SequenceType st = properties.getSequence();
                cp.put(st.getMessageNumber(), candidate);
            }
        }
        return cp;
    }

    @Override
    public void start() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop(DestinationSequence seq) {
        RedeliveryQueueImpl redeliveryQueueImpl = this;
        synchronized (redeliveryQueueImpl) {
            List<RedeliverCandidate> sequenceCandidates = this.getSequenceCandidates(seq);
            if (null != sequenceCandidates) {
                for (int i = sequenceCandidates.size() - 1; i >= 0; --i) {
                    RedeliverCandidate candidate = sequenceCandidates.get(i);
                    candidate.cancel();
                }
                LOG.log(Level.FINE, "Cancelled redeliveriss for sequence {0}.", seq.getIdentifier().getValue());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void suspend(DestinationSequence seq) {
        RedeliveryQueueImpl redeliveryQueueImpl = this;
        synchronized (redeliveryQueueImpl) {
            String key = seq.getIdentifier().getValue();
            List<RedeliverCandidate> sequenceCandidates = this.candidates.remove(key);
            if (null != sequenceCandidates) {
                for (int i = sequenceCandidates.size() - 1; i >= 0; --i) {
                    RedeliverCandidate candidate = sequenceCandidates.get(i);
                    candidate.suspend();
                }
                this.suspendedCandidates.put(key, sequenceCandidates);
                LOG.log(Level.FINE, "Suspended redeliveris for sequence {0}.", key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume(DestinationSequence seq) {
        RedeliveryQueueImpl redeliveryQueueImpl = this;
        synchronized (redeliveryQueueImpl) {
            String key = seq.getIdentifier().getValue();
            List<RedeliverCandidate> sequenceCandidates = this.suspendedCandidates.remove(key);
            if (null != sequenceCandidates) {
                for (int i = 0; i < sequenceCandidates.size(); ++i) {
                    RedeliverCandidate candidate = sequenceCandidates.get(i);
                    candidate.resume();
                }
                this.candidates.put(key, sequenceCandidates);
                LOG.log(Level.FINE, "Resumed redeliveries for sequence {0}.", key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected RedeliverCandidate cacheUndelivered(Message message) {
        RMProperties rmps = RMContextUtils.retrieveRMProperties(message, false);
        SequenceType st = rmps.getSequence();
        Identifier sid = st.getIdentifier();
        String key = sid.getValue();
        RedeliverCandidate candidate = null;
        RedeliveryQueueImpl redeliveryQueueImpl = this;
        synchronized (redeliveryQueueImpl) {
            List<RedeliverCandidate> sequenceCandidates = this.getSequenceCandidates(key);
            if (null == sequenceCandidates) {
                sequenceCandidates = new ArrayList<RedeliverCandidate>();
                this.candidates.put(key, sequenceCandidates);
            }
            if ((candidate = this.getRedeliverCandidate(st, sequenceCandidates)) == null) {
                candidate = new RedeliverCandidate(message);
                if (this.isSequenceSuspended(key)) {
                    candidate.suspend();
                }
                sequenceCandidates.add(candidate);
                ++this.undeliveredCount;
            }
        }
        LOG.fine("Cached undelivered message.");
        return candidate;
    }

    private RedeliverCandidate getRedeliverCandidate(SequenceType st, List<RedeliverCandidate> rcs) {
        for (RedeliverCandidate rc : rcs) {
            if (st.getMessageNumber().longValue() != rc.getNumber()) continue;
            return rc;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void purgeDelivered(RedeliverCandidate candidate) {
        RMProperties rmps = RMContextUtils.retrieveRMProperties(candidate.getMessage(), false);
        SequenceType st = rmps.getSequence();
        Identifier sid = st.getIdentifier();
        String key = sid.getValue();
        RedeliveryQueueImpl redeliveryQueueImpl = this;
        synchronized (redeliveryQueueImpl) {
            List<RedeliverCandidate> sequenceCandidates = this.getSequenceCandidates(key);
            if (null != sequenceCandidates) {
                sequenceCandidates.remove(candidate);
                --this.undeliveredCount;
            }
            if (sequenceCandidates.isEmpty()) {
                this.candidates.remove(sid.getValue());
            }
        }
        LOG.fine("Purged delivered message.");
    }

    protected Map<String, List<RedeliverCandidate>> getUndelivered() {
        return this.candidates;
    }

    private static InterceptorChain getRedeliveryInterceptorChain(Message m, String phase) {
        Phase p;
        Exchange exchange = m.getExchange();
        Endpoint ep = exchange.getEndpoint();
        Bus bus = exchange.getBus();
        PhaseManager pm = (PhaseManager)bus.getExtension(PhaseManager.class);
        TreeSet phases = new TreeSet(pm.getInPhases());
        Iterator it = phases.iterator();
        while (it.hasNext() && !phase.equals((p = (Phase)it.next()).getName())) {
            it.remove();
        }
        PhaseInterceptorChain chain = new PhaseInterceptorChain(phases);
        List il = ep.getInInterceptors();
        RedeliveryQueueImpl.addInterceptors(chain, il);
        il = ep.getService().getInInterceptors();
        RedeliveryQueueImpl.addInterceptors(chain, il);
        il = ep.getBinding().getInInterceptors();
        RedeliveryQueueImpl.addInterceptors(chain, il);
        il = bus.getInInterceptors();
        RedeliveryQueueImpl.addInterceptors(chain, il);
        if (ep.getService().getDataBinding() instanceof InterceptorProvider) {
            il = ((InterceptorProvider)ep.getService().getDataBinding()).getInInterceptors();
            RedeliveryQueueImpl.addInterceptors(chain, il);
        }
        return chain;
    }

    private static void addInterceptors(PhaseInterceptorChain chain, List<Interceptor<? extends Message>> il) {
        for (Interceptor<? extends Message> i : il) {
            String iname = i.getClass().getSimpleName();
            if ("OneWayProcessorInterceptor".equals(iname) || "MAPAggregatorImpl".equals(iname) || "RMInInterceptor".equals(iname)) continue;
            chain.add(i);
        }
    }

    protected class RedeliverCandidate
    implements Runnable,
    RetryStatus {
        private Message message;
        private long number;
        private Date next;
        private TimerTask nextTask;
        private int retries;
        private int maxRetries;
        private long nextInterval;
        private long backoff;
        private boolean pending;
        private boolean suspended;

        protected RedeliverCandidate(Message m) {
            this.message = m;
            if (this.message instanceof SoapMessage) {
                ((SoapMessage)this.message).getHeaders().clear();
            }
            RetryPolicyType rmrp = null != RedeliveryQueueImpl.this.manager.getDestinationPolicy() ? RedeliveryQueueImpl.this.manager.getDestinationPolicy().getRetryPolicy() : null;
            long baseRedeliveryInterval = Long.parseLong("3000");
            if (null != rmrp && rmrp.getInterval() > 0L) {
                baseRedeliveryInterval = rmrp.getInterval();
            }
            this.backoff = rmrp == null || "ExponentialBackoff".equals(rmrp.getAlgorithm()) ? 2L : 1L;
            this.next = new Date(System.currentTimeMillis() + baseRedeliveryInterval);
            this.nextInterval = baseRedeliveryInterval * this.backoff;
            this.maxRetries = null != rmrp ? rmrp.getMaxRetries() : 0;
            RMProperties rmprops = RMContextUtils.retrieveRMProperties(this.message, false);
            if (null != rmprops) {
                this.number = rmprops.getSequence().getMessageNumber();
            }
            if (null != RedeliveryQueueImpl.this.manager.getTimer() && this.maxRetries != 0) {
                this.schedule();
            }
        }

        protected void initiate() {
            this.pending = true;
            Endpoint ep = (Endpoint)this.message.getExchange().get(Endpoint.class);
            Executor executor = ep.getExecutor();
            if (null == executor) {
                executor = ep.getService().getExecutor();
                LOG.log(Level.FINE, "Using service executor {0}", executor.getClass().getName());
            } else {
                LOG.log(Level.FINE, "Using endpoint executor {0}", executor.getClass().getName());
            }
            try {
                executor.execute(this);
            }
            catch (RejectedExecutionException ex) {
                LOG.log(Level.SEVERE, "RESEND_INITIATION_FAILED_MSG", ex);
            }
        }

        @Override
        public void run() {
            try {
                if (this.isPending()) {
                    this.redeliver();
                    RedeliveryQueueImpl.this.purgeDelivered(this);
                    this.resolved();
                }
            }
            catch (Exception ex) {
                LOG.log(Level.WARNING, "redelivery failed", ex);
            }
            finally {
                this.attempted();
            }
        }

        private void redeliver() throws Exception {
            LOG.log(Level.INFO, "Redelivering ... for " + (1 + this.retries));
            if (this.message.getContent(Exception.class) != null) {
                this.message.removeContent(Exception.class);
                this.message.getExchange().put(Exception.class, null);
                this.closeStreamResources();
                this.message.removeContent(Node.class);
            }
            InputStream is = null;
            CachedOutputStream cos = (CachedOutputStream)this.message.get((Object)"org.apache.cxf.ws.rm.content");
            is = cos.getInputStream();
            this.message.setContent(InputStream.class, (Object)is);
            this.message = this.message.getExchange().getEndpoint().getBinding().createMessage(this.message);
            String restartingPhase = "post-stream";
            InterceptorChain chain = RedeliveryQueueImpl.getRedeliveryInterceptorChain(this.message, restartingPhase);
            ListIterator iterator = chain.getIterator();
            while (iterator.hasNext()) {
                Interceptor incept = (Interceptor)iterator.next();
                if (!incept.getClass().getName().equals(RMCaptureInInterceptor.class.getName())) continue;
                chain.remove(incept);
            }
            this.message.getExchange().setInMessage(this.message);
            this.message.setInterceptorChain(chain);
            chain.doIntercept(this.message);
            Exception ex = (Exception)this.message.getContent(Exception.class);
            if (null != ex) {
                throw ex;
            }
        }

        public long getNumber() {
            return this.number;
        }

        @Override
        public Date getNext() {
            return this.next;
        }

        @Override
        public Date getPrevious() {
            if (this.retries > 0) {
                return new Date(this.next.getTime() - this.nextInterval / this.backoff);
            }
            return null;
        }

        @Override
        public int getRetries() {
            return this.retries;
        }

        @Override
        public int getMaxRetries() {
            return this.maxRetries;
        }

        @Override
        public long getNextInterval() {
            return this.nextInterval;
        }

        @Override
        public long getBackoff() {
            return this.backoff;
        }

        @Override
        public boolean isPending() {
            return this.pending;
        }

        @Override
        public boolean isSuspended() {
            return this.suspended;
        }

        protected synchronized void resolved() {
            this.pending = false;
            this.next = null;
            if (null != this.nextTask) {
                this.nextTask.cancel();
            }
        }

        protected void cancel() {
            if (null != this.nextTask) {
                this.nextTask.cancel();
                this.closeStreamResources();
                this.releaseSavedMessage();
            }
        }

        protected void suspend() {
            this.suspended = true;
            this.pending = false;
            if (null != this.nextTask) {
                this.nextTask.cancel();
            }
        }

        protected void resume() {
            this.suspended = false;
            this.next = new Date(System.currentTimeMillis());
            this.attempted();
        }

        private void releaseSavedMessage() {
            Closeable closeable;
            CachedOutputStream saved = (CachedOutputStream)this.message.remove((Object)"org.apache.cxf.ws.rm.content");
            if (saved != null) {
                saved.releaseTempFileHold();
                try {
                    saved.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            if ((closeable = (Closeable)this.message.get((Object)"org.apache.cxf.ws.rm.attachment.closeable")) != null) {
                try {
                    closeable.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }

        private void closeStreamResources() {
            List olist;
            XMLStreamReader oreader;
            InputStream oin = (InputStream)this.message.getContent(InputStream.class);
            if (oin != null) {
                try {
                    oin.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.message.removeContent(InputStream.class);
            }
            if ((oreader = (XMLStreamReader)this.message.getContent(XMLStreamReader.class)) != null) {
                try {
                    oreader.close();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.message.removeContent(XMLStreamReader.class);
            }
            if ((olist = (List)this.message.getContent(List.class)) != null && olist.size() == 1) {
                Object o = olist.get(0);
                if (o instanceof XMLStreamReader) {
                    oreader = (XMLStreamReader)o;
                } else if (o instanceof StaxSource) {
                    oreader = ((StaxSource)o).getXMLStreamReader();
                }
                if (oreader != null) {
                    try {
                        oreader.close();
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                this.message.removeContent(List.class);
            }
        }

        protected Message getMessage() {
            return this.message;
        }

        protected synchronized void attempted() {
            this.pending = false;
            ++this.retries;
            if (null != this.next && this.maxRetries != this.retries) {
                this.next = new Date(this.next.getTime() + this.nextInterval);
                this.nextInterval *= this.backoff;
                this.schedule();
            }
        }

        protected final synchronized void schedule() {
            if (null == RedeliveryQueueImpl.this.manager.getTimer()) {
                return;
            }
            class RedeliverTask
            extends TimerTask {
                RedeliverCandidate candidate;

                RedeliverTask(RedeliverCandidate c) {
                    this.candidate = c;
                }

                @Override
                public void run() {
                    if (!this.candidate.isPending()) {
                        this.candidate.initiate();
                    }
                }
            }
            this.nextTask = new RedeliverTask(this);
            try {
                RedeliveryQueueImpl.this.manager.getTimer().schedule(this.nextTask, this.next);
            }
            catch (IllegalStateException ex) {
                LOG.log(Level.WARNING, "SCHEDULE_RESEND_FAILED_MSG", ex);
            }
        }
    }
}

