/*
 * Decompiled with CFR 0.152.
 */
package org.wildfly.extension.picketlink.idm.model;

import java.util.HashMap;
import java.util.Map;

public enum AttributedTypeEnum {
    PARTITION("Partition", "org.picketlink.idm.model.Partition"),
    IDENTITY_TYPE("IdentityType", "org.picketlink.idm.model.IdentityType"),
    ACCOUNT("Account", "org.picketlink.idm.model.Account"),
    RELATIONSHIP("Relationship", "org.picketlink.idm.model.Relationship"),
    PERMISSION("Permission", "org.picketlink.idm.permission.Permission"),
    REALM("Realm", "org.picketlink.idm.model.basic.Realm"),
    TIER("Tier", "org.picketlink.idm.model.basic.Tier"),
    AGENT("Agent", "org.picketlink.idm.model.basic.Agent"),
    USER("User", "org.picketlink.idm.model.basic.User"),
    ROLE("Role", "org.picketlink.idm.model.basic.Role"),
    GROUP("Group", "org.picketlink.idm.model.basic.Group"),
    GRANT("Grant", "org.picketlink.idm.model.basic.Grant"),
    GROUP_ROLE("GroupRole", "org.picketlink.idm.model.basic.GroupRole"),
    GROUP_MEMBERSHIP("GroupMembership", "org.picketlink.idm.model.basic.GroupMembership");

    private static final Map<String, AttributedTypeEnum> types;
    private final String alias;
    private final String type;

    private AttributedTypeEnum(String alias, String type) {
        this.alias = alias;
        this.type = type;
    }

    public static String forType(String alias) {
        AttributedTypeEnum resolvedType = types.get(alias);
        if (resolvedType != null) {
            return resolvedType.getType();
        }
        return null;
    }

    public String toString() {
        return this.alias;
    }

    public String getAlias() {
        return this.alias;
    }

    String getType() {
        return this.type;
    }

    static {
        types = new HashMap<String, AttributedTypeEnum>();
        for (AttributedTypeEnum element : AttributedTypeEnum.values()) {
            types.put(element.getAlias(), element);
        }
    }
}

