/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sshd.common.config.keys;

import java.security.PrivateKey;
import java.security.PublicKey;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;

public interface OpenSshCertificate
extends PublicKey,
PrivateKey {
    public static final int SSH_CERT_TYPE_USER = 1;
    public static final int SSH_CERT_TYPE_HOST = 2;

    public String getRawKeyType();

    public byte[] getNonce();

    public String getKeyType();

    public PublicKey getServerHostKey();

    public long getSerial();

    public int getType();

    public String getId();

    public Collection<String> getPrincipals();

    public long getValidAfter();

    default public Date getValidAfterDate() {
        return OpenSshCertificate.getValidDate(this.getValidAfter());
    }

    public long getValidBefore();

    default public Date getValidBeforeDate() {
        return OpenSshCertificate.getValidDate(this.getValidBefore());
    }

    public List<String> getCriticalOptions();

    public List<String> getExtensions();

    public String getReserved();

    public PublicKey getCaPubKey();

    public byte[] getMessage();

    public byte[] getSignature();

    public String getSignatureAlg();

    public static Date getValidDate(long timestamp) {
        return timestamp == 0L ? null : new Date(TimeUnit.SECONDS.toMillis(timestamp));
    }
}

