/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.validator.cdi.internal;

import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import javax.enterprise.inject.spi.BeanManager;
import javax.inject.Inject;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorFactory;
import org.hibernate.validator.cdi.internal.DestructibleBeanInstance;
import org.hibernate.validator.internal.util.Contracts;

public class InjectingConstraintValidatorFactory
implements ConstraintValidatorFactory {
    private final Map<Object, DestructibleBeanInstance<?>> constraintValidatorMap = Collections.synchronizedMap(new IdentityHashMap());
    private final BeanManager beanManager;

    @Inject
    public InjectingConstraintValidatorFactory(BeanManager beanManager) {
        Contracts.assertNotNull((Object)beanManager, (String)"The BeanManager cannot be null");
        this.beanManager = beanManager;
    }

    public <T extends ConstraintValidator<?, ?>> T getInstance(Class<T> key) {
        DestructibleBeanInstance<Class<T>> destructibleBeanInstance = new DestructibleBeanInstance<Class<T>>(this.beanManager, key);
        this.constraintValidatorMap.put(destructibleBeanInstance.getInstance(), destructibleBeanInstance);
        return (T)((ConstraintValidator)destructibleBeanInstance.getInstance());
    }

    public void releaseInstance(ConstraintValidator<?, ?> instance) {
        DestructibleBeanInstance<?> destructibleBeanInstance = this.constraintValidatorMap.remove(instance);
        if (destructibleBeanInstance != null) {
            destructibleBeanInstance.destroy();
        }
    }
}

